/*
 * Decompiled with CFR 0.152.
 */
package apoc.load;

import apoc.load.Mapping;
import apoc.load.util.Results;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class CSVResult {
    public long lineNo;
    public List<Object> list;
    public List<String> strings;
    public Map<String, Object> map;
    public Map<String, String> stringMap;

    public CSVResult(String[] header, String[] list, long lineNo, boolean ignore, Map<String, Mapping> mapping, List<String> nullValues, EnumSet<Results> results) {
        this.lineNo = lineNo;
        this.removeNullValues(list, nullValues);
        this.strings = results.contains((Object)Results.strings) ? this.createList(header, list, ignore, mapping, false) : Collections.emptyList();
        this.stringMap = results.contains((Object)Results.stringMap) ? this.createMap(header, list, ignore, mapping, false) : Collections.emptyMap();
        this.map = results.contains((Object)Results.map) ? this.createMap(header, list, ignore, mapping, true) : Collections.emptyMap();
        this.list = results.contains((Object)Results.list) ? this.createList(header, list, ignore, mapping, true) : Collections.emptyList();
    }

    public void removeNullValues(String[] list, List<String> nullValues) {
        if (nullValues.isEmpty()) {
            return;
        }
        for (int i = 0; i < list.length; ++i) {
            if (!nullValues.contains(list[i])) continue;
            list[i] = null;
        }
    }

    private List<Object> createList(String[] header, String[] list, boolean ignore, Map<String, Mapping> mappings, boolean convert) {
        if (!ignore && mappings.isEmpty()) {
            return Arrays.asList((Object[])list);
        }
        ArrayList<Object> result = new ArrayList<Object>(list.length);
        for (int i = 0; i < header.length; ++i) {
            String name = header[i];
            if (name == null) continue;
            Mapping mapping = mappings.get(name);
            if (mapping != null) {
                if (mapping.ignore) continue;
                result.add(convert ? mapping.convert(list[i]) : list[i]);
                continue;
            }
            result.add(list[i]);
        }
        return result;
    }

    private Map<String, Object> createMap(String[] header, String[] list, boolean ignore, Map<String, Mapping> mappings, boolean convert) {
        if (header == null) {
            return null;
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(header.length, 1.0f);
        for (int i = 0; i < header.length; ++i) {
            String name = header[i];
            if (ignore && name == null) continue;
            Mapping mapping = mappings.get(name);
            if (mapping == null) {
                map.put(name, list[i]);
                continue;
            }
            if (mapping.ignore) continue;
            map.put(mapping.name, convert ? mapping.convert(list[i]) : list[i]);
        }
        return map;
    }
}

