/*
 * Decompiled with CFR 0.152.
 */
package apoc.util.collection;

import apoc.util.collection.PrefetchingResourceIterator;
import java.util.Iterator;
import org.neo4j.graphdb.ResourceIterator;

public abstract class NestingResourceIterator<T, U>
extends PrefetchingResourceIterator<T> {
    private final Iterator<U> source;
    private ResourceIterator<T> currentNestedIterator;

    protected NestingResourceIterator(Iterator<U> source) {
        this.source = source;
    }

    protected abstract ResourceIterator<T> createNestedIterator(U var1);

    @Override
    protected T fetchNextOrNull() {
        if (this.currentNestedIterator == null || !this.currentNestedIterator.hasNext()) {
            while (this.source.hasNext()) {
                U currentSurfaceItem = this.source.next();
                this.close();
                this.currentNestedIterator = this.createNestedIterator(currentSurfaceItem);
                if (!this.currentNestedIterator.hasNext()) continue;
                break;
            }
        }
        return (T)(this.currentNestedIterator != null && this.currentNestedIterator.hasNext() ? this.currentNestedIterator.next() : null);
    }

    public void close() {
        if (this.currentNestedIterator != null) {
            this.currentNestedIterator.close();
        }
    }
}

