/*
 * Copyright (c) "Neo4j"
 * Neo4j Sweden AB [http://neo4j.com]
 *
 * This file is part of Neo4j.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package apoc.util.google.cloud;

import apoc.util.SupportedProtocols;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;

@SuppressWarnings("unused") // used from SupportedProtocols
public class GCStorageURLStreamHandlerFactory implements URLStreamHandlerFactory {

    public GCStorageURLStreamHandlerFactory() {}

    @Override
    public URLStreamHandler createURLStreamHandler(final String protocol) {
        final SupportedProtocols supportedProtocols = SupportedProtocols.valueOf(protocol);
        return supportedProtocols == SupportedProtocols.gs ? new GCStorageURLStreamHandler() : null;
    }
}
