/*
 * Decompiled with CFR 0.152.
 */
package apoc;

import apoc.ApocConfig;
import apoc.periodic.PeriodicUtils;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.api.procedure.GlobalProcedures;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.Log;
import org.neo4j.logging.internal.LogService;

public class Pools
extends LifecycleAdapter {
    public static final int DEFAULT_SCHEDULED_THREADS = Runtime.getRuntime().availableProcessors() / 4;
    public static final int DEFAULT_POOL_THREADS = Runtime.getRuntime().availableProcessors() * 2;
    private final Log log;
    private final GlobalProcedures globalProceduresRegistry;
    private final ApocConfig apocConfig;
    private ExecutorService singleExecutorService;
    private ScheduledExecutorService scheduledExecutorService;
    private ExecutorService defaultExecutorService;
    private final Map<PeriodicUtils.JobInfo, Future> jobList = new ConcurrentHashMap<PeriodicUtils.JobInfo, Future>();

    public Pools(LogService log, GlobalProcedures globalProceduresRegistry, ApocConfig apocConfig) {
        this.log = log.getInternalLog(Pools.class);
        this.globalProceduresRegistry = globalProceduresRegistry;
        this.apocConfig = apocConfig;
        globalProceduresRegistry.registerComponent(((Object)((Object)this)).getClass(), ctx -> this, true);
        this.log.info("successfully registered Pools for @Context");
    }

    public void init() {
        int threads = Math.max(1, this.apocConfig.getInt("apoc.jobs.pool.num_threads", DEFAULT_POOL_THREADS));
        int queueSize = Math.max(1, this.apocConfig.getInt("apoc.jobs.queue.size", threads * 5));
        ThreadFactory threadFactory = r -> {
            Thread t = Executors.defaultThreadFactory().newThread(r);
            t.setDaemon(true);
            return t;
        };
        this.singleExecutorService = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(queueSize), threadFactory, new CallerBlocksPolicy());
        this.defaultExecutorService = new ThreadPoolExecutor(threads / 2, threads, 30L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(queueSize), threadFactory, new CallerBlocksPolicy());
        this.scheduledExecutorService = Executors.newScheduledThreadPool(Math.max(1, this.apocConfig.getInt("apoc.jobs.scheduled.num_threads", DEFAULT_SCHEDULED_THREADS)), threadFactory);
        this.scheduledExecutorService.scheduleAtFixedRate(() -> {
            Iterator<Map.Entry<PeriodicUtils.JobInfo, Future>> it = this.jobList.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<PeriodicUtils.JobInfo, Future> entry = it.next();
                if (!entry.getValue().isDone() && !entry.getValue().isCancelled()) continue;
                it.remove();
            }
        }, 10L, 10L, TimeUnit.SECONDS);
    }

    public void shutdown() throws Exception {
        Stream.of(this.singleExecutorService, this.defaultExecutorService, this.scheduledExecutorService).forEach(service -> {
            try {
                service.shutdown();
                service.awaitTermination(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Shutdown failed to complete with error: " + e.getMessage());
            }
        });
    }

    public ExecutorService getSingleExecutorService() {
        return this.singleExecutorService;
    }

    public ScheduledExecutorService getScheduledExecutorService() {
        return this.scheduledExecutorService;
    }

    public ExecutorService getDefaultExecutorService() {
        return this.defaultExecutorService;
    }

    public Map<PeriodicUtils.JobInfo, Future> getJobList() {
        return this.jobList;
    }

    public <T> Future<Void> processBatch(List<T> batch, GraphDatabaseService db, BiConsumer<Transaction, T> action) {
        return this.defaultExecutorService.submit(() -> {
            try (Transaction tx = db.beginTx();){
                batch.forEach(t -> action.accept(tx, t));
                tx.commit();
            }
            return null;
        });
    }

    public static <T> T force(Future<T> future) throws ExecutionException {
        while (true) {
            try {
                return future.get();
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                continue;
            }
            break;
        }
    }

    static class CallerBlocksPolicy
    implements RejectedExecutionHandler {
        CallerBlocksPolicy() {
        }

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            FutureTask<Object> task = new FutureTask<Object>(r, null);
            BlockingQueue<Runnable> queue = executor.getQueue();
            while (!executor.isShutdown()) {
                try {
                    if (!queue.offer(task, 250L, TimeUnit.MILLISECONDS)) continue;
                    while (!executor.isShutdown()) {
                        try {
                            task.get(250L, TimeUnit.MILLISECONDS);
                            return;
                        }
                        catch (TimeoutException timeoutException) {
                        }
                    }
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

