/*
 * Decompiled with CFR 0.152.
 */
package apoc.load.util;

import apoc.load.Mapping;
import apoc.load.util.Results;
import apoc.util.CompressionConfig;
import apoc.util.Util;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LoadCsvConfig
extends CompressionConfig {
    public static final char DEFAULT_ARRAY_SEP = ';';
    public static final char DEFAULT_SEP = ',';
    public static final char DEFAULT_QUOTE_CHAR = '\"';
    public static final char DEFAULT_ESCAPE_CHAR = '\\';
    private final boolean ignoreErrors;
    private char separator;
    private char arraySep;
    private char quoteChar;
    private char escapeChar;
    private long skip;
    private boolean hasHeader;
    private long limit;
    private boolean failOnError;
    private boolean ignoreQuotations;
    private EnumSet<Results> results;
    private List<String> ignore;
    private List<String> nullValues;
    private Map<String, Map<String, Object>> mapping;
    private Map<String, Mapping> mappings;

    public LoadCsvConfig(Map<String, Object> config) {
        super(config);
        if (config == null) {
            config = Collections.emptyMap();
        }
        this.ignoreErrors = Util.toBoolean(config.getOrDefault("ignoreErrors", false));
        this.separator = Util.parseCharFromConfig(config, "sep", ',');
        this.arraySep = Util.parseCharFromConfig(config, "arraySep", ';');
        this.quoteChar = Util.parseCharFromConfig(config, "quoteChar", '\"');
        this.escapeChar = Util.parseCharFromConfig(config, "escapeChar", '\\');
        long skip = (Long)config.getOrDefault("skip", 0L);
        this.skip = skip > -1L ? skip : 0L;
        this.hasHeader = (Boolean)config.getOrDefault("header", true);
        this.limit = (Long)config.getOrDefault("limit", Long.MAX_VALUE);
        this.failOnError = (Boolean)config.getOrDefault("failOnError", true);
        this.ignoreQuotations = (Boolean)config.getOrDefault("ignoreQuotations", false);
        this.results = EnumSet.noneOf(Results.class);
        List<String> resultList = config.getOrDefault("results", Arrays.asList("map", "list"));
        for (String result : resultList) {
            this.results.add(Results.valueOf(result));
        }
        this.ignore = config.getOrDefault("ignore", Collections.emptyList());
        this.nullValues = config.getOrDefault("nullValues", Collections.emptyList());
        this.mapping = config.getOrDefault("mapping", Collections.emptyMap());
        this.mappings = this.createMapping(this.mapping, this.arraySep, this.ignore);
    }

    private Map<String, Mapping> createMapping(Map<String, Map<String, Object>> mapping, char arraySep, List<String> ignore) {
        if (mapping.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Mapping> result = new HashMap<String, Mapping>(mapping.size());
        for (Map.Entry<String, Map<String, Object>> entry : mapping.entrySet()) {
            String name = entry.getKey();
            result.put(name, new Mapping(name, entry.getValue(), arraySep, ignore.contains(name)));
        }
        return result;
    }

    public char getSeparator() {
        return this.separator;
    }

    public char getArraySep() {
        return this.arraySep;
    }

    public long getSkip() {
        return this.skip;
    }

    public boolean isHasHeader() {
        return this.hasHeader;
    }

    public long getLimit() {
        return this.limit;
    }

    public boolean isFailOnError() {
        return this.failOnError;
    }

    public EnumSet<Results> getResults() {
        return this.results;
    }

    public List<String> getIgnore() {
        return this.ignore;
    }

    public List<String> getNullValues() {
        return this.nullValues;
    }

    public Map<String, Map<String, Object>> getMapping() {
        return this.mapping;
    }

    public Map<String, Mapping> getMappings() {
        return this.mappings;
    }

    public char getQuoteChar() {
        return this.quoteChar;
    }

    public char getEscapeChar() {
        return this.escapeChar;
    }

    public boolean getIgnoreErrors() {
        return this.ignoreErrors;
    }

    public boolean isIgnoreQuotations() {
        return this.ignoreQuotations;
    }
}

