/*
 * Decompiled with CFR 0.152.
 */
package apoc.result;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.collections4.IterableUtils;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.traversal.Paths;

public class VirtualPath
implements Path {
    private final Node start;
    private final List<Relationship> relationships;

    public VirtualPath(Node start) {
        this(start, new ArrayList<Relationship>());
    }

    private VirtualPath(Node start, List<Relationship> relationships) {
        Objects.requireNonNull(start);
        Objects.requireNonNull(relationships);
        this.start = start;
        this.relationships = relationships;
    }

    public void addRel(Relationship relationship) {
        Objects.requireNonNull(relationship);
        this.requireConnected(relationship);
        this.relationships.add(relationship);
    }

    public Node startNode() {
        return this.start;
    }

    public Node endNode() {
        return this.reverseNodes().iterator().next();
    }

    public Relationship lastRelationship() {
        return this.relationships.isEmpty() ? null : this.relationships.get(this.relationships.size() - 1);
    }

    public Iterable<Relationship> relationships() {
        return this.relationships;
    }

    public Iterable<Relationship> reverseRelationships() {
        return IterableUtils.reversedIterable(this.relationships());
    }

    public Iterable<Node> nodes() {
        ArrayList<Node> nodes = new ArrayList<Node>();
        nodes.add(this.start);
        AtomicReference<Node> currNode = new AtomicReference<Node>(this.start);
        List otherNodes = this.relationships.stream().map(rel -> {
            Node otherNode = rel.getOtherNode((Node)currNode.get());
            currNode.set(otherNode);
            return otherNode;
        }).collect(Collectors.toList());
        nodes.addAll(otherNodes);
        return nodes;
    }

    public Iterable<Node> reverseNodes() {
        return IterableUtils.reversedIterable(this.nodes());
    }

    public int length() {
        return this.relationships.size();
    }

    @Nonnull
    public Iterator<Entity> iterator() {
        return new Iterator<Entity>(){
            Iterator<? extends Entity> current;
            Iterator<? extends Entity> next;
            {
                this.current = VirtualPath.this.nodes().iterator();
                this.next = VirtualPath.this.relationships().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.current.hasNext();
            }

            @Override
            public Entity next() {
                try {
                    Entity entity = this.current.next();
                    return entity;
                }
                finally {
                    Iterator<? extends Entity> temp = this.current;
                    this.current = this.next;
                    this.next = temp;
                }
            }

            @Override
            public void remove() {
                this.next.remove();
            }
        };
    }

    public String toString() {
        return Paths.defaultPathToString((Path)this);
    }

    private void requireConnected(Relationship relationship) {
        Relationship previousRelationship = this.lastRelationship();
        Node previousEndNode = previousRelationship != null ? previousRelationship.getEndNode() : this.endNode();
        if (!relationship.getStartNode().equals(previousEndNode) && !relationship.getEndNode().equals(previousEndNode)) {
            throw new IllegalArgumentException("Relationship is not part of current path.");
        }
    }

    public static final class Builder {
        private final Node start;
        private final List<Relationship> relationships = new ArrayList<Relationship>();

        public Builder(Node start) {
            this.start = start;
        }

        public Builder push(Relationship relationship) {
            this.relationships.add(relationship);
            return this;
        }

        public VirtualPath build() {
            return new VirtualPath(this.start, this.relationships);
        }
    }
}

