/*
 * Decompiled with CFR 0.152.
 */
package apoc.util;

import apoc.ApocConfig;
import apoc.export.util.CountingInputStream;
import apoc.export.util.CountingReader;
import apoc.export.util.ExportConfig;
import apoc.util.CompressionAlgo;
import apoc.util.MissingDependencyException;
import apoc.util.StreamConnection;
import apoc.util.SupportedProtocols;
import apoc.util.Util;
import apoc.util.hdfs.HDFSUtils;
import apoc.util.s3.S3URLConnection;
import apoc.util.s3.S3UploadUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.configuration.GraphDatabaseSettings;

public class FileUtils {
    public static final String ERROR_READ_FROM_FS_NOT_ALLOWED = "Import file %s not enabled, please set apoc.import.file.allow_read_from_filesystem=true in your neo4j.conf";
    public static final String ACCESS_OUTSIDE_DIR_ERROR = "You're providing a directory outside the import directory defined into `server.directories.import`";
    public static final List<String> NEO4J_DIRECTORY_CONFIGURATION_SETTING_NAMES = Arrays.asList("server.directories.data", "server.directories.import", "server.directories.lib", "server.directories.logs", "server.directories.plugins", "server.directories.run", "server.directories.transaction.logs.root", "server.directories.neo4j_home");

    public static StreamConnection getStreamConnection(SupportedProtocols protocol, String urlAddress, Map<String, Object> headers, String payload) throws IOException {
        switch (protocol) {
            case s3: {
                return FileUtils.openS3InputStream(urlAddress);
            }
            case hdfs: {
                return FileUtils.openHdfsInputStream(urlAddress);
            }
            case ftp: 
            case http: 
            case https: 
            case gs: {
                return Util.readHttpInputStream(urlAddress, headers, payload);
            }
        }
        try {
            return new StreamConnection.FileStreamConnection(URI.create(urlAddress));
        }
        catch (IllegalArgumentException iae) {
            try {
                return new StreamConnection.FileStreamConnection(new URL(urlAddress).getFile());
            }
            catch (MalformedURLException mue) {
                if (mue.getMessage().contains("no protocol")) {
                    return new StreamConnection.FileStreamConnection(urlAddress);
                }
                throw mue;
            }
        }
    }

    public static URLStreamHandler createURLStreamHandler(SupportedProtocols protocol) {
        URLStreamHandler handler = Optional.ofNullable(protocol.getUrlStreamHandlerClassName()).map(Util::createInstanceOrNull).map(urlStreamHandlerFactory -> ((URLStreamHandlerFactory)urlStreamHandlerFactory).createURLStreamHandler(protocol.name())).orElse(null);
        return handler;
    }

    public static SupportedProtocols of(String name) {
        try {
            return SupportedProtocols.valueOf(name);
        }
        catch (Exception e) {
            return SupportedProtocols.file;
        }
    }

    public static SupportedProtocols from(URL url) {
        return FileUtils.of(url.getProtocol());
    }

    public static SupportedProtocols from(String source) {
        try {
            URL url = new URL(source);
            return FileUtils.from(url);
        }
        catch (MalformedURLException e) {
            if (!e.getMessage().contains("no protocol")) {
                try {
                    return SupportedProtocols.valueOf(new URI(source).getScheme());
                }
                catch (Exception exception) {
                    throw new RuntimeException(e);
                }
            }
            return SupportedProtocols.file;
        }
    }

    public static CountingReader readerFor(Object input) throws IOException {
        return FileUtils.readerFor(input, null, null, CompressionAlgo.NONE.name());
    }

    public static CountingReader readerFor(Object input, String compressionAlgo) throws IOException {
        return FileUtils.readerFor(input, null, null, compressionAlgo);
    }

    public static CountingReader readerFor(Object input, Map<String, Object> headers, String payload, String compressionAlgo) throws IOException {
        return FileUtils.inputStreamFor(input, headers, payload, compressionAlgo).asReader();
    }

    public static CountingInputStream inputStreamFor(Object input, Map<String, Object> headers, String payload, String compressionAlgo) throws IOException {
        if (input == null) {
            return null;
        }
        if (input instanceof String) {
            String fileName = (String)input;
            ApocConfig.apocConfig().checkReadAllowed(fileName);
            fileName = FileUtils.changeFileUrlIfImportDirectoryConstrained(fileName);
            return Util.openInputStream(fileName, headers, payload, compressionAlgo);
        }
        if (input instanceof byte[]) {
            return FileUtils.getInputStreamFromBinary((byte[])input, compressionAlgo);
        }
        throw new RuntimeException("Only byte[] or url String allowed");
    }

    public static String changeFileUrlIfImportDirectoryConstrained(String url) throws IOException {
        if (FileUtils.isFile(url) && FileUtils.isImportUsingNeo4jConfig()) {
            if (!ApocConfig.apocConfig().getBoolean("apoc.import.file.allow_read_from_filesystem")) {
                throw new RuntimeException(String.format(ERROR_READ_FROM_FS_NOT_ALLOWED, url));
            }
            Path resolvedPath = FileUtils.resolvePath(url);
            return resolvedPath.normalize().toUri().toString();
        }
        return url;
    }

    private static Path resolvePath(String url) throws IOException {
        Path resolvedPath;
        Path urlPath = FileUtils.getPath(url);
        if (ApocConfig.apocConfig().isImportFolderConfigured() && FileUtils.isImportUsingNeo4jConfig()) {
            Path basePath = Paths.get(ApocConfig.apocConfig().getImportDir(), new String[0]);
            resolvedPath = basePath.resolve(urlPath = FileUtils.relativizeIfSamePrefix(urlPath, basePath)).toAbsolutePath().normalize();
            if (!FileUtils.pathStartsWithOther(resolvedPath, basePath)) {
                throw new IOException(ACCESS_OUTSIDE_DIR_ERROR);
            }
        } else {
            resolvedPath = urlPath;
        }
        return resolvedPath;
    }

    private static Path relativizeIfSamePrefix(Path urlPath, Path basePath) {
        if (FilenameUtils.getPrefixLength((String)urlPath.toString()) > 0 && !urlPath.startsWith(basePath.toAbsolutePath())) {
            urlPath = urlPath.getRoot().relativize(urlPath);
        }
        return urlPath;
    }

    private static Path getPath(String url) {
        Path urlPath;
        URL toURL = null;
        try {
            URI uri = URI.create(url.trim());
            toURL = uri.toURL();
            urlPath = Paths.get(uri);
        }
        catch (Exception e) {
            urlPath = toURL != null ? Paths.get(StringUtils.isBlank((CharSequence)toURL.getFile()) ? toURL.getHost() : toURL.getFile(), new String[0]) : Paths.get(url, new String[0]);
        }
        return urlPath;
    }

    private static boolean pathStartsWithOther(Path resolvedPath, Path basePath) throws IOException {
        try {
            return resolvedPath.toRealPath(new LinkOption[0]).startsWith(basePath.toRealPath(new LinkOption[0]));
        }
        catch (Exception e) {
            if (e instanceof NoSuchFileException) {
                return resolvedPath.normalize().startsWith(basePath);
            }
            return false;
        }
    }

    public static boolean isFile(String fileName) {
        return FileUtils.from(fileName) == SupportedProtocols.file;
    }

    public static OutputStream getOutputStream(String fileName) {
        return FileUtils.getOutputStream(fileName, ExportConfig.EMPTY);
    }

    public static OutputStream getOutputStream(String fileName, ExportConfig config) {
        if (fileName.equals("-")) {
            return null;
        }
        return FileUtils.getOutputStream(FileUtils.from(fileName), fileName, config);
    }

    public static OutputStream getOutputStream(SupportedProtocols protocol, String fileName, ExportConfig config) {
        if (fileName == null) {
            return null;
        }
        CompressionAlgo compressionAlgo = CompressionAlgo.valueOf(config.getCompressionAlgo());
        try {
            return new BufferedOutputStream(compressionAlgo.getOutputStream(switch (protocol) {
                case SupportedProtocols.s3 -> S3UploadUtils.writeFile(fileName);
                case SupportedProtocols.hdfs -> HDFSUtils.writeFile(fileName);
                default -> {
                    Path path = FileUtils.resolvePath(fileName);
                    yield new FileOutputStream(path.toFile());
                }
            }));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isImportUsingNeo4jConfig() {
        return ApocConfig.apocConfig().getBoolean("apoc.import.file.use_neo4j_config");
    }

    public static StreamConnection openS3InputStream(String urlAddress) throws IOException {
        if (!SupportedProtocols.s3.isEnabled()) {
            throw new MissingDependencyException("Cannot find the S3 jars in the plugins folder. \nPlease put these files into the plugins folder :\n\naws-java-sdk-core-x.y.z.jar\naws-java-sdk-s3-x.y.z.jar\nhttpclient-x.y.z.jar\nhttpcore-x.y.z.jar\njoda-time-x.y.z.jar\n\nSee the documentation: https://neo4j.github.io/apoc/#_loading_data_from_web_apis_json_xml_csv");
        }
        return S3URLConnection.openS3InputStream(new URL(urlAddress));
    }

    public static StreamConnection openHdfsInputStream(String urlAddress) throws IOException {
        if (!SupportedProtocols.hdfs.isEnabled()) {
            throw new MissingDependencyException("Cannot find the HDFS/Hadoop jars in the plugins folder. \n\nPlease, see the documentation: https://neo4j.com/labs/apoc/4.4/import/web-apis/");
        }
        return HDFSUtils.readFile(new URL(urlAddress));
    }

    public static File getLogDirectory() {
        File logs;
        String neo4jHome = ApocConfig.apocConfig().getString("server.directories.neo4j_home", "");
        String logDir = ApocConfig.apocConfig().getString("server.directories.logs", "");
        File file = logs = logDir.isEmpty() ? new File(neo4jHome, "logs") : new File(logDir);
        if (logs.exists() && logs.canRead() && logs.isDirectory()) {
            return logs;
        }
        return null;
    }

    public static File getMetricsDirectory() {
        File metricsDir;
        String neo4jHome = ApocConfig.apocConfig().getString(GraphDatabaseSettings.neo4j_home.name());
        String metricsSetting = ApocConfig.apocConfig().getString("server.directories.metrics", neo4jHome + File.separator + "metrics");
        File file = metricsDir = metricsSetting.isEmpty() ? new File(neo4jHome, "metrics") : new File(metricsSetting);
        if (metricsDir.exists() && metricsDir.canRead() && metricsDir.isDirectory()) {
            return metricsDir;
        }
        return null;
    }

    public static void closeReaderSafely(CountingReader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static Path getPathFromUrlString(String urlDir) {
        return Paths.get(URI.create(urlDir));
    }

    public static CountingInputStream getInputStreamFromBinary(byte[] urlOrBinary, String compressionAlgo) {
        return CompressionAlgo.valueOf(compressionAlgo).toInputStream(urlOrBinary);
    }

    public static CountingReader getReaderFromBinary(byte[] urlOrBinary, String compressionAlgo) {
        try {
            return FileUtils.getInputStreamFromBinary(urlOrBinary, compressionAlgo).asReader();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

