/*
 * Decompiled with CFR 0.152.
 */
package apoc.util;

import apoc.ApocConfig;
import apoc.Pools;
import apoc.convert.ConvertUtils;
import apoc.export.cypher.formatter.CypherFormatterUtils;
import apoc.export.util.CountingInputStream;
import apoc.export.util.ExportConfig;
import apoc.result.VirtualNode;
import apoc.result.VirtualRelationship;
import apoc.util.ArchiveType;
import apoc.util.CompressionAlgo;
import apoc.util.DateFormatUtil;
import apoc.util.FileUtils;
import apoc.util.JsonUtil;
import apoc.util.MapUtil;
import apoc.util.StreamConnection;
import apoc.util.collection.Iterators;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.time.Duration;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.PrimitiveIterator;
import java.util.Scanner;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.lang.model.SourceVersion;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.jetty.util.URIUtil;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.connectors.BoltConnector;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.ExecutionPlanDescription;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotInTransactionException;
import org.neo4j.graphdb.QueryExecutionType;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransactionTerminatedException;
import org.neo4j.internal.kernel.api.procs.ProcedureCallContext;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.Log;
import org.neo4j.logging.NullLog;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.TerminationGuard;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.Values;

public class Util {
    public static final Label[] NO_LABELS = new Label[0];
    public static final String NODE_COUNT = "MATCH (n) RETURN count(*) as result";
    public static final String REL_COUNT = "MATCH ()-->() RETURN count(*) as result";
    public static final String COMPILED = "interpreted";
    public static final String ERROR_BYTES_OR_STRING = "Only byte[] or url String allowed";
    private static final String ESCAPED_UNICODE_BACKTICK = "\\u0060";
    private static final Pattern PATTERN_ESCAPED_4DIGIT_UNICODE = Pattern.compile("\\\\u+(\\p{XDigit}{4})");
    private static final Pattern PATTERN_LABEL_AND_TYPE_QUOTATION = Pattern.compile("(?<!`)`(?:`{2})*(?!`)");
    private static final List<String[]> SUPPORTED_ESCAPE_CHARS = Collections.unmodifiableList(Arrays.asList({"\\b", "\b"}, {"\\f", "\f"}, {"\\n", "\n"}, {"\\r", "\r"}, {"\\t", "\t"}, {"\\`", "``"}));

    public static String labelString(List<String> labelNames) {
        return labelNames.stream().map(Util::quote).collect(Collectors.joining(":"));
    }

    public static String labelString(Node n) {
        return Util.joinLabels(n.getLabels(), ":");
    }

    public static String joinLabels(Iterable<Label> labels, String s) {
        return StreamSupport.stream(labels.spliterator(), false).map(Label::name).collect(Collectors.joining(s));
    }

    public static List<String> labelStrings(Node n) {
        return StreamSupport.stream(n.getLabels().spliterator(), false).map(Label::name).sorted().collect(Collectors.toList());
    }

    public static Label[] labels(Object labelNames) {
        if (labelNames == null) {
            return NO_LABELS;
        }
        if (labelNames instanceof List) {
            LinkedHashSet names = new LinkedHashSet((List)labelNames);
            Label[] labels = new Label[names.size()];
            int i = 0;
            for (Object l : names) {
                if (l == null) continue;
                labels[i++] = Label.label((String)l.toString());
            }
            if (i <= labels.length) {
                return Arrays.copyOf(labels, i);
            }
            return labels;
        }
        return new Label[]{Label.label((String)labelNames.toString())};
    }

    public static RelationshipType type(Object type) {
        if (type == null) {
            throw new RuntimeException("No relationship-type provided");
        }
        return RelationshipType.withName((String)type.toString());
    }

    public static LongStream ids(Object ids) {
        if (ids == null) {
            return LongStream.empty();
        }
        if (ids instanceof Number) {
            return LongStream.of(((Number)ids).longValue());
        }
        if (ids instanceof Node) {
            return LongStream.of(((Node)ids).getId());
        }
        if (ids instanceof Relationship) {
            return LongStream.of(((Relationship)ids).getId());
        }
        if (ids instanceof Collection) {
            Collection coll = (Collection)ids;
            return coll.stream().mapToLong(o -> ((Number)o).longValue());
        }
        if (ids instanceof Iterable) {
            Spliterator spliterator = ((Iterable)ids).spliterator();
            return StreamSupport.stream(spliterator, false).mapToLong(o -> ((Number)o).longValue());
        }
        throw new RuntimeException("Can't convert " + ids.getClass() + " to a stream of long ids");
    }

    public static Stream<Object> stream(Object values) {
        return ConvertUtils.convertToList(values).stream();
    }

    public static Stream<Node> nodeStream(Transaction tx, Object ids) {
        return Util.stream(ids).map(id -> Util.node(tx, id));
    }

    public static Node node(Transaction tx, Object id) {
        if (id instanceof Node) {
            return Util.rebind(tx, (Node)id);
        }
        if (id instanceof Number) {
            return tx.getNodeById(((Number)id).longValue());
        }
        throw new RuntimeException("Can't convert " + id.getClass() + " to a Node");
    }

    public static Stream<Relationship> relsStream(Transaction tx, Object ids) {
        return Util.stream(ids).map(id -> Util.relationship(tx, id));
    }

    public static Relationship relationship(Transaction tx, Object id) {
        if (id instanceof Relationship) {
            return Util.rebind(tx, (Relationship)id);
        }
        if (id instanceof Number) {
            return tx.getRelationshipById(((Number)id).longValue());
        }
        throw new RuntimeException("Can't convert " + id.getClass() + " to a Relationship");
    }

    public static double doubleValue(Entity pc, String prop, Number defaultValue) {
        return Util.toDouble(pc.getProperty(prop, (Object)defaultValue));
    }

    public static double doubleValue(Entity pc, String prop) {
        return Util.doubleValue(pc, prop, 0);
    }

    public static Direction parseDirection(String direction) {
        if (null == direction) {
            return Direction.BOTH;
        }
        try {
            return Direction.valueOf((String)direction.toUpperCase());
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Cannot convert value '%s' to Direction. Legal values are '%s'", direction, Arrays.toString(Direction.values())));
        }
    }

    public static RelationshipType[] toRelTypes(List<String> relTypeStrings) {
        RelationshipType[] relTypes = new RelationshipType[relTypeStrings.size()];
        for (int i = 0; i < relTypes.length; ++i) {
            relTypes[i] = RelationshipType.withName((String)relTypeStrings.get(i));
        }
        return relTypes;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T retryInTx(Log log, GraphDatabaseService db, Function<Transaction, T> function, long retry, long maxRetries, Consumer<Long> callbackForRetry) {
        try (Transaction tx = db.beginTx();){
            Transaction result = function.apply(tx);
            tx.commit();
            Transaction t = result;
            return (T)t;
        }
        catch (Exception e) {
            if (retry >= maxRetries) {
                throw e;
            }
            if (log != null) {
                log.warn("Retrying operation %d of %d", new Object[]{retry, maxRetries});
            }
            callbackForRetry.accept(retry);
            Util.sleep(100);
            return (T)Util.retryInTx(log, db, function, retry + 1L, maxRetries, callbackForRetry);
        }
    }

    public static <T> Future<T> inTxFuture(Log log, ExecutorService pool, GraphDatabaseService db, Function<Transaction, T> function, long maxRetries, Consumer<Long> callbackForRetry, Consumer<Void> callbackAction) {
        try {
            return pool.submit(() -> {
                try {
                    Object t = Util.retryInTx(log, db, function, 0L, maxRetries, callbackForRetry);
                    return t;
                }
                finally {
                    callbackAction.accept(null);
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException("Error executing in separate transaction", e);
        }
    }

    public static <T> Future<T> inTxFuture(ExecutorService pool, GraphDatabaseService db, Function<Transaction, T> function) {
        return Util.inTxFuture(null, pool, db, function, 0L, _ignored -> {}, _ignored -> {});
    }

    public static <T> T inTx(GraphDatabaseService db, Pools pools, Function<Transaction, T> function) {
        try {
            return Util.inTxFuture(pools.getDefaultExecutorService(), db, function).get();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Error executing in separate transaction: " + e.getMessage(), e);
        }
    }

    public static <T> T inThread(Pools pools, Callable<T> callable) {
        try {
            return Util.inFuture(pools, callable).get();
        }
        catch (Exception e) {
            throw new RuntimeException("Error executing in separate thread: " + e.getMessage(), e);
        }
    }

    public static <T> Future<T> inFuture(Pools pools, Callable<T> callable) {
        return pools.getDefaultExecutorService().submit(callable);
    }

    public static Double toDouble(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        try {
            return Double.parseDouble(value.toString());
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static Map<String, Object> subMap(Map<String, ?> params, String prefix) {
        HashMap<String, Object> config = new HashMap<String, Object>(10);
        int len = prefix.length() + (prefix.isEmpty() || prefix.endsWith(".") ? 0 : 1);
        for (Map.Entry<String, ?> entry : params.entrySet()) {
            String key = entry.getKey();
            if (!key.startsWith(prefix)) continue;
            config.put(key.substring(len), entry.getValue());
        }
        return config;
    }

    public static Long toLong(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        try {
            String s = value.toString();
            if (s.contains(".")) {
                return (long)Double.parseDouble(s);
            }
            return Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static Integer toInteger(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        try {
            String s = value.toString();
            if (s.contains(".")) {
                return (int)Double.parseDouble(s);
            }
            return Integer.parseInt(value.toString());
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static URLConnection openUrlConnection(String url, Map<String, Object> headers) throws IOException {
        URL src = new URL(url);
        URLConnection con = src.openConnection();
        con.setRequestProperty("User-Agent", "APOC Procedures for Neo4j");
        if (headers != null) {
            Object method = headers.get("method");
            if (method != null && con instanceof HttpURLConnection) {
                HttpURLConnection http = (HttpURLConnection)con;
                http.setRequestMethod(method.toString());
                http.setChunkedStreamingMode(0x100000);
                http.setInstanceFollowRedirects(true);
            }
            headers.forEach((k, v) -> con.setRequestProperty((String)k, v == null ? "" : v.toString()));
        }
        con.setConnectTimeout(ApocConfig.apocConfig().getInt("apoc.http.timeout.connect", 10000));
        con.setReadTimeout(ApocConfig.apocConfig().getInt("apoc.http.timeout.read", 60000));
        return con;
    }

    public static boolean isRedirect(HttpURLConnection con) throws IOException {
        boolean isRedirectCode;
        int code = con.getResponseCode();
        boolean bl = isRedirectCode = code >= 300 && code < 400;
        if (isRedirectCode) {
            URL location = new URL(con.getHeaderField("Location"));
            String oldProtocol = con.getURL().getProtocol();
            String protocol = location.getProtocol();
            if (!protocol.equals(oldProtocol) && !protocol.startsWith(oldProtocol)) {
                throw new RuntimeException("The redirect URI has a different protocol: " + location.toString());
            }
        }
        return isRedirectCode;
    }

    private static void writePayload(URLConnection con, String payload) throws IOException {
        if (payload == null) {
            return;
        }
        con.setDoOutput(true);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(con.getOutputStream(), "UTF-8"));
        writer.write(payload);
        writer.close();
    }

    private static String handleRedirect(URLConnection con, String url) throws IOException {
        if (!(con instanceof HttpURLConnection)) {
            return url;
        }
        if (!Util.isRedirect((HttpURLConnection)con)) {
            return url;
        }
        return con.getHeaderField("Location");
    }

    public static CountingInputStream openInputStream(Object input, Map<String, Object> headers, String payload, String compressionAlgo) throws IOException {
        if (input instanceof String) {
            String urlAddress = (String)input;
            ArchiveType archiveType = ArchiveType.from(urlAddress);
            if (archiveType.isArchive()) {
                return Util.getStreamCompressedFile(urlAddress, headers, payload, archiveType);
            }
            StreamConnection sc = Util.getStreamConnection(urlAddress, headers, payload);
            return sc.toCountingInputStream(compressionAlgo);
        }
        if (input instanceof byte[]) {
            return FileUtils.getInputStreamFromBinary((byte[])input, compressionAlgo);
        }
        throw new RuntimeException(ERROR_BYTES_OR_STRING);
    }

    private static CountingInputStream getStreamCompressedFile(String urlAddress, Map<String, Object> headers, String payload, ArchiveType archiveType) throws IOException {
        String[] tokens = urlAddress.split("!");
        urlAddress = tokens[0];
        if (tokens.length != 2) {
            throw new IllegalArgumentException("filename can't be null or empty");
        }
        String zipFileName = tokens[1];
        StreamConnection sc = Util.getStreamConnection(urlAddress, headers, payload);
        InputStream stream = Util.getFileStreamIntoCompressedFile(sc.getInputStream(), zipFileName, archiveType);
        return new CountingInputStream(stream, sc.getLength());
    }

    private static StreamConnection getStreamConnection(String urlAddress, Map<String, Object> headers, String payload) throws IOException {
        return FileUtils.getStreamConnection(FileUtils.from(urlAddress), urlAddress, headers, payload);
    }

    private static InputStream getFileStreamIntoCompressedFile(InputStream is, String fileName, ArchiveType archiveType) throws IOException {
        try (ArchiveInputStream archive = archiveType.getInputStream(is);){
            ArchiveEntry archiveEntry;
            while ((archiveEntry = archive.getNextEntry()) != null) {
                if (archiveEntry.isDirectory() || !archiveEntry.getName().equals(fileName)) continue;
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(IOUtils.toByteArray((InputStream)archive));
                return byteArrayInputStream;
            }
        }
        return null;
    }

    public static StreamConnection readHttpInputStream(String urlAddress, Map<String, Object> headers, String payload) throws IOException {
        ApocConfig.apocConfig().checkReadAllowed(urlAddress);
        URLConnection con = Util.openUrlConnection(urlAddress, headers);
        Util.writePayload(con, payload);
        String newUrl = Util.handleRedirect(con, urlAddress);
        if (newUrl != null && !urlAddress.equals(newUrl)) {
            con.getInputStream().close();
            return Util.readHttpInputStream(newUrl, headers, payload);
        }
        return new StreamConnection.UrlStreamConnection(con);
    }

    public static boolean toBoolean(Object value) {
        return value != null && (!(value instanceof Number) || ((Number)value).longValue() != 0L) && (!(value instanceof String) || !value.equals("") && !((String)value).equalsIgnoreCase("false") && !((String)value).equalsIgnoreCase("no") && !((String)value).equalsIgnoreCase("0")) && (!(value instanceof Boolean) || !value.equals(false));
    }

    public static String toString(Object string) {
        return string == null ? null : string.toString();
    }

    public static String encodeUrlComponent(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unsupported character set utf-8");
        }
    }

    public static String toJson(Object value) {
        try {
            return JsonUtil.OBJECT_MAPPER.writeValueAsString(value);
        }
        catch (IOException e) {
            throw new RuntimeException("Can't convert " + value + " to JSON");
        }
    }

    public static <T> T fromJson(String value, Class<T> type) {
        try {
            return (T)JsonUtil.OBJECT_MAPPER.readValue(value, type);
        }
        catch (IOException e) {
            throw new RuntimeException("Can't convert " + value + " from JSON");
        }
    }

    public static Stream<List<Object>> partitionSubList(List<Object> data, int partitions) {
        return Util.partitionSubList(data, partitions, null);
    }

    public static Stream<List<Object>> partitionSubList(List<Object> data, int partitions, List<Object> tombstone) {
        if (partitions == 0) {
            partitions = 1;
        }
        ArrayList<Object> list = new ArrayList<Object>(data);
        int total = list.size();
        int batchSize = Math.max((int)Math.ceil((double)total / (double)partitions), 1);
        Stream<List<Object>> stream = IntStream.range(0, partitions).parallel().mapToObj(part -> list.subList(Math.min(part * batchSize, total), Math.min((part + 1) * batchSize, total))).filter(partition -> !partition.isEmpty());
        return tombstone == null ? stream : Stream.concat(stream, Stream.of(tombstone));
    }

    public static Long runNumericQuery(Transaction tx, String query, Map<String, Object> params) {
        if (params == null) {
            params = Collections.emptyMap();
        }
        try (ResourceIterator it = tx.execute(query, params).columnAs("result");){
            Long l = (Long)it.next();
            return l;
        }
    }

    public static long nodeCount(Transaction tx) {
        return Util.runNumericQuery(tx, NODE_COUNT, null);
    }

    public static long relCount(Transaction tx) {
        return Util.runNumericQuery(tx, REL_COUNT, null);
    }

    public static LongStream toLongStream(final LongIterator it) {
        PrimitiveIterator.OfLong iterator = new PrimitiveIterator.OfLong(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public long nextLong() {
                return it.next();
            }
        };
        return StreamSupport.longStream(Spliterators.spliteratorUnknownSize(iterator, 1296), false);
    }

    public static String readResourceFile(String name) {
        InputStream is = Util.class.getClassLoader().getResourceAsStream(name);
        return new Scanner(is).useDelimiter("\\Z").next();
    }

    public static Map<String, Object> readMap(String value) {
        try {
            return (Map)JsonUtil.OBJECT_MAPPER.readValue(value, Map.class);
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't read as JSON " + value);
        }
    }

    public static <T> List<T> take(Iterator<T> iterator, int batchsize) {
        ArrayList<T> result = new ArrayList<T>(batchsize);
        while (iterator.hasNext() && batchsize-- > 0) {
            result.add(iterator.next());
        }
        return result;
    }

    public static Map<String, Object> merge(Map<String, Object> first, Map<String, Object> second) {
        if (second == null || second.isEmpty()) {
            return first == null ? Collections.EMPTY_MAP : first;
        }
        if (first == null || first.isEmpty()) {
            return second == null ? Collections.EMPTY_MAP : second;
        }
        HashMap<String, Object> combined = new HashMap<String, Object>(first);
        combined.putAll(second);
        return combined;
    }

    public static <T> Map<String, T> map(T ... values) {
        LinkedHashMap<String, T> map = new LinkedHashMap<String, T>();
        for (int i = 0; i < values.length; i += 2) {
            if (values[i] == null) continue;
            map.put(values[i].toString(), values[i + 1]);
        }
        return map;
    }

    public static <T> Map<String, T> map(List<T> pairs) {
        LinkedHashMap<String, T> res = new LinkedHashMap<String, T>(pairs.size() / 2);
        Iterator<T> it = pairs.iterator();
        while (it.hasNext()) {
            T key = it.next();
            T value = it.next();
            if (key == null) continue;
            res.put(key.toString(), value);
        }
        return res;
    }

    public static <T, R> List<R> map(Stream<T> stream, Function<T, R> mapper) {
        return stream.map(mapper).collect(Collectors.toList());
    }

    public static <T, R> List<R> map(Collection<T> collection, Function<T, R> mapper) {
        return Util.map(collection.stream(), mapper);
    }

    public static Map<String, Object> mapFromLists(List<String> keys, List<Object> values) {
        if (keys == null || values == null || keys.size() != values.size()) {
            throw new RuntimeException("keys and values lists have to be not null and of same size");
        }
        if (keys.isEmpty()) {
            return Collections.emptyMap();
        }
        if (keys.size() == 1) {
            return Collections.singletonMap(keys.get(0), values.get(0));
        }
        ListIterator<Object> it = values.listIterator();
        LinkedHashMap<String, Object> res = new LinkedHashMap<String, Object>(keys.size());
        for (String key : keys) {
            res.put(key, it.next());
        }
        return res;
    }

    public static Map<String, Object> mapFromPairs(List<List<Object>> pairs) {
        if (pairs.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(pairs.size());
        for (List<Object> pair : pairs) {
            Object key;
            if (pair.isEmpty() || (key = pair.get(0)) == null) continue;
            Object value = pair.size() >= 2 ? pair.get(1) : null;
            map.put(key.toString(), value);
        }
        return map;
    }

    public static String cleanUrl(String url) {
        try {
            URL source = new URL(url);
            Object file = source.getFile();
            if (source.getRef() != null) {
                file = (String)file + "#" + source.getRef();
            }
            return new URL(source.getProtocol(), source.getHost(), source.getPort(), (String)file).toString();
        }
        catch (MalformedURLException mfu) {
            return String.format("invalid URL (%s)", url);
        }
    }

    public static <T> T getFuture(Future<T> f, Map<String, Long> errorMessages, AtomicInteger errors, T errorValue) {
        try {
            T t = f.get();
            return t;
        }
        catch (Exception e) {
            errors.incrementAndGet();
            errorMessages.compute(e.getMessage(), (s, i) -> i == null ? 1L : i + 1L);
            return errorValue;
        }
    }

    public static <T> T getFutureOrCancel(Future<T> f, Map<String, Long> errorMessages, AtomicInteger errors, T errorValue) {
        try {
            if (f.isDone()) {
                return f.get();
            }
            f.cancel(false);
            errors.incrementAndGet();
        }
        catch (Exception e) {
            errors.incrementAndGet();
            errorMessages.compute(e.getMessage(), (s, i) -> i == null ? 1L : i + 1L);
        }
        return errorValue;
    }

    public static boolean isSumOutOfRange(long ... numbers) {
        try {
            Util.sumLongs(numbers).longValueExact();
            return false;
        }
        catch (ArithmeticException ae) {
            return true;
        }
    }

    public static BigInteger sumLongs(long ... numbers) {
        return LongStream.of(numbers).mapToObj(BigInteger::valueOf).reduce(BigInteger.ZERO, (x, y) -> x.add((BigInteger)y));
    }

    public static void logErrors(String message, Map<String, Long> errors, Log log) {
        if (!errors.isEmpty()) {
            log.warn(message);
            errors.forEach((k, v) -> log.warn("%d times: %s", new Object[]{v, k}));
        }
    }

    public static void checkAdmin(SecurityContext securityContext, ProcedureCallContext callContext, String procedureName) {
        if (!securityContext.allowExecuteAdminProcedure(callContext.id()).allowsAccess()) {
            throw new RuntimeException("This procedure " + procedureName + " is only available to admin users");
        }
    }

    public static void sleep(int millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static String quote(String var) {
        return SourceVersion.isIdentifier(var) && !var.contains("$") ? var : "`" + var + "`";
    }

    public static String sanitize(String value) {
        return Util.sanitize(value, false);
    }

    public static String sanitize(String value, boolean addQuotes) {
        if (value == null || value.isEmpty()) {
            return value;
        }
        for (String[] pair : SUPPORTED_ESCAPE_CHARS) {
            value = value.replace(pair[0], pair[1]);
        }
        value = value.replace(ESCAPED_UNICODE_BACKTICK, "`");
        Matcher matcher = PATTERN_ESCAPED_4DIGIT_UNICODE.matcher(value);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String replacement = Character.toString((char)Integer.parseInt(matcher.group(1), 16));
            matcher.appendReplacement(sb, Matcher.quoteReplacement(replacement));
        }
        matcher.appendTail(sb);
        value = sb.toString();
        value = value.replace("\\u", "\\u005C\\u0075");
        matcher = PATTERN_LABEL_AND_TYPE_QUOTATION.matcher(value);
        value = matcher.replaceAll("`$0");
        value = value.replace("\\\\", "\\");
        if (!addQuotes) {
            return value;
        }
        return String.format(Locale.ENGLISH, "`%s`", value);
    }

    public static boolean isIdentifier(CharSequence name) {
        String id = name.toString();
        if (id.length() == 0) {
            return false;
        }
        int cp = id.codePointAt(0);
        if (!Character.isJavaIdentifierStart(cp)) {
            return false;
        }
        for (int i = Character.charCount(cp); i < id.length(); i += Character.charCount(cp)) {
            cp = id.codePointAt(i);
            if (Character.isJavaIdentifierPart(cp)) continue;
            return false;
        }
        return true;
    }

    public static String param(String var) {
        return var.charAt(0) == '$' ? var : "$" + Util.quote(var);
    }

    public static String withMapping(Stream<String> columns, Function<String, String> withMapping) {
        String with = columns.map(withMapping).collect(Collectors.joining(","));
        return with.isEmpty() ? with : " WITH " + with + " ";
    }

    public static boolean isWriteableInstance(GraphDatabaseAPI db) {
        String socketAddress = ((SocketAddress)((Config)db.getDependencyResolver().resolveDependency(Config.class)).get(BoltConnector.advertised_address)).toString();
        GraphDatabaseService systemDb = ((DatabaseManagementService)db.getDependencyResolver().resolveDependency(DatabaseManagementService.class)).database("system");
        Boolean writer = (Boolean)systemDb.executeTransactionally("SHOW DATABASE $databaseName WHERE address = $socketAddress", Map.of("databaseName", db.databaseName(), "socketAddress", socketAddress), result -> (Boolean)Iterators.single(result.columnAs("writer")));
        return writer;
    }

    public static boolean transactionIsTerminated(TerminationGuard db) {
        try {
            db.check();
            return false;
        }
        catch (NotInTransactionException | TransactionTerminatedException tge) {
            return true;
        }
    }

    public static void waitForFutures(List<Future> futures) {
        for (Future future : futures) {
            try {
                if (future == null) continue;
                future.get();
            }
            catch (InterruptedException | ExecutionException exception) {}
        }
    }

    public static void removeFinished(List<Future> futures) {
        if (futures.size() > 25) {
            futures.removeIf(Future::isDone);
        }
    }

    public static void close(AutoCloseable closeable, Consumer<Exception> onError) {
        block3: {
            try {
                if (closeable != null) {
                    closeable.close();
                }
            }
            catch (Exception e) {
                if (onError == null) break block3;
                onError.accept(e);
            }
        }
    }

    public static void close(AutoCloseable closeable) {
        Util.close(closeable, null);
    }

    public static boolean isNotNullOrEmpty(String s) {
        return s != null && s.trim().length() != 0;
    }

    public static boolean isNullOrEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }

    public static Map<String, String> getRequestParameter(String parameters) {
        HashMap<String, String> params = null;
        if (Objects.nonNull(parameters)) {
            String[] queryStrings;
            params = new HashMap<String, String>();
            for (String query : queryStrings = parameters.split("&")) {
                String[] parts = query.split("=");
                if (parts.length != 2) continue;
                params.put(parts[0], parts[1]);
            }
        }
        return params;
    }

    public static boolean classExists(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException cnfe) {
            return false;
        }
    }

    public static <T> T createInstanceOrNull(String className) {
        try {
            return (T)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            return null;
        }
    }

    public static Optional<String> getLoadUrlByConfigFile(String loadType, String key, String suffix) {
        key = Optional.ofNullable(key).map(s -> Stream.of("apoc", loadType, s, suffix).collect(Collectors.joining("."))).orElse("");
        String value = ApocConfig.apocConfig().getString(key);
        return Optional.ofNullable(value);
    }

    public static String dateFormat(TemporalAccessor value, String format) {
        return Util.getFormat(format).format(value);
    }

    public static Duration durationParse(String value) {
        return Duration.parse(value);
    }

    public static DateTimeFormatter getFormat(String format) {
        return DateFormatUtil.getOrCreate(format);
    }

    public static char parseCharFromConfig(Map<String, Object> config, String key, char defaultValue) {
        String separator = (String)config.getOrDefault(key, "");
        if (separator == null || separator.isEmpty()) {
            return defaultValue;
        }
        if ("TAB".equals(separator)) {
            return '\t';
        }
        if ("NONE".equals(separator)) {
            return '\u0000';
        }
        return separator.charAt(0);
    }

    public static Map<String, Object> flattenMap(Map<String, Object> map) {
        return Util.flattenMap(map, null);
    }

    public static Map<String, Object> flattenMap(Map<String, Object> map, String prefix) {
        return map.entrySet().stream().flatMap(entry -> {
            Object key = prefix != null && !prefix.isEmpty() ? prefix + "." + (String)entry.getKey() : (String)entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Map) {
                return Util.flattenMap((Map)value, (String)key).entrySet().stream();
            }
            AbstractMap.SimpleEntry newEntry = new AbstractMap.SimpleEntry(key, entry.getValue());
            return Stream.of(newEntry);
        }).collect(Collectors.toMap(e -> (String)e.getKey(), e -> e.getValue()));
    }

    public static Node rebind(Transaction tx, Node node) {
        return node instanceof VirtualNode ? node : tx.getNodeById(node.getId());
    }

    public static Relationship rebind(Transaction tx, Relationship rel) {
        return rel instanceof VirtualRelationship ? rel : tx.getRelationshipById(rel.getId());
    }

    public static <T extends Entity> T rebind(Transaction tx, T e) {
        if (e instanceof Node) {
            return (T)Util.rebind(tx, (Node)e);
        }
        return (T)Util.rebind(tx, (Relationship)e);
    }

    public static <T extends Entity> List<T> rebind(List<T> entities, Transaction tx) {
        return entities.stream().map(n -> Util.rebind(tx, n)).collect(Collectors.toList());
    }

    public static Node mergeNode(Transaction tx, Label primaryLabel, Label addtionalLabel, Pair<String, Object> ... pairs) {
        Node node = (Node)Iterators.singleOrNull(tx.findNodes(primaryLabel, (String)pairs[0].getLeft(), pairs[0].getRight()).stream().filter(n -> addtionalLabel == null || n.hasLabel(addtionalLabel)).filter(n -> {
            for (int i = 1; i < pairs.length; ++i) {
                if (Objects.deepEquals(pairs[i].getRight(), n.getProperty((String)pairs[i].getLeft(), null))) continue;
                return false;
            }
            return true;
        }).iterator());
        if (node == null) {
            Label[] labelArray;
            if (addtionalLabel == null) {
                Label[] labelArray2 = new Label[1];
                labelArray = labelArray2;
                labelArray2[0] = primaryLabel;
            } else {
                Label[] labelArray3 = new Label[2];
                labelArray3[0] = primaryLabel;
                labelArray = labelArray3;
                labelArray3[1] = addtionalLabel;
            }
            Label[] labels = labelArray;
            node = tx.createNode(labels);
            for (int i = 0; i < pairs.length; ++i) {
                node.setProperty((String)pairs[i].getLeft(), pairs[i].getRight());
            }
        }
        return node;
    }

    public static <T> Set<T> intersection(Collection<T> a, Collection<T> b) {
        if (a == null || b == null) {
            return Collections.emptySet();
        }
        HashSet<T> intersection = new HashSet<T>(a);
        intersection.retainAll(b);
        return intersection;
    }

    public static void validateQuery(GraphDatabaseService db, String statement, QueryExecutionType.QueryType ... supportedQueryTypes) {
        Util.validateQuery(db, statement, Collections.emptySet(), supportedQueryTypes);
    }

    public static void validateQuery(GraphDatabaseService db, String statement, Set<Mode> supportedModes, QueryExecutionType.QueryType ... supportedQueryTypes) {
        db.executeTransactionally("EXPLAIN " + statement, Collections.emptyMap(), result -> {
            boolean isQueryTypeValid;
            boolean bl = isQueryTypeValid = supportedQueryTypes == null || supportedQueryTypes.length == 0 || Stream.of(supportedQueryTypes).anyMatch(sqt -> sqt.equals((Object)result.getQueryExecutionType().queryType()));
            if (!isQueryTypeValid) {
                throw new RuntimeException("Supported query types for the operation are " + Arrays.toString(supportedQueryTypes));
            }
            if (!Util.procsAreValid(db, supportedModes, result)) {
                throw new RuntimeException("Supported inner procedure modes for the operation are " + new TreeSet(supportedModes));
            }
            return null;
        });
    }

    private static boolean procsAreValid(GraphDatabaseService db, Set<Mode> supportedModes, Result result) {
        if (supportedModes != null && !supportedModes.isEmpty()) {
            ExecutionPlanDescription executionPlanDescription = result.getExecutionPlanDescription();
            HashSet<String> queryProcNames = new HashSet<String>();
            Util.getAllQueryProcs(executionPlanDescription, queryProcNames);
            if (!queryProcNames.isEmpty()) {
                Set modes = supportedModes.stream().map(Enum::name).collect(Collectors.toSet());
                Set procNames = (Set)db.executeTransactionally("SHOW PROCEDURES YIELD name, mode where mode in $modes return name", Map.of("modes", modes), r -> Iterators.asSet(r.columnAs("name")));
                return procNames.containsAll(queryProcNames);
            }
        }
        return true;
    }

    public static void getAllQueryProcs(ExecutionPlanDescription executionPlanDescription, Set<String> procs) {
        executionPlanDescription.getChildren().forEach(i -> {
            if (i.getName().equals("ProcedureCall")) {
                String procName = ((String)i.getArguments().get("Details")).split("\\(")[0];
                procs.add(procName);
            }
            Util.getAllQueryProcs(i, procs);
        });
    }

    public static Thread newDaemonThread(Runnable target) {
        Thread thread = new Thread(target);
        thread.setDaemon(true);
        return thread;
    }

    public static String encodeUserColonPassToBase64(String userPass) {
        return new String(Base64.getEncoder().encode(userPass.getBytes()));
    }

    public static Map<String, Object> extractCredentialsIfNeeded(String url, boolean failOnError) {
        try {
            String[] parts;
            URI uri = new URI(URIUtil.encodePath((String)url));
            String authInfo = uri.getUserInfo();
            if (null != authInfo && 2 == (parts = authInfo.split(":")).length) {
                String token = Util.encodeUserColonPassToBase64(authInfo);
                return MapUtil.map("Authorization", "Basic " + token);
            }
        }
        catch (Exception e) {
            if (!failOnError) {
                return Collections.emptyMap();
            }
            throw new RuntimeException(e);
        }
        return Collections.emptyMap();
    }

    public static boolean isSelfRel(Relationship rel) {
        return rel.getStartNodeId() == rel.getEndNodeId();
    }

    public static String toCypherMap(Map<String, Object> map) {
        StringBuilder builder = CypherFormatterUtils.formatProperties(map);
        return "{" + CypherFormatterUtils.formatToString(builder) + "}";
    }

    public static PointValue toPoint(Map<String, Object> pointMap, Map<String, Object> defaultPointMap) {
        double y;
        double x;
        Double z = null;
        CoordinateReferenceSystem crs = CoordinateReferenceSystem.byName((String)((String)Util.getOrDefault(pointMap, defaultPointMap, "crs")));
        boolean isLatitudePresent = pointMap.containsKey("latitude") || !pointMap.containsKey("x") && defaultPointMap.containsKey("latitude");
        boolean isCoord3D = crs.getName().endsWith("-3d");
        if (isLatitudePresent) {
            x = Util.toDouble(Util.getOrDefault(pointMap, defaultPointMap, "longitude"));
            y = Util.toDouble(Util.getOrDefault(pointMap, defaultPointMap, "latitude"));
            if (isCoord3D) {
                z = Util.toDouble(Util.getOrDefault(pointMap, defaultPointMap, "height"));
            }
        } else {
            x = Util.toDouble(Util.getOrDefault(pointMap, defaultPointMap, "x"));
            y = Util.toDouble(Util.getOrDefault(pointMap, defaultPointMap, "y"));
            if (isCoord3D) {
                z = Util.toDouble(Util.getOrDefault(pointMap, defaultPointMap, "z"));
            }
        }
        return z != null ? Values.pointValue((CoordinateReferenceSystem)crs, (double[])new double[]{x, y, z}) : Values.pointValue((CoordinateReferenceSystem)crs, (double[])new double[]{x, y});
    }

    private static Object getOrDefault(Map<String, Object> firstMap, Map<String, Object> secondMap, String key) {
        return firstMap.getOrDefault(key, secondMap.get(key));
    }

    public static Object getStringOrCompressedData(StringWriter writer, ExportConfig config) {
        try {
            String compression = config.getCompressionAlgo();
            String writerString = writer.toString();
            String data = compression.equals(CompressionAlgo.NONE.name()) ? writerString : (Object)CompressionAlgo.valueOf(compression).compress(writerString, config.getCharset());
            writer.getBuffer().setLength(0);
            return data;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T extends Entity> T withTransactionAndRebind(GraphDatabaseService db, Transaction transaction, Function<Transaction, T> action) {
        Entity result = (Entity)Util.retryInTx((Log)NullLog.getInstance(), db, action, 0L, 0L, r -> {});
        return (T)Util.rebind(transaction, result);
    }
}

