/*
 * Decompiled with CFR 0.152.
 */
package apoc.util.kernel;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.neo4j.internal.kernel.api.Cursor;
import org.neo4j.internal.kernel.api.EntityCursor;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.Scan;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;

public class MultiThreadedGlobalGraphOperations {
    public static BatchJobResult forAllNodes(GraphDatabaseAPI db, ExecutorService executorService, int batchSize, BiConsumer<KernelTransaction, NodeCursor> consumer) {
        return MultiThreadedGlobalGraphOperations.forAll(db, executorService, batchSize, consumer, Read::allNodesScan, ktx -> ktx.cursors().allocateNodeCursor(ktx.cursorContext()));
    }

    public static BatchJobResult forAllRelationships(GraphDatabaseAPI db, ExecutorService executorService, int batchSize, BiConsumer<KernelTransaction, RelationshipScanCursor> consumer) {
        return MultiThreadedGlobalGraphOperations.forAll(db, executorService, batchSize, consumer, Read::allRelationshipsScan, ktx -> ktx.cursors().allocateRelationshipScanCursor(ktx.cursorContext()));
    }

    private static <C extends EntityCursor> BatchJobResult forAll(GraphDatabaseAPI db, ExecutorService executorService, int batchSize, BiConsumer<KernelTransaction, C> consumer, Function<Read, Scan<C>> scanFunction, Function<KernelTransaction, C> cursorAllocator) {
        BatchJobResult result = new BatchJobResult();
        AtomicInteger processing = new AtomicInteger();
        try (InternalTransaction tx = db.beginTransaction(KernelTransaction.Type.EXPLICIT, LoginContext.AUTH_DISABLED);){
            KernelTransaction ktx = tx.kernelTransaction();
            Scan<C> scan = scanFunction.apply(ktx.dataRead());
            result.startStopWatch();
            executorService.submit(new BatchJob<C>(scan, batchSize, db, consumer, result, cursorAllocator, executorService, processing));
        }
        try {
            while (processing.get() > 0) {
                Thread.sleep(10L);
            }
            result.stopStopWatch();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return result;
    }

    public static class BatchJobResult {
        final AtomicInteger batches = new AtomicInteger();
        final AtomicLong succeeded = new AtomicLong();
        final AtomicLong failures = new AtomicLong();
        private long started;
        private long duration;

        public void incrementSuceeded() {
            this.succeeded.incrementAndGet();
        }

        public void incrementFailures() {
            this.failures.incrementAndGet();
        }

        public long getSucceeded() {
            return this.succeeded.get();
        }

        public long getFailures() {
            return this.failures.get();
        }

        public long getDuration() {
            return this.duration;
        }

        public void startStopWatch() {
            this.started = System.currentTimeMillis();
        }

        public void stopStopWatch() {
            this.duration = System.currentTimeMillis() - this.started;
        }

        public int getBatches() {
            return this.batches.get();
        }
    }

    private static class BatchJob<C extends EntityCursor>
    implements Callable<Void> {
        private final Scan<C> scan;
        private final int batchSize;
        private final GraphDatabaseAPI db;
        private final BiConsumer<KernelTransaction, C> consumer;
        private final BatchJobResult result;
        private final Function<KernelTransaction, C> cursorAllocator;
        private final ExecutorService executorService;
        private final AtomicInteger processing;

        public BatchJob(Scan<C> scan, int batchSize, GraphDatabaseAPI db, BiConsumer<KernelTransaction, C> consumer, BatchJobResult result, Function<KernelTransaction, C> cursorAllocator, ExecutorService executorService, AtomicInteger processing) {
            this.scan = scan;
            this.batchSize = batchSize;
            this.db = db;
            this.consumer = consumer;
            this.result = result;
            this.cursorAllocator = cursorAllocator;
            this.executorService = executorService;
            this.processing = processing;
            processing.incrementAndGet();
        }

        @Override
        public Void call() {
            try {
                Void void_;
                block18: {
                    InternalTransaction tx = this.db.beginTransaction(KernelTransaction.Type.EXPLICIT, LoginContext.AUTH_DISABLED);
                    try {
                        KernelTransaction ktx = tx.kernelTransaction();
                        try (EntityCursor cursor = (EntityCursor)this.cursorAllocator.apply(ktx);){
                            if (this.scan.reserveBatch((Cursor)cursor, this.batchSize, ktx.cursorContext(), (AccessMode)AccessMode.Static.FULL)) {
                                this.executorService.submit(new BatchJob<C>(this.scan, this.batchSize, this.db, this.consumer, this.result, this.cursorAllocator, this.executorService, this.processing));
                                this.executorService.submit(new BatchJob<C>(this.scan, this.batchSize, this.db, this.consumer, this.result, this.cursorAllocator, this.executorService, this.processing));
                                while (this.processAndReport(ktx, cursor)) {
                                }
                            }
                        }
                        tx.commit();
                        void_ = null;
                        if (tx == null) break block18;
                    }
                    catch (Throwable throwable) {
                        if (tx != null) {
                            try {
                                tx.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    tx.close();
                }
                return void_;
            }
            finally {
                this.result.batches.incrementAndGet();
                this.processing.decrementAndGet();
            }
        }

        private boolean processAndReport(KernelTransaction ktx, C cursor) {
            if (cursor.next()) {
                try {
                    this.consumer.accept(ktx, cursor);
                    this.result.incrementSuceeded();
                }
                catch (Exception e) {
                    this.result.incrementFailures();
                }
                return true;
            }
            return false;
        }
    }
}

