/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.export;

import apoc.util.collection.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.neo4j.cypher.export.SubGraph;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.IndexType;

public class CypherResultSubGraph
implements SubGraph {
    private final SortedMap<Long, Node> nodes = new TreeMap<Long, Node>();
    private final SortedMap<Long, Relationship> relationships = new TreeMap<Long, Relationship>();
    private final Collection<Label> labels = new HashSet<Label>();
    private final Collection<RelationshipType> types = new HashSet<RelationshipType>();
    private final Collection<IndexDefinition> indexes = new HashSet<IndexDefinition>();
    private final Collection<ConstraintDefinition> constraints = new HashSet<ConstraintDefinition>();

    public void add(Node node) {
        long id = node.getId();
        if (!this.nodes.containsKey(id)) {
            this.addNode(id, node);
        }
    }

    void addNode(long id, Node data) {
        this.nodes.put(id, data);
        this.labels.addAll(Iterables.asList(data.getLabels()));
    }

    public void add(Relationship rel) {
        long id = rel.getId();
        if (!this.relationships.containsKey(id)) {
            this.addRel(id, rel);
            this.add(rel.getStartNode());
            this.add(rel.getEndNode());
        }
    }

    public static SubGraph from(Transaction tx, Result result, boolean addBetween) {
        CypherResultSubGraph graph = new CypherResultSubGraph();
        List columns = result.columns();
        result.forEachRemaining(row -> {
            for (String column : columns) {
                Object value = row.get(column);
                graph.addToGraph(value);
            }
        });
        block0: for (IndexDefinition def : tx.schema().getIndexes()) {
            if (!def.isNodeIndex() || def.getIndexType() == IndexType.LOOKUP) continue;
            for (Label label : def.getLabels()) {
                if (!graph.getLabels().contains(label)) continue;
                graph.addIndex(def);
                continue block0;
            }
        }
        for (IndexDefinition def : tx.schema().getConstraints()) {
            if (!graph.getLabels().contains(def.getLabel())) continue;
            graph.addConstraint((ConstraintDefinition)def);
        }
        if (addBetween) {
            graph.addRelationshipsBetweenNodes();
        }
        return graph;
    }

    private void addIndex(IndexDefinition def) {
        this.indexes.add(def);
    }

    private void addConstraint(ConstraintDefinition def) {
        this.constraints.add(def);
    }

    private void addRelationshipsBetweenNodes() {
        HashSet<Node> newNodes = new HashSet<Node>();
        for (Node node : this.nodes.values()) {
            for (Relationship relationship : node.getRelationships()) {
                Node other;
                if (!this.relationships.containsKey(relationship.getId()) || this.nodes.containsKey((other = relationship.getOtherNode(node)).getId()) || newNodes.contains(other)) continue;
                newNodes.add(other);
            }
        }
        for (Node node : newNodes) {
            this.add(node);
        }
    }

    private void addToGraph(Object value) {
        if (value instanceof Node) {
            this.add((Node)value);
        }
        if (value instanceof Relationship) {
            this.add((Relationship)value);
        }
        if (value instanceof Iterable) {
            for (Object inner : (Iterable)value) {
                this.addToGraph(inner);
            }
        }
    }

    @Override
    public Iterable<Node> getNodes() {
        return this.nodes.values();
    }

    @Override
    public Iterable<Relationship> getRelationships() {
        return this.relationships.values();
    }

    public Collection<Label> getLabels() {
        return this.labels;
    }

    void addRel(Long id, Relationship rel) {
        this.relationships.put(id, rel);
        this.types.add(rel.getType());
    }

    @Override
    public boolean contains(Relationship relationship) {
        return this.relationships.containsKey(relationship.getId());
    }

    @Override
    public Iterable<IndexDefinition> getIndexes() {
        return this.indexes;
    }

    @Override
    public Iterable<ConstraintDefinition> getConstraints() {
        return this.constraints;
    }

    @Override
    public Iterable<ConstraintDefinition> getConstraints(Label label) {
        return this.constraints.stream().filter(c -> c.getLabel().equals(label)).collect(Collectors.toSet());
    }

    @Override
    public Iterable<ConstraintDefinition> getConstraints(RelationshipType type) {
        return this.constraints.stream().filter(c -> c.getRelationshipType().equals(type)).collect(Collectors.toSet());
    }

    @Override
    public Iterable<IndexDefinition> getIndexes(Label label) {
        return this.indexes.stream().filter(idx -> StreamSupport.stream(idx.getLabels().spliterator(), false).anyMatch(lb -> lb.equals(label))).collect(Collectors.toSet());
    }

    @Override
    public Iterable<IndexDefinition> getIndexes(RelationshipType type) {
        return this.indexes.stream().filter(idx -> StreamSupport.stream(idx.getRelationshipTypes().spliterator(), false).anyMatch(relType -> relType.name().equals(type.name()))).collect(Collectors.toSet());
    }

    @Override
    public Iterable<RelationshipType> getAllRelationshipTypesInUse() {
        return Collections.unmodifiableCollection(this.types);
    }

    @Override
    public Iterable<Label> getAllLabelsInUse() {
        return Collections.unmodifiableCollection(this.labels);
    }

    @Override
    public long countsForRelationship(Label start, RelationshipType type, Label end) {
        return this.relationships.values().stream().filter(r -> {
            boolean matchType = r.getType().equals(type);
            boolean matchStart = start != null ? r.getStartNode().hasLabel(start) : true;
            boolean matchEnd = end != null ? r.getEndNode().hasLabel(end) : true;
            return matchType && matchStart && matchEnd;
        }).count();
    }

    @Override
    public long countsForNode(Label label) {
        return this.nodes.values().stream().filter(n -> n.hasLabel(label)).count();
    }

    @Override
    public Iterator<Node> findNodes(Label label) {
        return this.nodes.values().stream().filter(n -> n.hasLabel(label)).iterator();
    }
}

