/*
 * Decompiled with CFR 0.152.
 */
package apoc.util;

import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class DateFormatUtil {
    private static final Map<String, DateTimeFormatter> ISO_DATE_FORMAT;
    public static Map<String, String> ISO_DURATION_PATTERNS;
    public static Map<String, String> ELASTIC_PATTERNS;

    public static DateTimeFormatter getOrCreate(String format) {
        String formatLower = format.toLowerCase();
        if (ISO_DATE_FORMAT.containsKey(formatLower)) {
            return ISO_DATE_FORMAT.get(formatLower);
        }
        return DateTimeFormatter.ofPattern(ELASTIC_PATTERNS.getOrDefault(formatLower, format));
    }

    public static Set<String> getTypes() {
        return ISO_DATE_FORMAT.keySet();
    }

    static {
        HashMap<String, DateTimeFormatter> map = new HashMap<String, DateTimeFormatter>();
        map.put("basic_iso_date", DateTimeFormatter.BASIC_ISO_DATE);
        map.put("iso_date", DateTimeFormatter.ISO_DATE);
        map.put("iso_instant", DateTimeFormatter.ISO_INSTANT);
        map.put("iso_date_time", DateTimeFormatter.ISO_DATE_TIME);
        map.put("iso_local_date", DateTimeFormatter.ISO_LOCAL_DATE);
        map.put("iso_local_date_time", DateTimeFormatter.ISO_LOCAL_DATE_TIME);
        map.put("iso_local_time", DateTimeFormatter.ISO_LOCAL_TIME);
        map.put("iso_offset_date", DateTimeFormatter.ISO_OFFSET_DATE);
        map.put("iso_offset_date_time", DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        map.put("iso_offset_time", DateTimeFormatter.ISO_OFFSET_TIME);
        map.put("iso_ordinal_date", DateTimeFormatter.ISO_ORDINAL_DATE);
        map.put("iso_time", DateTimeFormatter.ISO_TIME);
        map.put("iso_week_date", DateTimeFormatter.ISO_WEEK_DATE);
        map.put("iso_zoned_date_time", DateTimeFormatter.ISO_ZONED_DATE_TIME);
        map.put("rfc_1123_date_time", DateTimeFormatter.RFC_1123_DATE_TIME);
        ISO_DATE_FORMAT = Collections.unmodifiableMap(map);
        ISO_DURATION_PATTERNS = new HashMap<String, String>(){
            {
                this.put("basic_iso_date", "yyyyMMdd");
                String isoDateTime = "yyyy-MM-dd'T'HH:mm:ssI";
                this.put("iso_date_time", "yyyy-MM-dd'T'HH:mm:ssI");
                this.put("iso_local_date_time", "yyyy-MM-dd'T'HH:mm:ssI");
                String isoDate = "yyyy-MM-dd";
                this.put("iso_date", "yyyy-MM-dd");
                this.put("iso_local_date", "yyyy-MM-dd");
                String isoTime = "HH:mm:ssI";
                this.put("iso_time", "HH:mm:ssI");
                this.put("iso_local_time", "HH:mm:ssI");
                this.put("iso_ordinal_date", "yyyy-DDD");
                this.put("iso_week_date", "YYYY-'W'ww-e");
            }
        };
        ELASTIC_PATTERNS = new HashMap<String, String>(){
            {
                this.put("basic_date", "yyyyMMdd");
                this.put("basic_date_time", "yyyyMMdd'T'HHmmss.SSSZ");
                this.put("basic_date_time_no_millis", "yyyyMMdd'T'HHmmssZ");
                this.put("basic_ordinal_date", "yyyyDDD");
                this.put("basic_ordinal_date_time", "yyyyDDD'T'HHmmss.SSSZ");
                this.put("basic_ordinal_date_time_no_millis", "yyyyDDD'T'HHmmssZ");
                this.put("basic_time", "HHmmss.SSSZ");
                this.put("basic_time_no_millis", "HHmmssZ");
                this.put("basic_t_time", "'T'HHmmss.SSSZ");
                this.put("basic_t_time_no_millis", "'T'HHmmssZ");
                this.put("basic_week_date", "xxxx'W'wwe");
                this.put("basic_week_date_time", "xxxx'W'wwe'T'HHmmss.SSSZ");
                this.put("basic_week_date_time_no_millis", "xxxx'W'wwe'T'HHmmssZ");
                this.put("date", "yyyy-MM-dd");
                this.put("date_hour", "yyyy-MM-dd'T'HH");
                this.put("date_hour_minute", "yyyy-MM-dd'T'HH:mm");
                this.put("date_hour_minute_second", "yyyy-MM-dd'T'HH:mm:ss");
                this.put("date_hour_minute_second_fraction", "yyyy-MM-dd'T'HH:mm:ss.SSS");
                this.put("date_hour_minute_second_millis", "yyyy-MM-dd'T'HH:mm:ss.SSS");
                this.put("date_time", "yyyy-MM-dd'T'HH:mm:ss.SSSZZ");
                this.put("date_time_no_millis", "yyy-MM-dd'T'HH:mm:ssZZ");
                this.put("hour", "HH");
                this.put("hour_minute", "HH:mm");
                this.put("hour_minute_second", "HH:mm:ss");
                this.put("hour_minute_second_fraction", "HH:mm:ss.SSS");
                this.put("hour_minute_second_millis", "HH:mm:ss.SSS");
                this.put("ordinal_date", "yyyy-DDD");
                this.put("ordinal_date_time", "yyyy-DDD'T'HH:mm:ss.SSSZZ");
                this.put("ordinal_date_time_no_millis", "yyyy-DDD'T'HH:mm:ssZZ");
                this.put("time", "HH:mm:ss.SSSZZ");
                this.put("time_no_millis", "HH:mm:ssZZ");
                this.put("t_time", "'T'HH:mm:ss.SSSZZ");
                this.put("t_time_no_millis", "'T'HH:mm:ssZZ");
                this.put("week_date", "xxxx-'W'ww-e");
                this.put("week_date_time", "xxxx-'W'ww-e'T'HH:mm:ss.SSSZZ");
                this.put("week_date_time_no_millis", "xxxx-'W'ww-e'T'HH:mm:ssZZ");
                this.put("weekyear", "xxxx");
                this.put("weekyear_week", "xxxx-'W'ww");
                this.put("weekyear_week_day", "xxxx-'W'ww-e");
                this.put("year", "yyyy");
                this.put("year_month", "yyyy-MM");
                this.put("year_month_day", "yyyy-MM-dd");
            }
        };
    }
}

