/*
 * Decompiled with CFR 0.152.
 */
package apoc.util;

import apoc.util.DateFormatUtil;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.neo4j.values.storable.DurationFields;
import org.neo4j.values.storable.DurationValue;

public class DurationFormatUtil {
    public static String getOrCreateDurationPattern(String format) {
        String formatLower = format.toLowerCase();
        return DateFormatUtil.ISO_DURATION_PATTERNS.getOrDefault(formatLower, DateFormatUtil.ELASTIC_PATTERNS.getOrDefault(formatLower, format));
    }

    public static String getDurationFormat(DurationValue duration, String formatPattern) {
        AtomicInteger idx = new AtomicInteger();
        return Arrays.stream(formatPattern.split("'")).map(item -> {
            if (idx.getAndIncrement() % 2 == 0) {
                return DurationFormatUtil.getInnerDurationFormat(duration, item);
            }
            return item;
        }).collect(Collectors.joining());
    }

    private static String getInnerDurationFormat(DurationValue duration, String formatter) {
        return Pattern.compile("(?<year>[yYu])\\1*|(?<day>[dD])\\2*|(?<monthYear>[ML])\\3*|(?<quarterYear>[qQ])\\4*|(?<week>[wW])\\5*|(?<hour>[hHkK])\\6*|(?<minHour>m)\\7*|(?<secMin>s)\\8*|(?<nsSeconds>[nS])\\9*|(?<ms>A)\\10*|(?<ns>N)\\11|(?<iso>I)\\12*").matcher(formatter).replaceAll(res -> {
            Matcher m = (Matcher)res;
            if (m.group("year") != null) {
                return DurationFormatUtil.getFieldDigit(m, duration, DurationFields.YEARS);
            }
            if (m.group("day") != null) {
                return DurationFormatUtil.getFieldDigit(m, duration, DurationFields.DAYS);
            }
            if (m.group("monthYear") != null) {
                return DurationFormatUtil.getFieldDigit(m, duration, DurationFields.MONTHS_OF_YEAR);
            }
            if (m.group("quarterYear") != null) {
                return DurationFormatUtil.getFieldDigit(m, duration, DurationFields.QUARTERS_OF_YEAR);
            }
            if (m.group("week") != null) {
                return DurationFormatUtil.getFieldDigit(m, duration, DurationFields.WEEKS);
            }
            if (m.group("hour") != null) {
                return DurationFormatUtil.getFieldDigit(m, duration, DurationFields.HOURS);
            }
            if (m.group("minHour") != null) {
                return DurationFormatUtil.getFieldDigit(m, duration, DurationFields.MINUTES_OF_HOUR);
            }
            if (m.group("secMin") != null) {
                return DurationFormatUtil.getFieldDigit(m, duration, DurationFields.SECONDS_OF_MINUTE);
            }
            if (m.group("nsSeconds") != null) {
                return DurationFormatUtil.getFieldDigit(m, duration, DurationFields.NANOSECONDS_OF_SECOND, true);
            }
            if (m.group("ms") != null) {
                return DurationFormatUtil.getFieldDigit(m, duration, DurationFields.MILLISECONDS);
            }
            if (m.group("ns") != null) {
                return DurationFormatUtil.getFieldDigit(m, duration, DurationFields.NANOSECONDS);
            }
            if (m.group("iso") != null) {
                String isoNanos = DurationFormatUtil.getFieldDigit(m, duration, DurationFields.NANOSECONDS_OF_SECOND).replaceAll("(?!$)0+$", "");
                return isoNanos.isEmpty() ? "" : "." + isoNanos;
            }
            return formatter;
        });
    }

    private static String getFieldDigit(Matcher m, DurationValue duration, DurationFields field) {
        return DurationFormatUtil.getFieldDigit(m, duration, field, false);
    }

    private static String getFieldDigit(Matcher m, DurationValue duration, DurationFields field, boolean toTruncate) {
        long replacement = duration.get(field.propertyKey).value();
        String formatted = String.format("%0" + m.group().length() + "d", replacement);
        return toTruncate ? formatted.substring(0, m.group().length()) : formatted;
    }
}

