/*
 * Decompiled with CFR 0.152.
 */
package apoc.util.s3;

import apoc.export.util.LimitedSizeInputStream;
import apoc.util.StreamConnection;
import apoc.util.s3.S3Params;
import apoc.util.s3.S3URLConnection;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.S3Object;
import java.io.InputStream;
import java.util.Objects;

public class S3Aws {
    AmazonS3 s3Client;

    public S3Aws(S3Params s3Params, String region) {
        AWSCredentialsProvider credentialsProvider = S3Aws.getCredentialsProvider(s3Params.getAccessKey(), s3Params.getSecretKey(), s3Params.getSessionToken());
        AmazonS3ClientBuilder builder = AmazonS3ClientBuilder.standard();
        ((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)builder.withCredentials(credentialsProvider)).withClientConfiguration(S3URLConnection.buildClientConfig())).withPathStyleAccessEnabled(Boolean.valueOf(true));
        region = Objects.nonNull(region) ? region : s3Params.getRegion();
        String endpoint = s3Params.getEndpoint();
        if (Objects.nonNull(endpoint)) {
            builder.withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(s3Params.getEndpoint(), region));
        } else if (Objects.nonNull(region)) {
            builder.withRegion(region);
        }
        this.s3Client = (AmazonS3)builder.build();
    }

    public AmazonS3 getClient() {
        return this.s3Client;
    }

    public StreamConnection getS3AwsInputStream(final S3Params s3Params) {
        final S3Object s3Object = this.s3Client.getObject(s3Params.getBucket(), s3Params.getKey());
        final ObjectMetadata metadata = s3Object.getObjectMetadata();
        return new StreamConnection(){

            @Override
            public InputStream getInputStream() {
                return LimitedSizeInputStream.toLimitedIStream((InputStream)s3Object.getObjectContent(), this.getLength());
            }

            @Override
            public String getEncoding() {
                return metadata.getContentEncoding();
            }

            @Override
            public long getLength() {
                return metadata.getContentLength();
            }

            @Override
            public String getName() {
                return s3Params.getKey();
            }
        };
    }

    private static AWSCredentialsProvider getCredentialsProvider(String accessKey, String secretKey, String sessionToken) {
        if (Objects.nonNull(accessKey) && !accessKey.isEmpty() && Objects.nonNull(secretKey) && !secretKey.isEmpty()) {
            Object credentials = Objects.isNull(sessionToken) || sessionToken.isEmpty() ? new BasicAWSCredentials(accessKey, secretKey) : new BasicSessionCredentials(accessKey, secretKey, sessionToken);
            return new AWSStaticCredentialsProvider((AWSCredentials)credentials);
        }
        return new DefaultAWSCredentialsProviderChain();
    }
}

