/*
 * Decompiled with CFR 0.152.
 */
package apoc.cypher;

import apoc.result.CypherStatementMapResult;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.graphdb.Transaction;
import org.neo4j.procedure.Name;

public class CypherUtils {
    public static Stream<CypherStatementMapResult> runCypherQuery(Transaction tx, @Name(value="cypher") String statement, @Name(value="params") Map<String, Object> params) {
        if (params == null) {
            params = Collections.emptyMap();
        }
        return tx.execute(CypherUtils.withParamMapping(statement, params.keySet()), params).stream().map(CypherStatementMapResult::new);
    }

    public static String withParamMapping(String fragment, Collection<String> keys) {
        if (keys.isEmpty()) {
            return fragment;
        }
        String declaration = " WITH " + String.join((CharSequence)", ", keys.stream().map(s -> String.format(" $`%s` as `%s` ", s, s)).collect(Collectors.toList()));
        return declaration + fragment;
    }
}

