/*
 * Decompiled with CFR 0.152.
 */
package apoc.load;

import apoc.result.LoadDataMapResult;
import apoc.util.JsonUtil;
import apoc.util.Util;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.graphdb.security.URLAccessChecker;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.TerminationGuard;

public class LoadJsonUtils {
    public static Stream<LoadDataMapResult> loadJsonStream(@Name(value="urlOrKeyOrBinary") Object urlOrKeyOrBinary, @Name(value="headers") Map<String, Object> headers, @Name(value="payload") String payload, String path, boolean failOnError, String compressionAlgo, List<String> pathOptions, TerminationGuard terminationGuard, URLAccessChecker urlAccessChecker) {
        if (urlOrKeyOrBinary instanceof String) {
            headers = null != headers ? headers : new HashMap<String, Object>();
            headers.putAll(Util.extractCredentialsIfNeeded((String)urlOrKeyOrBinary, failOnError));
        }
        Stream<Object> stream = JsonUtil.loadJson(urlOrKeyOrBinary, headers, payload, path, failOnError, compressionAlgo, pathOptions, urlAccessChecker);
        return stream.flatMap(value -> {
            if (terminationGuard != null) {
                terminationGuard.check();
            }
            if (value instanceof Map) {
                return Stream.of(new LoadDataMapResult((Map)value));
            }
            if (value instanceof List) {
                if (((List)value).isEmpty()) {
                    return Stream.empty();
                }
                if (((List)value).get(0) instanceof Map) {
                    return ((List)value).stream().map(v -> {
                        if (terminationGuard != null) {
                            terminationGuard.check();
                        }
                        return new LoadDataMapResult((Map)v);
                    });
                }
                return Stream.of(new LoadDataMapResult(Collections.singletonMap("result", value)));
            }
            if (!failOnError) {
                throw new RuntimeException("Incompatible Type " + (Serializable)(value == null ? "null" : value.getClass()));
            }
            return Stream.of(new LoadDataMapResult(Collections.emptyMap()));
        });
    }
}

