/*
 * Decompiled with CFR 0.152.
 */
package apoc.meta;

import com.google.common.primitives.Booleans;
import com.google.common.primitives.Bytes;
import com.google.common.primitives.Chars;
import com.google.common.primitives.Floats;
import com.google.common.primitives.Shorts;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.spatial.Point;
import org.neo4j.values.storable.DurationValue;

public enum Types {
    INTEGER,
    FLOAT,
    STRING,
    BOOLEAN,
    RELATIONSHIP,
    NODE,
    PATH,
    NULL,
    ANY,
    MAP,
    LIST,
    POINT,
    DATE,
    DATE_TIME,
    LOCAL_TIME,
    LOCAL_DATE_TIME,
    TIME,
    DURATION;

    private String typeOfList = "ANY";
    private static final Map<Class<?>, Class<?>> primitivesMapping;

    public String toString() {
        if (this == LIST) {
            return "LIST OF " + this.typeOfList;
        }
        return super.toString();
    }

    public static Types of(Object value) {
        Types type = Types.of(value == null ? null : value.getClass());
        if (type == LIST && !value.getClass().isArray()) {
            type.typeOfList = Types.inferType((List)value);
        }
        return type;
    }

    public static Object[] toObjectArray(Object value) {
        if (value instanceof int[]) {
            return Arrays.stream((int[])value).boxed().toArray();
        }
        if (value instanceof long[]) {
            return Arrays.stream((long[])value).boxed().toArray();
        }
        if (value instanceof double[]) {
            return Arrays.stream((double[])value).boxed().toArray();
        }
        if (value instanceof boolean[]) {
            return Booleans.asList((boolean[])((boolean[])value)).toArray();
        }
        if (value instanceof float[]) {
            return Floats.asList((float[])((float[])value)).toArray();
        }
        if (value instanceof byte[]) {
            return Bytes.asList((byte[])((byte[])value)).toArray();
        }
        if (value instanceof char[]) {
            return Chars.asList((char[])((char[])value)).toArray();
        }
        if (value instanceof short[]) {
            return Shorts.asList((short[])((short[])value)).toArray();
        }
        return value.getClass().isArray() ? (Object[])value : ((List)value).toArray();
    }

    public static Types of(Class<?> type) {
        if (type == null) {
            return NULL;
        }
        if (type.isArray()) {
            Types innerType = Types.of(type.getComponentType());
            Types returnType = LIST;
            returnType.typeOfList = innerType.toString();
            return returnType;
        }
        if (type.isPrimitive()) {
            type = primitivesMapping.getOrDefault(type, type);
        }
        if (Number.class.isAssignableFrom(type)) {
            return Double.class.isAssignableFrom(type) || Float.class.isAssignableFrom(type) ? FLOAT : INTEGER;
        }
        if (Boolean.class.isAssignableFrom(type)) {
            return BOOLEAN;
        }
        if (String.class.isAssignableFrom(type)) {
            return STRING;
        }
        if (Map.class.isAssignableFrom(type)) {
            return MAP;
        }
        if (Node.class.isAssignableFrom(type)) {
            return NODE;
        }
        if (Relationship.class.isAssignableFrom(type)) {
            return RELATIONSHIP;
        }
        if (Path.class.isAssignableFrom(type)) {
            return PATH;
        }
        if (Point.class.isAssignableFrom(type)) {
            return POINT;
        }
        if (List.class.isAssignableFrom(type)) {
            return LIST;
        }
        if (LocalDate.class.isAssignableFrom(type)) {
            return DATE;
        }
        if (LocalTime.class.isAssignableFrom(type)) {
            return LOCAL_TIME;
        }
        if (LocalDateTime.class.isAssignableFrom(type)) {
            return LOCAL_DATE_TIME;
        }
        if (DurationValue.class.isAssignableFrom(type)) {
            return DURATION;
        }
        if (OffsetTime.class.isAssignableFrom(type)) {
            return TIME;
        }
        if (ZonedDateTime.class.isAssignableFrom(type)) {
            return DATE_TIME;
        }
        return ANY;
    }

    public static Types from(String typeName) {
        if (typeName == null) {
            return STRING;
        }
        typeName = typeName.toUpperCase().replace("_", "");
        for (Types type : Types.values()) {
            String name = type.name().replace("_", "");
            if (!name.startsWith(typeName)) continue;
            return type;
        }
        return STRING;
    }

    public static String inferType(List<?> list) {
        Set set = list.stream().limit(10L).map(e -> Types.of(e).name()).collect(Collectors.toSet());
        return set.size() != 1 ? "ANY" : (String)set.iterator().next();
    }

    static {
        primitivesMapping = new HashMap(){
            {
                this.put(Double.TYPE, Double.class);
                this.put(Float.TYPE, Float.class);
                this.put(Integer.TYPE, Integer.class);
                this.put(Long.TYPE, Long.class);
                this.put(Short.TYPE, Short.class);
                this.put(Boolean.TYPE, Boolean.class);
            }
        };
    }
}

