/*
 * Decompiled with CFR 0.152.
 */
package apoc.periodic;

import apoc.util.Util;
import java.util.List;
import java.util.Map;
import org.neo4j.procedure.Description;

public class BatchAndTotalResult {
    @Description(value="The total number of batches.")
    public final long batches;
    @Description(value="The number of processed input rows.")
    public final long total;
    @Description(value="The duration taken in seconds.")
    public final long timeTaken;
    @Description(value="The number of successful inner queries (actions).")
    public final long committedOperations;
    @Description(value="The number of failed inner queries (actions).")
    public final long failedOperations;
    @Description(value="The number of failed batches.")
    public final long failedBatches;
    @Description(value="The number of retries.")
    public final long retries;
    @Description(value="A map of batch error messages paired with their corresponding error counts.")
    public final Map<String, Long> errorMessages;
    @Description(value="{\n     total :: INTEGER,\n     failed :: INTEGER,\n     committed :: INTEGER,\n     errors :: MAP\n}\n")
    public final Map<String, Object> batch;
    @Description(value="{\n     total :: INTEGER,\n     failed :: INTEGER,\n     committed :: INTEGER,\n     errors :: MAP\n}\n")
    public final Map<String, Object> operations;
    @Description(value="If the transaction was terminated before completion.")
    public final boolean wasTerminated;
    @Description(value="Parameters of failed batches. The key is the batch number as a STRING and the value is a list of batch parameters.")
    public final Map<String, List<Map<String, Object>>> failedParams;
    @Description(value="{\n    nodesCreated :: INTEGER,\n    nodesDeleted :: INTEGER,\n    relationshipsCreated :: INTEGER,\n    relationshipsDeleted :: INTEGER,\n    propertiesSet :: INTEGER,\n    labelsAdded :: INTEGER,\n    labelsRemoved :: INTEGER\n}\n")
    public final Map<String, Long> updateStatistics;

    public BatchAndTotalResult(long batches, long total, long timeTaken, long committedOperations, long failedOperations, long failedBatches, long retries, Map<String, Long> operationErrors, Map<String, Long> batchErrors, boolean wasTerminated, Map<String, List<Map<String, Object>>> failedParams, Map<String, Long> updateStatistics) {
        this.batches = batches;
        this.total = total;
        this.timeTaken = timeTaken;
        this.committedOperations = committedOperations;
        this.failedOperations = failedOperations;
        this.failedBatches = failedBatches;
        this.retries = retries;
        this.errorMessages = operationErrors;
        this.wasTerminated = wasTerminated;
        this.failedParams = failedParams;
        this.batch = Util.map("total", batches, "failed", failedBatches, "committed", batches - failedBatches, "errors", batchErrors);
        this.operations = Util.map("total", total, "failed", failedOperations, "committed", committedOperations, "errors", operationErrors);
        this.updateStatistics = updateStatistics;
    }
}

