/*
 * Decompiled with CFR 0.152.
 */
package apoc.result;

import apoc.export.cypher.ExportFileManager;
import apoc.export.util.ExportConfig;
import apoc.result.ProgressInfo;
import java.io.StringWriter;
import org.neo4j.procedure.Description;

public class DataProgressInfo
implements ProgressInfo {
    @Description(value="The name of the file to which the data was exported.")
    public final String file;
    @Description(value="The number of batches the export was run in.")
    public long batches;
    @Description(value="A summary of the exported data.")
    public String source;
    @Description(value="The format the file is exported in.")
    public final String format;
    @Description(value="The number of exported nodes.")
    public long nodes;
    @Description(value="The number of exported relationships.")
    public long relationships;
    @Description(value="The number of exported properties.")
    public long properties;
    @Description(value="The duration of the export.")
    public long time;
    @Description(value="The number of rows returned.")
    public long rows;
    @Description(value="The size of the batches the export was run in.")
    public long batchSize;
    @Description(value="The executed Cypher Statements.")
    public Object cypherStatements;
    @Description(value="The executed node statements.")
    public Object nodeStatements;
    @Description(value="The executed relationship statements.")
    public Object relationshipStatements;
    @Description(value="The executed schema statements.")
    public Object schemaStatements;
    @Description(value="The executed cleanup statements.")
    public Object cleanupStatements;
    public static final DataProgressInfo EMPTY = new DataProgressInfo(null, null, null);

    public DataProgressInfo(String file, String source, String format) {
        this.file = file;
        this.source = source;
        this.format = format;
    }

    public DataProgressInfo(DataProgressInfo pi) {
        this.file = pi.file;
        this.format = pi.format;
        this.source = pi.source;
        this.nodes = pi.nodes;
        this.relationships = pi.relationships;
        this.properties = pi.properties;
        this.time = pi.time;
        this.rows = pi.rows;
        this.batchSize = pi.batchSize;
        this.batches = pi.batches;
    }

    public String toString() {
        return String.format("nodes = %d rels = %d properties = %d", this.nodes, this.relationships, this.properties);
    }

    @Override
    public DataProgressInfo update(long nodes, long relationships, long properties) {
        this.nodes += nodes;
        this.relationships += relationships;
        this.properties += properties;
        return this;
    }

    @Override
    public DataProgressInfo updateTime(long start) {
        this.time = System.currentTimeMillis() - start;
        return this;
    }

    @Override
    public DataProgressInfo done(long start) {
        return this.updateTime(start);
    }

    @Override
    public void nextRow() {
        ++this.rows;
    }

    @Override
    public DataProgressInfo drain(StringWriter writer, ExportConfig config) {
        return this;
    }

    @Override
    public void setBatches(long batches) {
        this.batches = batches;
    }

    @Override
    public void setRows(long rows) {
        this.rows = rows;
    }

    @Override
    public long getBatchSize() {
        return this.batchSize;
    }

    public DataProgressInfo enrich(ExportFileManager fileInfo) {
        this.cypherStatements = fileInfo.drain("cypher");
        this.nodeStatements = fileInfo.drain("nodes");
        this.relationshipStatements = fileInfo.drain("relationships");
        this.schemaStatements = fileInfo.drain("schema");
        this.cleanupStatements = fileInfo.drain("cleanup");
        return this;
    }
}

