/*
 * Decompiled with CFR 0.152.
 */
package apoc.util.s3;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadResult;
import com.amazonaws.services.s3.model.PartETag;
import com.amazonaws.services.s3.model.UploadPartRequest;
import com.amazonaws.services.s3.model.UploadPartResult;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

public class S3OutputStream
extends OutputStream {
    private volatile boolean isDone = false;
    private volatile long totalMemory = 0L;
    private long transferred = 0L;
    private int buffSize = 0;
    private final Object totalMemoryLock = new Object();
    private final Future<?> managerFuture;
    private byte[] buffer;
    private final String bucketName;
    private final String keyName;
    private final BlockingQueue<S3UploadData> queue = new LinkedBlockingQueue<S3UploadData>();
    private int maxWaitTimeMinutes = 65536;

    S3OutputStream(@Nonnull AmazonS3 s3Client, @Nonnull String bucketName, @Nonnull String keyName, int maxWaitTimeMinutes) throws IOException {
        this(s3Client, bucketName, keyName);
        this.maxWaitTimeMinutes = maxWaitTimeMinutes;
    }

    S3OutputStream(@Nonnull AmazonS3 s3Client, @Nonnull String bucketName, @Nonnull String keyName) throws IOException {
        if (bucketName.isEmpty() || keyName.isEmpty()) {
            throw new InvalidParameterException("Bucket and/or key pass to S3OutputStream is empty.");
        }
        this.bucketName = bucketName;
        this.keyName = keyName;
        this.allocateMemory(AllocationSize.MB_5);
        ExecutorService executorService = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("S3-Upload-Manager-Thread-%d").setDaemon(true).build());
        this.managerFuture = executorService.submit(new S3UploadManager(s3Client, this.queue));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void allocateMemory(AllocationSize allocationSize) throws IOException {
        long incomingSize = allocationSize.getAllocationSize();
        Object object = this.totalMemoryLock;
        synchronized (object) {
            if (incomingSize > S3UploadConstants.TOTAL_MEMORY_ALLOWED) {
                throw new IOException(String.format("A total of %d bytes of memory were provided for all buffers, but a buffer of %d bytes was requested.", S3UploadConstants.TOTAL_MEMORY_ALLOWED, incomingSize));
            }
            while (this.totalMemory + incomingSize > S3UploadConstants.TOTAL_MEMORY_ALLOWED) {
                try {
                    this.totalMemoryLock.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        object = this.totalMemoryLock;
        synchronized (object) {
            this.totalMemory += incomingSize;
        }
        this.buffer = new byte[(int)incomingSize];
    }

    private void transmitBuffer() throws IOException {
        this.queue.add(new S3UploadData(new ByteArrayInputStream(this.buffer), false, this.buffSize));
        this.transferred += (long)this.buffSize;
        this.buffSize = 0;
        if (this.transferred < S3UploadConstants.TRANSFERRED_2p5GB) {
            this.allocateMemory(AllocationSize.MB_5);
        } else if (this.transferred < S3UploadConstants.TRANSFERRED_25GB) {
            this.allocateMemory(AllocationSize.MB_50);
        } else if (this.transferred < S3UploadConstants.TRANSFERRED_2TB) {
            this.allocateMemory(AllocationSize.MB_500);
        } else {
            this.allocateMemory(AllocationSize.MB_750);
        }
    }

    @Override
    public void write(int i) throws IOException {
        this.write(new byte[]{(byte)i}, 0, 1);
    }

    @Override
    public void write(@Nonnull byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(@Nonnull byte[] b, int offset, int length) throws IOException {
        int rdPtr = offset;
        do {
            int wrAmount = Math.min(this.buffer.length - this.buffSize, length - (rdPtr - offset));
            System.arraycopy(b, rdPtr, this.buffer, this.buffSize, wrAmount);
            this.buffSize += wrAmount;
            rdPtr += wrAmount;
            if (this.buffer.length != this.buffSize) continue;
            this.transmitBuffer();
        } while (rdPtr - offset < length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block5: {
            this.isDone = true;
            this.queue.add(new S3UploadData(new ByteArrayInputStream(this.buffer), true, this.buffSize));
            this.buffer = null;
            try {
                Future<?> future = this.managerFuture;
                synchronized (future) {
                    this.managerFuture.get();
                }
            }
            catch (InterruptedException | ExecutionException e) {
                if (!(e instanceof InterruptedException)) break block5;
                Thread.currentThread().interrupt();
            }
        }
    }

    private static class S3UploadConstants {
        private static final int MB = 0x100000;
        private static final long TRANSFERRED_2p5GB = (long)AllocationSize.MB_5.getAllocationSize() * 500L;
        private static final long TRANSFERRED_25GB = (long)AllocationSize.MB_50.getAllocationSize() * 500L;
        private static final long TRANSFERRED_2TB = (long)AllocationSize.MB_500.getAllocationSize() * 4000L;
        private static final long TOTAL_MEMORY_ALLOWED = (long)AllocationSize.MB_750.getAllocationSize() * 3L;
        private static final int MAX_THREAD_COUNT = 8;
        private static final int MAX_WAIT_TIME_MINUTES = 65536;

        private S3UploadConstants() {
        }
    }

    public static enum AllocationSize {
        MB_5(0x500000),
        MB_50(0x3200000),
        MB_500(524288000),
        MB_750(0x2EE00000);

        private final int allocationSize;

        private AllocationSize(int allocationSize) {
            this.allocationSize = allocationSize;
        }

        int getAllocationSize() {
            return this.allocationSize;
        }
    }

    public class S3UploadManager
    implements Runnable {
        private final AmazonS3 s3Client;
        private final String uploadId;
        private final BlockingQueue<S3UploadData> queue;
        private final List<PartETag> partETags = new ArrayList<PartETag>();
        private final InitiateMultipartUploadResult initResponse;
        private final ExecutorService executorService = Executors.newFixedThreadPool(8, new ThreadFactoryBuilder().setNameFormat("S3-Upload-Thread-%d").setDaemon(true).build());

        S3UploadManager(@Nonnull AmazonS3 s3Client, BlockingQueue<S3UploadData> queue) {
            this.s3Client = s3Client;
            this.queue = queue;
            this.initResponse = s3Client.initiateMultipartUpload(new InitiateMultipartUploadRequest(S3OutputStream.this.bucketName, S3OutputStream.this.keyName));
            this.uploadId = this.initResponse.getUploadId();
        }

        @Override
        public void run() {
            int partNumber = 1;
            while (!S3OutputStream.this.isDone || !this.queue.isEmpty()) {
                try {
                    S3UploadData data = this.queue.take();
                    this.executorService.submit(new Uploader(partNumber++, data));
                }
                catch (InterruptedException exception) {
                    Thread.currentThread().interrupt();
                }
            }
            this.executorService.shutdown();
            try {
                this.executorService.awaitTermination(S3OutputStream.this.maxWaitTimeMinutes, TimeUnit.MINUTES);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            this.s3Client.completeMultipartUpload(new CompleteMultipartUploadRequest(S3OutputStream.this.bucketName, S3OutputStream.this.keyName, this.initResponse.getUploadId(), this.partETags));
        }

        public class Uploader
        implements Runnable {
            private final int partNumber;
            private final S3UploadData s3UploadData;

            Uploader(@Nonnull int partNumber, S3UploadData s3UploadData) {
                this.partNumber = partNumber;
                this.s3UploadData = s3UploadData;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                UploadPartRequest uploadPartRequest = new UploadPartRequest().withBucketName(S3OutputStream.this.bucketName).withKey(S3OutputStream.this.keyName).withUploadId(S3UploadManager.this.uploadId).withPartNumber(this.partNumber).withInputStream(this.s3UploadData.getStream()).withPartSize((long)this.s3UploadData.getSize()).withLastPart(this.s3UploadData.getIsLast());
                UploadPartResult result = S3UploadManager.this.s3Client.uploadPart(uploadPartRequest);
                S3UploadManager.this.partETags.add(result.getPartETag());
                Object object = S3OutputStream.this.totalMemoryLock;
                synchronized (object) {
                    S3OutputStream.this.totalMemory -= (long)this.s3UploadData.getSize();
                    S3OutputStream.this.totalMemoryLock.notifyAll();
                }
            }
        }
    }

    private static class S3UploadData {
        private final InputStream stream;
        private final boolean isLast;
        private final int size;

        S3UploadData(@Nonnull InputStream stream, boolean isLast, int size) {
            this.stream = stream;
            this.isLast = isLast;
            this.size = size;
        }

        InputStream getStream() {
            return this.stream;
        }

        boolean getIsLast() {
            return this.isLast;
        }

        int getSize() {
            return this.size;
        }
    }
}

