/*
 * Decompiled with CFR 0.152.
 */
package apoc;

import apoc.ApocExtensionFactory;
import apoc.ApocGlobalComponents;
import apoc.TTLConfig;
import apoc.custom.CypherProcedures;
import apoc.custom.CypherProceduresHandler;
import apoc.load.LoadDirectory;
import apoc.load.LoadDirectoryHandler;
import apoc.ttl.TTLLifeCycle;
import apoc.uuid.Uuid;
import apoc.uuid.UuidHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.kernel.availability.AvailabilityListener;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.Log;

public class ExtendedApocGlobalComponents
implements ApocGlobalComponents {
    public Map<String, Lifecycle> getServices(GraphDatabaseAPI db, ApocExtensionFactory.Dependencies dependencies) {
        CypherProceduresHandler cypherProcedureHandler = new CypherProceduresHandler(db, dependencies.scheduler(), dependencies.apocConfig(), (Log)dependencies.log().getUserLog(CypherProcedures.class), dependencies.globalProceduresRegistry());
        HashMap<String, Lifecycle> serviceMap = new HashMap<String, Lifecycle>();
        serviceMap.put("ttl", (Lifecycle)new TTLLifeCycle(dependencies.scheduler(), db, TTLConfig.ttlConfig(), (Log)dependencies.log().getUserLog(TTLLifeCycle.class)));
        serviceMap.put("uuid", (Lifecycle)new UuidHandler(db, dependencies.databaseManagementService(), (Log)dependencies.log().getUserLog(Uuid.class), dependencies.apocConfig(), dependencies.scheduler(), dependencies.pools()));
        serviceMap.put("directory", (Lifecycle)new LoadDirectoryHandler((GraphDatabaseService)db, (Log)dependencies.log().getUserLog(LoadDirectory.class), dependencies.pools()));
        serviceMap.put("cypherProcedures", (Lifecycle)cypherProcedureHandler);
        boolean isKafkaEnabled = dependencies.apocConfig().getConfig().getBoolean("apoc.kafka.enabled", false);
        if (isKafkaEnabled) {
            try {
                Class<?> kafkaHandlerClass = Class.forName("apoc.kafka.KafkaHandler");
                Lifecycle kafkaHandler = (Lifecycle)kafkaHandlerClass.getConstructor(GraphDatabaseAPI.class, Log.class).newInstance(db, dependencies.log().getUserLog(kafkaHandlerClass));
                serviceMap.put("kafkaHandler", kafkaHandler);
            }
            catch (Exception e) {
                dependencies.log().getUserLog(ExtendedApocGlobalComponents.class).warn("Cannot find the Kafka extra jar.\nPlease put the apoc-kafka-dependencies-5.x.x-all.jar into plugin folder.\nSee the documentation: https://neo4j.com/labs/apoc/5/overview/apoc.kakfa");
            }
        }
        return serviceMap;
    }

    public Collection<Class> getContextClasses() {
        ArrayList<Class> contextClasses = new ArrayList<Class>(Arrays.asList(CypherProceduresHandler.class, UuidHandler.class, LoadDirectoryHandler.class));
        try {
            contextClasses.add(Class.forName("apoc.kafka.KafkaHandler"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return contextClasses;
    }

    public Iterable<AvailabilityListener> getListeners(GraphDatabaseAPI db, ApocExtensionFactory.Dependencies dependencies) {
        return Collections.emptyList();
    }
}

