/*
 * Decompiled with CFR 0.152.
 */
package apoc;

import apoc.ExtendedApocConfig;
import apoc.load.jdbc.Jdbc;
import apoc.util.Util;
import apoc.util.collection.Iterators;
import org.neo4j.kernel.extension.ExtensionFactory;
import org.neo4j.kernel.extension.ExtensionType;
import org.neo4j.kernel.extension.context.ExtensionContext;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public class JdbcRegistererInitFactory
extends ExtensionFactory<Dependencies> {
    public JdbcRegistererInitFactory() {
        super(ExtensionType.GLOBAL, "JdbcDriverRegisterer");
    }

    public Lifecycle newInstance(ExtensionContext context, final Dependencies dependencies) {
        return new LifecycleAdapter(this){

            public void init() throws Exception {
                Util.newDaemonThread(() -> {
                    ExtendedApocConfig extendedApocConfig = dependencies.extendedApocConfig();
                    while (!extendedApocConfig.isInitialized()) {
                        Util.sleep((int)10);
                    }
                    Iterators.stream(extendedApocConfig.getKeys("apoc.jdbc")).filter(k -> k.endsWith("driver")).forEach(Jdbc::loadDriver);
                }).start();
            }
        };
    }

    public static interface Dependencies {
        public ExtendedApocConfig extendedApocConfig();
    }
}

