/*
 * Decompiled with CFR 0.152.
 */
package apoc.agg;

import java.util.Map;

public class AggregationUtil {
    public static void updateAggregationValues(Map<String, Number> partialResult, Object property, String countKey, String sumKey, String avgKey) {
        Number count = AggregationUtil.updateCountValue(partialResult, countKey);
        AggregationUtil.updateSumAndAvgValues(partialResult, property, count.doubleValue(), sumKey, avgKey);
    }

    private static Number updateCountValue(Map<String, Number> partialResult, String countKey) {
        Number count = partialResult.compute(countKey, (subKey, subVal) -> subVal == null ? 1L : subVal.longValue() + 1L);
        return count;
    }

    private static void updateSumAndAvgValues(Map<String, Number> partialResult, Object property, double count, String sumKey, String avgKey) {
        if (!(property instanceof Number)) {
            return;
        }
        Number numberProp = (Number)property;
        Number sum = partialResult.compute(sumKey, (subKey, subVal) -> {
            if (subVal == null) {
                if (numberProp instanceof Long) {
                    Long longProp = (Long)numberProp;
                    return longProp;
                }
                return numberProp.doubleValue();
            }
            if (subVal instanceof Long) {
                Long long1 = (Long)subVal;
                if (numberProp instanceof Long) {
                    Long long2 = (Long)numberProp;
                    return long1 + long2;
                }
            }
            return subVal.doubleValue() + numberProp.doubleValue();
        });
        partialResult.compute(avgKey, (subKey, subVal) -> {
            if (subVal == null) {
                return numberProp.doubleValue();
            }
            return sum.doubleValue() / count;
        });
    }
}

