/*
 * Decompiled with CFR 0.152.
 */
package apoc.agg;

import apoc.Extended;
import apoc.agg.AggregationUtil;
import apoc.util.ExtendedListUtils;
import apoc.util.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.neo4j.graphdb.Entity;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.UserAggregationFunction;
import org.neo4j.procedure.UserAggregationResult;
import org.neo4j.procedure.UserAggregationUpdate;

@Extended
public class Rollup {
    public static final String NULL_ROLLUP = "[NULL]";

    @UserAggregationFunction(value="apoc.agg.rollup")
    @Description(value="apoc.agg.rollup(<ANY>, [groupKeys], [aggKeys])\n Emulate an Oracle/Mysql rollup command: `ROLLUP groupKeys, SUM(aggKey1), AVG(aggKey1), COUNT(aggKey1), SUM(aggKey2), AVG(aggKey2), ... `")
    public RollupFunction rollup() {
        return new RollupFunction();
    }

    public static class RollupFunction {
        private final Map<String, Object> result = new HashMap<String, Object>();
        private final Map<List<Object>, Map<String, Number>> rolledUpData = new HashMap<List<Object>, Map<String, Number>>();
        private List<String> groupKeysRes = null;

        public static <T> List<List<T>> generateCombinationsWithPlaceholder(List<T> elements) {
            ArrayList<List<T>> result = new ArrayList<List<T>>();
            RollupFunction.generateCombinationsWithPlaceholder(elements, 0, new ArrayList(), result);
            return result;
        }

        private static <T> void generateCombinationsWithPlaceholder(List<T> elements, int index, List<T> current, List<List<T>> result) {
            if (index == elements.size()) {
                result.add(new ArrayList<T>(current));
                return;
            }
            current.add(elements.get(index));
            RollupFunction.generateCombinationsWithPlaceholder(elements, index + 1, current, result);
            current.remove(current.size() - 1);
            current.add(Rollup.NULL_ROLLUP);
            RollupFunction.generateCombinationsWithPlaceholder(elements, index + 1, current, result);
            current.remove(current.size() - 1);
        }

        @UserAggregationUpdate
        public void aggregate(@Name(value="value") Object value, @Name(value="groupKeys") List<String> groupKeys, @Name(value="aggKeys") List<String> aggKeys, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
            boolean cube = Util.toBoolean((Object)config.get("cube"));
            Entity entity = (Entity)value;
            if (groupKeys.isEmpty()) {
                return;
            }
            this.groupKeysRes = groupKeys;
            if (cube) {
                List<List<String>> groupingSets = RollupFunction.generateCombinationsWithPlaceholder(groupKeys);
                for (List<String> groupKey : groupingSets) {
                    ArrayList<Object> partialKey = new ArrayList<Object>();
                    for (String column : groupKey) {
                        partialKey.add(((Entity)value).getProperty(column, (Object)Rollup.NULL_ROLLUP));
                    }
                    if (!this.rolledUpData.containsKey(partialKey)) {
                        this.rolledUpData.put(partialKey, new HashMap());
                    }
                    this.rollupAggregationProperties(aggKeys, entity, partialKey);
                }
                return;
            }
            List<Object> groupKey = groupKeys.stream().map(i -> entity.getProperty(i, null)).toList();
            for (int i2 = 0; i2 <= groupKey.size(); ++i2) {
                List<Object> partialKey = ExtendedListUtils.union(groupKey.subList(0, i2), Collections.nCopies(groupKey.size() - i2, Rollup.NULL_ROLLUP));
                if (!this.rolledUpData.containsKey(partialKey)) {
                    this.rolledUpData.put(partialKey, new HashMap());
                }
                this.rollupAggregationProperties(aggKeys, entity, partialKey);
            }
        }

        private void rollupAggregationProperties(List<String> aggKeys, Entity entity, List<Object> partialKey) {
            Map<String, Number> partialResult = this.rolledUpData.get(partialKey);
            for (String aggKey : aggKeys) {
                if (!entity.hasProperty(aggKey)) continue;
                Object property = entity.getProperty(aggKey);
                String countKey = "COUNT(%s)".formatted(aggKey);
                String sumKey = "SUM(%s)".formatted(aggKey);
                String avgKey = "AVG(%s)".formatted(aggKey);
                AggregationUtil.updateAggregationValues(partialResult, property, countKey, sumKey, avgKey);
            }
        }

        @UserAggregationResult
        public Object result() {
            List<HashMap> list = this.rolledUpData.entrySet().stream().map(e -> {
                HashMap map = new HashMap();
                for (int i = 0; i < this.groupKeysRes.size(); ++i) {
                    map.put(this.groupKeysRes.get(i), ((List)e.getKey()).get(i));
                }
                map.putAll((Map)e.getValue());
                return map;
            }).sorted((m1, m2) -> {
                for (String key : this.groupKeysRes) {
                    Object value2;
                    Object value1 = m1.get(key);
                    int cmp = RollupFunction.compareValues(value1, value2 = m2.get(key));
                    if (cmp == 0) continue;
                    return cmp;
                }
                return 0;
            }).toList();
            return list;
        }

        private static int compareValues(Object value1, Object value2) {
            if (value1 == null && value2 == null) {
                return 0;
            }
            if (value1 == null) {
                return 1;
            }
            if (value2 == null) {
                return -1;
            }
            if (Rollup.NULL_ROLLUP.equals(value1) && Rollup.NULL_ROLLUP.equals(value2)) {
                return 0;
            }
            if (Rollup.NULL_ROLLUP.equals(value1)) {
                return 1;
            }
            if (Rollup.NULL_ROLLUP.equals(value2)) {
                return -1;
            }
            if (value1 instanceof Comparable && value2 instanceof Comparable) {
                try {
                    return ((Comparable)value1).compareTo(value2);
                }
                catch (Exception e) {
                    return 0;
                }
            }
            return 0;
        }
    }
}

