/*
 * Decompiled with CFR 0.152.
 */
package apoc.convert;

import apoc.Extended;
import apoc.convert.ConvertExtendedUtil;
import apoc.convert.ConvertUtils;
import apoc.meta.Types;
import apoc.util.ExtendedUtil;
import apoc.util.Util;
import apoc.util.collection.Iterables;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.UserFunction;

@Extended
public class ConvertExtended {
    @UserFunction(value="apoc.convert.toYaml")
    @Description(value="apoc.convert.toYaml(value, $config) - Serializes the given value to a YAML string")
    public String toYaml(@Name(value="value") Object value, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        Object result = this.writeYamlResult(value);
        try {
            return ConvertExtendedUtil.getYamlFactory(result, config);
        }
        catch (IOException e) {
            throw new RuntimeException("Can't convert value to yaml", e);
        }
    }

    @UserFunction(value="apoc.convert.fromYaml")
    @Description(value="apoc.convert.fromYaml(value, $config) - Deserializes the YAML string to Neo4j value")
    public Object fromYaml(@Name(value="value") String value, @Name(value="config", defaultValue="{}") Map<String, Object> config) throws Exception {
        Object parse = ConvertExtendedUtil.parse(value, config);
        Map<String, Object> mappingConf = config.getOrDefault("mapping", Map.of());
        return ExtendedUtil.toValidYamlValue(parse, null, mappingConf, true);
    }

    private Object writeYamlResult(Object value) {
        Types type = Types.of((Object)value);
        return switch (type) {
            case Types.NODE -> this.nodeToMap((Node)value);
            case Types.RELATIONSHIP -> this.relToMap((Relationship)value);
            case Types.PATH -> this.writeYamlResult(Iterables.stream((Iterable)((Path)value)).map(i -> i instanceof Node ? this.nodeToMap((Node)i) : this.relToMap((Relationship)i)).collect(Collectors.toList()));
            case Types.LIST -> ConvertUtils.convertToList((Object)value).stream().map(this::writeYamlResult).collect(Collectors.toList());
            case Types.MAP -> ((Map)value).entrySet().stream().collect(HashMap::new, (mapAccumulator, entry) -> mapAccumulator.put(entry.getKey(), this.writeYamlResult(entry.getValue())), HashMap::putAll);
            default -> value;
        };
    }

    private Map<String, Object> relToMap(Relationship rel) {
        Map mapRel = Util.map((Object[])new Object[]{"id", rel.getElementId(), "type", "relationship", "label", rel.getType().toString(), "start", this.nodeToMap(rel.getStartNode()), "end", this.nodeToMap(rel.getEndNode())});
        return this.mapWithOptionalProps(mapRel, rel.getAllProperties());
    }

    private Map<String, Object> nodeToMap(Node node) {
        Map mapNode = Util.map((Object[])new Object[]{"id", node.getElementId()});
        mapNode.put("type", "node");
        if (node.getLabels().iterator().hasNext()) {
            mapNode.put("labels", Util.labelStrings((Node)node));
        }
        return this.mapWithOptionalProps(mapNode, node.getAllProperties());
    }

    private Map<String, Object> mapWithOptionalProps(Map<String, Object> mapEntity, Map<String, Object> props) {
        if (!props.isEmpty()) {
            mapEntity.put("properties", props);
        }
        return mapEntity;
    }
}

