/*
 * Decompiled with CFR 0.152.
 */
package apoc.convert;

import apoc.export.util.DurationValueSerializer;
import apoc.export.util.PointSerializer;
import apoc.export.util.TemporalSerializer;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import java.time.temporal.Temporal;
import java.util.List;
import java.util.Map;
import org.neo4j.graphdb.spatial.Point;
import org.neo4j.values.storable.DurationValue;

public class ConvertExtendedUtil {
    private static final SimpleModule YAML_MODULE = new SimpleModule("Neo4jApocYamlSerializer");
    public static final String MAPPING_KEY = "mapping";

    public static String getYamlFactory(Object result, Map<String, Object> config) throws JsonProcessingException {
        YAMLFactory factory = new YAMLFactory();
        List enable = config.getOrDefault("enable", List.of());
        List disable = config.getOrDefault("disable", List.of());
        enable.forEach(name -> factory.enable(YAMLGenerator.Feature.valueOf((String)name)));
        disable.forEach(name -> factory.disable(YAMLGenerator.Feature.valueOf((String)name)));
        ObjectMapper objectMapper = new ObjectMapper((JsonFactory)factory);
        objectMapper.registerModule((Module)YAML_MODULE);
        return objectMapper.writeValueAsString(result);
    }

    public static Object parse(String value, Map<String, Object> config) throws JsonProcessingException {
        YAMLFactory factory = new YAMLFactory();
        List enable = config.getOrDefault("enable", List.of());
        List disable = config.getOrDefault("disable", List.of());
        enable.forEach(name -> factory.enable(YAMLGenerator.Feature.valueOf((String)name)));
        disable.forEach(name -> factory.disable(YAMLGenerator.Feature.valueOf((String)name)));
        ObjectMapper objectMapper = new ObjectMapper((JsonFactory)factory);
        objectMapper.registerModule((Module)YAML_MODULE);
        return objectMapper.readValue(value, Object.class);
    }

    static {
        YAML_MODULE.addSerializer(Point.class, (JsonSerializer)new PointSerializer());
        YAML_MODULE.addSerializer(Temporal.class, (JsonSerializer)new TemporalSerializer());
        YAML_MODULE.addSerializer(DurationValue.class, (JsonSerializer)new DurationValueSerializer());
    }
}

