/*
 * Decompiled with CFR 0.152.
 */
package apoc.custom;

import apoc.ExtendedSystemLabels;
import apoc.ExtendedSystemPropertyKeys;
import apoc.SystemPropertyKeys;
import apoc.custom.CustomProcedureInfo;
import apoc.custom.CypherProceduresUtil;
import apoc.util.SystemDbUtil;
import apoc.util.Util;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.MapUtil;
import org.neo4j.internal.kernel.api.procs.FieldSignature;
import org.neo4j.internal.kernel.api.procs.ProcedureSignature;
import org.neo4j.internal.kernel.api.procs.QualifiedName;
import org.neo4j.internal.kernel.api.procs.UserFunctionSignature;

public class CypherHandlerNewProcedure {
    public static void installProcedure(String databaseName, ProcedureSignature signature, String statement) {
        SystemDbUtil.withSystemDb(tx -> {
            Node node = Util.mergeNode((Transaction)tx, (Label)ExtendedSystemLabels.ApocCypherProcedures, (Label)ExtendedSystemLabels.Procedure, (Pair[])new Pair[]{Pair.of((Object)SystemPropertyKeys.database.name(), (Object)databaseName), Pair.of((Object)SystemPropertyKeys.name.name(), (Object)signature.name().name()), Pair.of((Object)ExtendedSystemPropertyKeys.prefix.name(), (Object)signature.name().namespace())});
            node.setProperty(ExtendedSystemPropertyKeys.description.name(), signature.description().orElse(null));
            node.setProperty(SystemPropertyKeys.statement.name(), (Object)statement);
            node.setProperty(ExtendedSystemPropertyKeys.inputs.name(), (Object)CypherHandlerNewProcedure.serializeSignatures(signature.inputSignature()));
            node.setProperty(ExtendedSystemPropertyKeys.outputs.name(), (Object)CypherHandlerNewProcedure.serializeSignatures(signature.outputSignature()));
            node.setProperty(ExtendedSystemPropertyKeys.mode.name(), (Object)signature.mode().name());
            CypherHandlerNewProcedure.setLastUpdate(tx, databaseName);
        });
    }

    public static void installFunction(String databaseName, UserFunctionSignature signature, String statement, boolean forceSingle) {
        SystemDbUtil.withSystemDb(tx -> {
            Node node = Util.mergeNode((Transaction)tx, (Label)ExtendedSystemLabels.ApocCypherProcedures, (Label)ExtendedSystemLabels.Function, (Pair[])new Pair[]{Pair.of((Object)SystemPropertyKeys.database.name(), (Object)databaseName), Pair.of((Object)SystemPropertyKeys.name.name(), (Object)signature.name().name()), Pair.of((Object)ExtendedSystemPropertyKeys.prefix.name(), (Object)signature.name().namespace())});
            node.setProperty(ExtendedSystemPropertyKeys.description.name(), signature.description().orElse(null));
            node.setProperty(SystemPropertyKeys.statement.name(), (Object)statement);
            node.setProperty(ExtendedSystemPropertyKeys.inputs.name(), (Object)CypherHandlerNewProcedure.serializeSignatures(signature.inputSignature()));
            node.setProperty(ExtendedSystemPropertyKeys.output.name(), (Object)signature.outputType().toString());
            node.setProperty(ExtendedSystemPropertyKeys.forceSingle.name(), (Object)forceSingle);
            CypherHandlerNewProcedure.setLastUpdate(tx, databaseName);
        });
    }

    public static List<CustomProcedureInfo> dropAll(String databaseName) {
        return SystemDbUtil.withSystemDb(tx -> {
            List previous = CypherHandlerNewProcedure.getCustomNodes(databaseName, tx).stream().map(node -> {
                CustomProcedureInfo info = CustomProcedureInfo.fromNode(node);
                node.delete();
                return info;
            }).sorted(CypherHandlerNewProcedure.sortNodes()).collect(Collectors.toList());
            CypherHandlerNewProcedure.setLastUpdate(tx, databaseName);
            return previous;
        });
    }

    public static Stream<CustomProcedureInfo> show(String databaseName, Transaction tx) {
        return CypherHandlerNewProcedure.getCustomNodes(databaseName, tx).stream().map(CustomProcedureInfo::fromNode).sorted(CypherHandlerNewProcedure.sortNodes());
    }

    private static Comparator<CustomProcedureInfo> sortNodes() {
        return Comparator.comparing(i -> i.name).thenComparing(i -> i.type);
    }

    public static void dropFunction(String databaseName, String name) {
        SystemDbUtil.withSystemDb(tx -> {
            QualifiedName qName = CypherProceduresUtil.qualifiedName(name);
            CypherHandlerNewProcedure.getCustomNodes(databaseName, tx, Map.of(SystemPropertyKeys.name.name(), qName.name(), ExtendedSystemPropertyKeys.prefix.name(), qName.namespace())).stream().filter(n -> n.hasLabel((Label)ExtendedSystemLabels.Function)).forEach(node -> {
                node.delete();
                CypherHandlerNewProcedure.setLastUpdate(tx, databaseName);
            });
        });
    }

    public static void dropProcedure(String databaseName, String name) {
        SystemDbUtil.withSystemDb(tx -> {
            QualifiedName qName = CypherProceduresUtil.qualifiedName(name);
            CypherHandlerNewProcedure.getCustomNodes(databaseName, tx, Map.of(SystemPropertyKeys.database.name(), databaseName, SystemPropertyKeys.name.name(), qName.name(), ExtendedSystemPropertyKeys.prefix.name(), qName.namespace())).stream().filter(n -> n.hasLabel((Label)ExtendedSystemLabels.Procedure)).forEach(node -> {
                node.delete();
                CypherHandlerNewProcedure.setLastUpdate(tx, databaseName);
            });
        });
    }

    public static ResourceIterator<Node> getCustomNodes(String databaseName, Transaction tx) {
        return CypherHandlerNewProcedure.getCustomNodes(databaseName, tx, null);
    }

    public static ResourceIterator<Node> getCustomNodes(String databaseName, Transaction tx, Map<String, Object> props) {
        return SystemDbUtil.getSystemNodes(tx, databaseName, ExtendedSystemLabels.ApocCypherProcedures, props);
    }

    public static String serializeSignatures(List<FieldSignature> signatures) {
        List mapped = signatures.stream().map(fs -> {
            Map map = MapUtil.map((Object[])new Object[]{"name", fs.name(), "type", fs.neo4jType().toString()});
            fs.defaultValue().map(defVal -> map.put("default", defVal.value()));
            return map;
        }).collect(Collectors.toList());
        return Util.toJson(mapped);
    }

    private static void setLastUpdate(Transaction tx, String databaseName) {
        SystemDbUtil.setLastUpdate(tx, databaseName, ExtendedSystemLabels.ApocCypherProceduresMeta);
    }
}

