/*
 * Decompiled with CFR 0.152.
 */
package apoc.custom;

import apoc.Extended;
import apoc.custom.CustomProcedureInfo;
import apoc.custom.CypherHandlerNewProcedure;
import apoc.custom.CypherProceduresUtil;
import apoc.custom.Signatures;
import apoc.util.SystemDbUtil;
import java.util.stream.Stream;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.procs.ProcedureSignature;
import org.neo4j.internal.kernel.api.procs.UserFunctionSignature;
import org.neo4j.kernel.api.procedure.SystemProcedure;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Admin;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@Extended
public class CypherNewProcedures {
    @Context
    public GraphDatabaseAPI db;
    @Context
    public Log log;
    @Context
    public Transaction tx;

    private void checkIsValidDatabase(String databaseName) {
        SystemDbUtil.checkInSystemLeader((GraphDatabaseService)this.db);
        SystemDbUtil.checkTargetDatabase(this.tx, databaseName, "Custom procedures/functions");
        CypherProceduresUtil.checkEnabled();
    }

    @SystemProcedure
    @Admin
    @Procedure(value="apoc.custom.installProcedure", mode=Mode.WRITE)
    @Description(value="Eventually registers a custom cypher procedure")
    public void installProcedure(@Name(value="signature") String signature, @Name(value="statement") String statement, @Name(value="databaseName", defaultValue="neo4j") String databaseName, @Name(value="mode", defaultValue="read") String mode, @Name(value="description", defaultValue="") String description) {
        this.checkIsValidDatabase(databaseName);
        Mode modeProcedure = CypherProceduresUtil.mode(mode);
        ProcedureSignature procedureSignature = new Signatures("custom").asProcedureSignature(signature, description, modeProcedure);
        CypherHandlerNewProcedure.installProcedure(databaseName, procedureSignature, statement);
    }

    @SystemProcedure
    @Admin
    @Procedure(value="apoc.custom.installFunction", mode=Mode.WRITE)
    @Description(value="Eventually registers a custom cypher function")
    public void installFunction(@Name(value="signature") String signature, @Name(value="statement") String statement, @Name(value="databaseName", defaultValue="neo4j") String databaseName, @Name(value="forceSingle", defaultValue="false") boolean forceSingle, @Name(value="description", defaultValue="") String description) {
        this.checkIsValidDatabase(databaseName);
        UserFunctionSignature userFunctionSignature = new Signatures("custom").asFunctionSignature(signature, description);
        CypherHandlerNewProcedure.installFunction(databaseName, userFunctionSignature, statement, forceSingle);
    }

    @SystemProcedure
    @Admin
    @Procedure(value="apoc.custom.dropProcedure", mode=Mode.WRITE)
    @Description(value="Eventually drops the targeted custom procedure")
    public void dropProcedure(@Name(value="name") String name, @Name(value="databaseName", defaultValue="neo4j") String databaseName) {
        this.checkIsValidDatabase(databaseName);
        CypherHandlerNewProcedure.dropProcedure(databaseName, name);
    }

    @SystemProcedure
    @Admin
    @Procedure(value="apoc.custom.dropFunction", mode=Mode.WRITE)
    @Description(value="Eventually drops the targeted custom function")
    public void dropFunction(@Name(value="name") String name, @Name(value="databaseName", defaultValue="neo4j") String databaseName) {
        this.checkIsValidDatabase(databaseName);
        CypherHandlerNewProcedure.dropFunction(databaseName, name);
    }

    @SystemProcedure
    @Admin
    @Procedure(value="apoc.custom.dropAll", mode=Mode.WRITE)
    @Description(value="Eventually drops all previously added custom procedures/functions and returns info")
    public Stream<CustomProcedureInfo> dropAll(@Name(value="databaseName", defaultValue="neo4j") String databaseName) {
        this.checkIsValidDatabase(databaseName);
        return CypherHandlerNewProcedure.dropAll(databaseName).stream();
    }

    @SystemProcedure
    @Admin
    @Procedure(value="apoc.custom.show", mode=Mode.READ)
    @Description(value="Provides a list of custom procedures/function registered")
    public Stream<CustomProcedureInfo> show(@Name(value="databaseName", defaultValue="neo4j") String databaseName) {
        SystemDbUtil.checkInSystemDb((GraphDatabaseService)this.db);
        return CypherHandlerNewProcedure.show(databaseName, this.tx);
    }
}

