/*
 * Decompiled with CFR 0.152.
 */
package apoc.custom;

import apoc.ApocConfig;
import apoc.ExtendedSystemLabels;
import apoc.ExtendedSystemPropertyKeys;
import apoc.SystemPropertyKeys;
import apoc.custom.CypherHandlerNewProcedure;
import apoc.custom.CypherProceduresUtil;
import apoc.util.Util;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;
import org.neo4j.collection.ResourceRawIterator;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.QueryExecutionException;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.procs.DefaultParameterValue;
import org.neo4j.internal.kernel.api.procs.FieldSignature;
import org.neo4j.internal.kernel.api.procs.Neo4jTypes;
import org.neo4j.internal.kernel.api.procs.ProcedureSignature;
import org.neo4j.internal.kernel.api.procs.QualifiedName;
import org.neo4j.internal.kernel.api.procs.UserFunctionSignature;
import org.neo4j.kernel.api.QueryLanguage;
import org.neo4j.kernel.api.ResourceMonitor;
import org.neo4j.kernel.api.procedure.CallableProcedure;
import org.neo4j.kernel.api.procedure.CallableUserFunction;
import org.neo4j.kernel.api.procedure.Context;
import org.neo4j.kernel.api.procedure.GlobalProcedures;
import org.neo4j.kernel.availability.AvailabilityListener;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.Log;
import org.neo4j.procedure.impl.ProcedureHolderUtils;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobHandle;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.values.AnyValue;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValueBuilder;
import org.neo4j.values.virtual.VirtualValues;

public class CypherProceduresHandler
extends LifecycleAdapter
implements AvailabilityListener {
    public static final String PREFIX = "custom";
    public static final String FUNCTION = "function";
    public static final String PROCEDURE = "procedure";
    public static final String CUSTOM_PROCEDURES_REFRESH = "apoc.custom.procedures.refresh";
    public static final List<FieldSignature> DEFAULT_INPUTS = Collections.singletonList(FieldSignature.inputField((String)"params", (Neo4jTypes.AnyType)Neo4jTypes.NTMap, (DefaultParameterValue)DefaultParameterValue.ntMap(Collections.emptyMap())));
    public static final List<FieldSignature> DEFAULT_MAP_OUTPUT = Collections.singletonList(FieldSignature.inputField((String)"row", (Neo4jTypes.AnyType)Neo4jTypes.NTMap));
    public static final String ERROR_INVALID_TYPE = "Invalid type name.\nCheck the documentation to see possible values: https://neo4j.com/labs/apoc/4.1/cypher-execution/cypher-based-procedures-functions/";
    private final GraphDatabaseAPI api;
    private final Log log;
    private final GraphDatabaseService systemDb;
    private final GlobalProcedures globalProceduresRegistry;
    private final JobScheduler jobScheduler;
    private long lastUpdate;
    private final Set<ProcedureSignature> registeredProcedureSignatures = Collections.synchronizedSet(new HashSet());
    private final Set<UserFunctionSignature> registeredUserFunctionSignatures = Collections.synchronizedSet(new HashSet());
    private static Group REFRESH_GROUP = Group.STORAGE_MAINTENANCE;
    private JobHandle restoreProceduresHandle;

    public CypherProceduresHandler(GraphDatabaseAPI db, JobScheduler jobScheduler, ApocConfig apocConfig, Log userLog, GlobalProcedures globalProceduresRegistry) {
        this.api = db;
        this.log = userLog;
        this.jobScheduler = jobScheduler;
        this.systemDb = apocConfig.getSystemDb();
        this.globalProceduresRegistry = globalProceduresRegistry;
    }

    public void available() {
        this.restoreProceduresAndFunctions();
        if (CypherProceduresUtil.isEnabled()) {
            long refreshInterval = ApocConfig.apocConfig().getInt(CUSTOM_PROCEDURES_REFRESH, 60000);
            this.restoreProceduresHandle = this.jobScheduler.scheduleRecurring(REFRESH_GROUP, () -> {
                if (this.getLastUpdate() > this.lastUpdate) {
                    this.restoreProceduresAndFunctions();
                }
            }, refreshInterval, refreshInterval, TimeUnit.MILLISECONDS);
        }
    }

    public void unavailable() {
        if (this.restoreProceduresHandle != null) {
            this.restoreProceduresHandle.cancel();
        }
    }

    public Stream<ProcedureOrFunctionDescriptor> readSignatures() {
        List descriptors;
        try (Transaction tx = this.systemDb.beginTx();){
            descriptors = tx.findNodes((Label)ExtendedSystemLabels.ApocCypherProcedures, SystemPropertyKeys.database.name(), (Object)this.api.databaseName()).stream().map(node -> {
                if (node.hasLabel((Label)ExtendedSystemLabels.Procedure)) {
                    return this.procedureDescriptor((Node)node);
                }
                if (node.hasLabel((Label)ExtendedSystemLabels.Function)) {
                    return this.userFunctionDescriptor((Node)node);
                }
                throw new IllegalStateException("don't know what to do with systemdb node " + String.valueOf(node));
            }).collect(Collectors.toList());
            tx.commit();
        }
        return descriptors.stream();
    }

    private ProcedureDescriptor procedureDescriptor(Node node) {
        String statement = (String)node.getProperty(SystemPropertyKeys.statement.name());
        ProcedureSignature procedureSignature = CypherProceduresUtil.getProcedureSignature(node);
        return new ProcedureDescriptor(procedureSignature, statement);
    }

    private UserFunctionDescriptor userFunctionDescriptor(Node node) {
        String statement = (String)node.getProperty(SystemPropertyKeys.statement.name());
        boolean forceSingle = (Boolean)node.getProperty(ExtendedSystemPropertyKeys.forceSingle.name(), (Object)false);
        boolean mapResult = (Boolean)node.getProperty(ExtendedSystemPropertyKeys.mapResult.name(), (Object)false);
        UserFunctionSignature signature = CypherProceduresUtil.getUserFunctionSignature(node);
        return new UserFunctionDescriptor(signature, statement, forceSingle, mapResult);
    }

    public synchronized void restoreProceduresAndFunctions() {
        this.lastUpdate = System.currentTimeMillis();
        HashSet<ProcedureSignature> currentProceduresToRemove = new HashSet<ProcedureSignature>(this.registeredProcedureSignatures);
        HashSet<UserFunctionSignature> currentUserFunctionsToRemove = new HashSet<UserFunctionSignature>(this.registeredUserFunctionSignatures);
        this.readSignatures().forEach(descriptor -> {
            descriptor.register();
            if (descriptor instanceof ProcedureDescriptor) {
                ProcedureSignature signature = ((ProcedureDescriptor)descriptor).getSignature();
                currentProceduresToRemove.remove(signature);
            } else {
                UserFunctionSignature signature = ((UserFunctionDescriptor)descriptor).getSignature();
                currentUserFunctionsToRemove.remove(signature);
            }
        });
        currentProceduresToRemove.forEach(signature -> this.registerProcedure((ProcedureSignature)signature, null));
        currentUserFunctionsToRemove.forEach(this::registerFunction);
        this.api.executeTransactionally("call db.clearQueryCaches()");
    }

    private <T> T withSystemDb(Function<Transaction, T> action) {
        try (Transaction tx = this.systemDb.beginTx();){
            T result = action.apply(tx);
            tx.commit();
            T t = result;
            return t;
        }
    }

    public synchronized void storeFunction(UserFunctionSignature signature, String statement, boolean forceSingle, boolean mapResult) {
        this.withSystemDb(tx -> {
            Node node = Util.mergeNode((Transaction)tx, (Label)ExtendedSystemLabels.ApocCypherProcedures, (Label)ExtendedSystemLabels.Function, (Pair[])new Pair[]{Pair.of((Object)SystemPropertyKeys.database.name(), (Object)this.api.databaseName()), Pair.of((Object)SystemPropertyKeys.name.name(), (Object)signature.name().name()), Pair.of((Object)ExtendedSystemPropertyKeys.prefix.name(), (Object)signature.name().namespace())});
            node.setProperty(ExtendedSystemPropertyKeys.description.name(), signature.description().orElse(null));
            node.setProperty(SystemPropertyKeys.statement.name(), (Object)statement);
            node.setProperty(ExtendedSystemPropertyKeys.inputs.name(), (Object)CypherHandlerNewProcedure.serializeSignatures(signature.inputSignature()));
            node.setProperty(ExtendedSystemPropertyKeys.output.name(), (Object)signature.outputType().toString());
            node.setProperty(ExtendedSystemPropertyKeys.forceSingle.name(), (Object)forceSingle);
            node.setProperty(ExtendedSystemPropertyKeys.mapResult.name(), (Object)mapResult);
            this.setLastUpdate((Transaction)tx);
            if (!this.registerFunction(signature, statement, forceSingle, mapResult)) {
                throw new IllegalStateException("Error registering function " + String.valueOf(signature) + ", see log.");
            }
            return null;
        });
    }

    public synchronized void storeProcedure(ProcedureSignature signature, String statement) {
        this.withSystemDb(tx -> {
            Node node = Util.mergeNode((Transaction)tx, (Label)ExtendedSystemLabels.ApocCypherProcedures, (Label)ExtendedSystemLabels.Procedure, (Pair[])new Pair[]{Pair.of((Object)SystemPropertyKeys.database.name(), (Object)this.api.databaseName()), Pair.of((Object)SystemPropertyKeys.name.name(), (Object)signature.name().name()), Pair.of((Object)ExtendedSystemPropertyKeys.prefix.name(), (Object)signature.name().namespace())});
            node.setProperty(ExtendedSystemPropertyKeys.description.name(), signature.description().orElse(null));
            node.setProperty(SystemPropertyKeys.statement.name(), (Object)statement);
            node.setProperty(ExtendedSystemPropertyKeys.inputs.name(), (Object)CypherHandlerNewProcedure.serializeSignatures(signature.inputSignature()));
            node.setProperty(ExtendedSystemPropertyKeys.outputs.name(), (Object)CypherHandlerNewProcedure.serializeSignatures(signature.outputSignature()));
            node.setProperty(ExtendedSystemPropertyKeys.mode.name(), (Object)signature.mode().name());
            this.setLastUpdate((Transaction)tx);
            if (!this.registerProcedure(signature, statement)) {
                throw new IllegalStateException("Error registering procedure " + String.valueOf(signature.name()) + ", see log.");
            }
            return null;
        });
    }

    private void setLastUpdate(Transaction tx) {
        Node node = tx.findNode((Label)ExtendedSystemLabels.ApocCypherProceduresMeta, SystemPropertyKeys.database.name(), (Object)this.api.databaseName());
        if (node == null) {
            node = tx.createNode(new Label[]{ExtendedSystemLabels.ApocCypherProceduresMeta});
            node.setProperty(SystemPropertyKeys.database.name(), (Object)this.api.databaseName());
        }
        node.setProperty(SystemPropertyKeys.lastUpdated.name(), (Object)System.currentTimeMillis());
    }

    private long getLastUpdate() {
        return this.withSystemDb(tx -> {
            Node node = tx.findNode((Label)ExtendedSystemLabels.ApocCypherProceduresMeta, SystemPropertyKeys.database.name(), (Object)this.api.databaseName());
            return node == null ? 0L : (Long)node.getProperty(SystemPropertyKeys.lastUpdated.name());
        });
    }

    public boolean registerProcedure(final ProcedureSignature signature, final String statement) {
        final QualifiedName name = signature.name();
        try {
            boolean exists = this.globalProceduresRegistry.getCurrentView().getAllProcedures(QueryLanguage.CYPHER_5).anyMatch(s -> s.name().equals((Object)name));
            if (exists) {
                ProcedureHolderUtils.unregisterProcedure(name, this.globalProceduresRegistry);
                this.registeredProcedureSignatures.removeIf(i -> i.name().equals((Object)signature.name()));
            }
            final boolean isStatementNull = statement == null;
            this.globalProceduresRegistry.register((CallableProcedure)new CallableProcedure.BasicProcedure(signature){

                public ResourceRawIterator<AnyValue[], ProcedureException> apply(Context ctx, AnyValue[] input, ResourceMonitor resourceMonitor) throws ProcedureException {
                    if (isStatementNull || CypherProceduresHandler.this.isNotRegisteredInTheCorrectDb(ctx)) {
                        String error = String.format("There is no procedure with the name `%s` registered for this database instance. Please ensure you've spelled the procedure name correctly and that the procedure is properly deployed.", name);
                        throw new QueryExecutionException(error, null, "Neo.ClientError.Statement.SyntaxError");
                    }
                    Map<String, Object> params = CypherProceduresHandler.this.params(input, signature.inputSignature(), ctx.valueMapper());
                    Transaction tx = ctx.transaction();
                    Result result = tx.execute(statement, params);
                    resourceMonitor.registerCloseableResource((AutoCloseable)result);
                    List outputs = signature.outputSignature();
                    String[] names = outputs == null ? null : (String[])outputs.stream().map(FieldSignature::name).toArray(String[]::new);
                    boolean defaultOutputs = outputs == null || outputs.equals(DEFAULT_MAP_OUTPUT);
                    Stream<AnyValue[]> stream = result.stream().map(row -> CypherProceduresHandler.this.toResult((Map<String, Object>)row, names, defaultOutputs));
                    return Iterators.asRawIterator(stream);
                }
            });
            if (isStatementNull) {
                this.registeredProcedureSignatures.remove(signature);
            } else {
                this.registeredProcedureSignatures.add(signature);
            }
            return true;
        }
        catch (Exception e) {
            this.log.error("Could not register procedure: " + String.valueOf(name) + " with " + statement + "\n accepting" + String.valueOf(signature.inputSignature()) + " resulting in " + String.valueOf(signature.outputSignature()) + " mode " + String.valueOf(signature.mode()), (Throwable)e);
            return false;
        }
    }

    public boolean registerFunction(UserFunctionSignature signature) {
        return this.registerFunction(signature, null, false, false);
    }

    public boolean registerFunction(final UserFunctionSignature signature, final String statement, final boolean forceSingle, final boolean mapResult) {
        try {
            final QualifiedName name = signature.name();
            boolean exists = this.globalProceduresRegistry.getCurrentView().getAllNonAggregatingFunctions(QueryLanguage.CYPHER_5).anyMatch(s -> s.name().equals((Object)name));
            if (exists) {
                ProcedureHolderUtils.unregisterFunction(name, this.globalProceduresRegistry);
                this.registeredUserFunctionSignatures.removeIf(i -> i.name().equals((Object)signature.name()));
            }
            final boolean isStatementNull = statement == null;
            this.globalProceduresRegistry.register((CallableUserFunction)new CallableUserFunction.BasicUserFunction(signature){

                public AnyValue apply(Context ctx, AnyValue[] input) throws ProcedureException {
                    if (isStatementNull || CypherProceduresHandler.this.isNotRegisteredInTheCorrectDb(ctx)) {
                        String error = String.format("Unknown function '%s'", name);
                        throw new QueryExecutionException(error, null, "Neo.ClientError.Statement.SyntaxError");
                    }
                    Map<String, Object> params = CypherProceduresHandler.this.params(input, signature.inputSignature(), ctx.valueMapper());
                    Neo4jTypes.AnyType outType = signature.outputType();
                    Transaction tx = ctx.transaction();
                    try (Result result = tx.execute(statement, params);){
                        if (!result.hasNext()) {
                            Value value = Values.NO_VALUE;
                            return value;
                        }
                        if (outType.equals(Neo4jTypes.NTAny)) {
                            AnyValue anyValue = ValueUtils.of(result.stream().collect(Collectors.toList()));
                            return anyValue;
                        }
                        List cols = result.columns();
                        if (cols.isEmpty()) {
                            AnyValue anyValue = null;
                            return anyValue;
                        }
                        if (!forceSingle && outType instanceof Neo4jTypes.ListType) {
                            Neo4jTypes.ListType listType = (Neo4jTypes.ListType)outType;
                            Neo4jTypes.AnyType innerType = listType.innerType();
                            if (CypherProceduresHandler.this.isWrapped(innerType, mapResult)) {
                                AnyValue anyValue = ValueUtils.of(result.stream().collect(Collectors.toList()));
                                return anyValue;
                            }
                            if (cols.size() == 1) {
                                AnyValue anyValue = ValueUtils.of(result.stream().map(row -> row.get(cols.get(0))).collect(Collectors.toList()));
                                return anyValue;
                            }
                        } else {
                            Map row2 = result.next();
                            if (CypherProceduresHandler.this.isWrapped(outType, mapResult)) {
                                AnyValue anyValue = ValueUtils.of((Object)row2);
                                return anyValue;
                            }
                            if (cols.size() == 1) {
                                AnyValue anyValue = ValueUtils.of(row2.get(cols.get(0)));
                                return anyValue;
                            }
                        }
                        throw new IllegalStateException("Result mismatch " + String.valueOf(cols) + " output type is " + String.valueOf(outType));
                    }
                }
            });
            if (isStatementNull) {
                this.registeredUserFunctionSignatures.remove(signature);
            } else {
                this.registeredUserFunctionSignatures.add(signature);
            }
            return true;
        }
        catch (Exception e) {
            this.log.error("Could not register function: " + String.valueOf(signature) + "\nwith: " + statement + "\n single result " + forceSingle, (Throwable)e);
            return false;
        }
    }

    private boolean isNotRegisteredInTheCorrectDb(Context ctx) {
        return !ctx.graphDatabaseAPI().databaseName().equals(this.api.databaseName());
    }

    private boolean isWrapped(Neo4jTypes.AnyType outType, boolean mapResult) {
        return !mapResult && outType.getClass().equals(Neo4jTypes.MapType.class);
    }

    private AnyValue[] toResult(Map<String, Object> row, String[] names, boolean defaultOutputs) {
        if (defaultOutputs) {
            return new AnyValue[]{this.convertToValueRecursive(row)};
        }
        AnyValue[] result = new AnyValue[names.length];
        for (int i = 0; i < names.length; ++i) {
            result[i] = this.convertToValueRecursive(row.get(names[i]));
        }
        return result;
    }

    private AnyValue convertToValueRecursive(Object ... toConverts) {
        switch (toConverts.length) {
            case 0: {
                return Values.NO_VALUE;
            }
            case 1: {
                Object toConvert = toConverts[0];
                if (toConvert instanceof List) {
                    List list = (List)toConvert;
                    AnyValue[] objects = (AnyValue[])list.stream().map(x -> this.convertToValueRecursive(x)).toArray(AnyValue[]::new);
                    return VirtualValues.list((AnyValue[])objects);
                }
                if (toConvert instanceof Map) {
                    Map map = (Map)toConvert;
                    MapValueBuilder builder = new MapValueBuilder();
                    map.entrySet().stream().forEach(e -> builder.add((String)e.getKey(), this.convertToValueRecursive(e.getValue())));
                    return builder.build();
                }
                if (toConvert instanceof Entity || toConvert instanceof Path) {
                    return ValueUtils.asAnyValue((Object)toConvert);
                }
                return Values.of((Object)toConvert);
            }
        }
        AnyValue[] values = (AnyValue[])Arrays.stream(toConverts).map(c -> this.convertToValueRecursive(c)).toArray(AnyValue[]::new);
        return VirtualValues.list((AnyValue[])values);
    }

    public Map<String, Object> params(AnyValue[] input, List<FieldSignature> fieldSignatures, ValueMapper valueMapper) {
        if (input == null || input.length == 0) {
            return Collections.emptyMap();
        }
        if (fieldSignatures == null || fieldSignatures.isEmpty() || fieldSignatures.equals(DEFAULT_INPUTS)) {
            return (Map)input[0].map(valueMapper);
        }
        HashMap<String, Object> params = new HashMap<String, Object>(input.length);
        for (int i = 0; i < input.length; ++i) {
            params.put(fieldSignatures.get(i).name(), input[i].map(valueMapper));
        }
        return params;
    }

    public void removeProcedure(String name) {
        this.withSystemDb(tx -> {
            QualifiedName qName = CypherProceduresUtil.qualifiedName(name);
            tx.findNodes((Label)ExtendedSystemLabels.ApocCypherProcedures, SystemPropertyKeys.database.name(), (Object)this.api.databaseName(), SystemPropertyKeys.name.name(), (Object)qName.name(), ExtendedSystemPropertyKeys.prefix.name(), (Object)qName.namespace()).stream().filter(n -> n.hasLabel((Label)ExtendedSystemLabels.Procedure)).forEach(node -> {
                ProcedureDescriptor descriptor = this.procedureDescriptor((Node)node);
                this.registerProcedure(descriptor.getSignature(), null);
                node.delete();
                this.setLastUpdate((Transaction)tx);
            });
            return null;
        });
    }

    public void removeFunction(String name) {
        this.withSystemDb(tx -> {
            QualifiedName qName = CypherProceduresUtil.qualifiedName(name);
            tx.findNodes((Label)ExtendedSystemLabels.ApocCypherProcedures, SystemPropertyKeys.database.name(), (Object)this.api.databaseName(), SystemPropertyKeys.name.name(), (Object)qName.name(), ExtendedSystemPropertyKeys.prefix.name(), (Object)qName.namespace()).stream().filter(n -> n.hasLabel((Label)ExtendedSystemLabels.Function)).forEach(node -> {
                UserFunctionDescriptor descriptor = this.userFunctionDescriptor((Node)node);
                this.registerFunction(descriptor.getSignature());
                node.delete();
                this.setLastUpdate((Transaction)tx);
            });
            return null;
        });
    }

    public class ProcedureDescriptor
    extends ProcedureOrFunctionDescriptor {
        private final ProcedureSignature signature;

        public ProcedureDescriptor(ProcedureSignature signature, String statement) {
            super(CypherProceduresHandler.this, statement);
            this.signature = signature;
        }

        public ProcedureSignature getSignature() {
            return this.signature;
        }

        @Override
        public void register() {
            CypherProceduresHandler.this.registerProcedure(this.getSignature(), this.getStatement());
        }
    }

    public class UserFunctionDescriptor
    extends ProcedureOrFunctionDescriptor {
        private final UserFunctionSignature signature;
        private final boolean forceSingle;
        private final boolean mapResult;

        public UserFunctionDescriptor(UserFunctionSignature signature, String statement, boolean forceSingle, boolean mapResult) {
            super(CypherProceduresHandler.this, statement);
            this.signature = signature;
            this.forceSingle = forceSingle;
            this.mapResult = mapResult;
        }

        public UserFunctionSignature getSignature() {
            return this.signature;
        }

        public boolean isForceSingle() {
            return this.forceSingle;
        }

        @Override
        public void register() {
            CypherProceduresHandler.this.registerFunction(this.getSignature(), this.getStatement(), this.isForceSingle(), this.mapResult);
        }
    }

    public abstract class ProcedureOrFunctionDescriptor {
        private final String statement;

        protected ProcedureOrFunctionDescriptor(CypherProceduresHandler this$0, String statement) {
            this.statement = statement;
        }

        public String getStatement() {
            return this.statement;
        }

        public abstract void register();
    }
}

