/*
 * Decompiled with CFR 0.152.
 */
package apoc.cypher;

import apoc.Extended;
import apoc.Pools;
import apoc.cypher.CypherUtils;
import apoc.result.CypherStatementMapResult;
import apoc.result.MapResult;
import apoc.util.CompressionAlgo;
import apoc.util.EntityUtil;
import apoc.util.FileUtils;
import apoc.util.MapUtil;
import apoc.util.QueueBasedSpliterator;
import apoc.util.QueueUtil;
import apoc.util.Util;
import apoc.util.collection.Iterators;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.QueryExecutionType;
import org.neo4j.graphdb.QueryStatistics;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.security.URLAccessChecker;
import org.neo4j.internal.kernel.api.procs.ProcedureCallContext;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;
import org.neo4j.procedure.TerminationGuard;

@Extended
public class CypherExtended {
    public static final String COMPILED_PREFIX = "CYPHER runtime=interpreted";
    public static final int PARTITIONS = 100 * Runtime.getRuntime().availableProcessors();
    public static final int MAX_BATCH = 10000;
    @Context
    public Transaction tx;
    @Context
    public GraphDatabaseService db;
    @Context
    public Log log;
    @Context
    public TerminationGuard terminationGuard;
    @Context
    public Pools pools;
    @Context
    public URLAccessChecker urlAccessChecker;
    @Context
    public ProcedureCallContext procedureCallContext;
    private static final Pattern shellControl = Pattern.compile("^:?\\b(begin|commit|rollback)\\b", 2);

    @Procedure(name="apoc.cypher.runFile", mode=Mode.WRITE)
    @Description(value="apoc.cypher.runFile(file or url,[{statistics:true,timeout:10,parameters:{}}]) - runs each statement in the file, all semicolon separated - currently no schema operations")
    public Stream<RowResult> runFile(@Name(value="file") String fileName, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        return this.runFiles(Collections.singletonList(fileName), config);
    }

    @Procedure(value="apoc.cypher.runFileReadOnly", mode=Mode.READ)
    @Description(value="apoc.cypher.runFileReadOnly(file or url,[{statistics:true,timeout:10,parameters:{}}]) - runs each `READ` statement in the file, all semicolon separated")
    public Stream<RowResult> runReadFile(@Name(value="file") String fileName, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        return this.runReadFiles(Collections.singletonList(fileName), config);
    }

    @Procedure(value="apoc.cypher.runFiles", mode=Mode.WRITE)
    @Description(value="apoc.cypher.runFiles([files or urls],[{statistics:true,timeout:10,parameters:{}}])) - runs each statement in the files, all semicolon separated")
    public Stream<RowResult> runFiles(@Name(value="file") List<String> fileNames, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        return this.runNonSchemaFiles(fileNames, config, true);
    }

    @Procedure(value="apoc.cypher.runFilesReadOnly", mode=Mode.READ)
    @Description(value="apoc.cypher.runFilesReadOnly([files or urls],[{statistics:true,timeout:10,parameters:{}}])) - runs each `READ` statement in the files, all semicolon separated")
    public Stream<RowResult> runReadFiles(@Name(value="file") List<String> fileNames, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        return this.runNonSchemaFiles(fileNames, config, false);
    }

    private Stream<RowResult> runNonSchemaFiles(List<String> fileNames, Map<String, Object> config, boolean defaultStatistics) {
        Map<String, Object> parameters = config.getOrDefault("parameters", Collections.emptyMap());
        boolean schemaOperation = false;
        return this.runFiles(fileNames, config, parameters, false, defaultStatistics);
    }

    private Stream<RowResult> runFiles(List<String> fileNames, Map<String, Object> config, Map<String, Object> parameters, boolean schemaOperation, boolean defaultStatistics) {
        boolean reportError = Util.toBoolean((Object)config.get("reportError"));
        boolean addStatistics = Util.toBoolean((Object)config.getOrDefault("statistics", defaultStatistics));
        int timeout = Util.toInteger((Object)config.getOrDefault("timeout", 10));
        int queueCapacity = Util.toInteger((Object)config.getOrDefault("queueCapacity", 100));
        Stream<RowResult> result = fileNames.stream().flatMap(fileName -> {
            Reader reader = this.readerForFile((String)fileName);
            Scanner scanner = this.createScannerFor(reader);
            return (Stream)this.runManyStatements(scanner, parameters, schemaOperation, addStatistics, timeout, queueCapacity, reportError, (String)fileName).onClose(() -> Util.close((AutoCloseable)scanner, e -> this.log.info("Cannot close the scanner for file " + fileName + " because the following exception", (Throwable)e)));
        });
        return result;
    }

    @Procedure(mode=Mode.SCHEMA)
    @Description(value="apoc.cypher.runSchemaFile(file or url,[{statistics:true,timeout:10}]) - allows only schema operations, runs each schema statement in the file, all semicolon separated")
    public Stream<RowResult> runSchemaFile(@Name(value="file") String fileName, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        return this.runSchemaFiles(Collections.singletonList(fileName), config);
    }

    @Procedure(mode=Mode.SCHEMA)
    @Description(value="apoc.cypher.runSchemaFiles([files or urls],{statistics:true,timeout:10}) - allows only schema operations, runs each schema statement in the files, all semicolon separated")
    public Stream<RowResult> runSchemaFiles(@Name(value="file") List<String> fileNames, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        boolean schemaOperation = true;
        Map<String, Object> parameters = Collections.emptyMap();
        return this.runFiles(fileNames, config, parameters, true, true);
    }

    private Stream<RowResult> runManyStatements(Scanner scanner, Map<String, Object> params, boolean schemaOperation, boolean addStatistics, int timeout, int queueCapacity, boolean reportError, String fileName) {
        BlockingQueue<RowResult> queue = this.runInSeparateThreadAndSendTombstone(queueCapacity, internalQueue -> {
            if (schemaOperation) {
                this.runSchemaStatementsInTx(scanner, (BlockingQueue<RowResult>)internalQueue, params, addStatistics, timeout, reportError, fileName);
            } else {
                this.runDataStatementsInTx(scanner, (BlockingQueue<RowResult>)internalQueue, params, addStatistics, timeout, reportError, fileName);
            }
        }, RowResult.TOMBSTONE);
        return StreamSupport.stream(new QueueBasedSpliterator(queue, (Object)RowResult.TOMBSTONE, this.terminationGuard, Integer.MAX_VALUE), false);
    }

    private <T> BlockingQueue<T> runInSeparateThreadAndSendTombstone(int queueCapacity, Consumer<BlockingQueue<T>> action, T tombstone) {
        ArrayBlockingQueue queue = new ArrayBlockingQueue(queueCapacity);
        Util.newDaemonThread(() -> {
            try {
                action.accept(queue);
            }
            finally {
                while (true) {
                    try {
                        queue.put(tombstone);
                        return;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        continue;
                    }
                    break;
                }
            }
        }).start();
        return queue;
    }

    private void runDataStatementsInTx(Scanner scanner, BlockingQueue<RowResult> queue, Map<String, Object> params, boolean addStatistics, long timeout, boolean reportError, String fileName) {
        while (scanner.hasNext()) {
            boolean schemaOperation;
            String stmt = this.removeShellControlCommands(scanner.next());
            if (CypherExtended.isCommentOrEmpty(stmt)) continue;
            try {
                schemaOperation = this.isSchemaOperation(stmt);
            }
            catch (Exception e) {
                this.collectError(queue, reportError, e, fileName);
                return;
            }
            if (schemaOperation) continue;
            if (this.isPeriodicOperation(stmt)) {
                Util.inThread((Pools)this.pools, () -> {
                    try {
                        return this.db.executeTransactionally(stmt, params, result -> this.consumeResult((Result)result, queue, addStatistics, this.tx, fileName));
                    }
                    catch (Exception e) {
                        this.collectError(queue, reportError, e, fileName);
                        return null;
                    }
                });
                continue;
            }
            AtomicBoolean isSchemaError = new AtomicBoolean(false);
            try {
                Util.inTx((GraphDatabaseService)this.db, (Pools)this.pools, threadTx -> {
                    Object object;
                    block9: {
                        Result result = threadTx.execute(stmt, params);
                        try {
                            object = this.consumeResult(result, queue, addStatistics, this.tx, fileName);
                            if (result == null) break block9;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (result != null) {
                                    try {
                                        result.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (Exception e) {
                                if (!e.getMessage().contains("Schema operations on database") || !e.getMessage().contains("are not allowed")) {
                                    this.collectError(queue, reportError, e, fileName);
                                    return null;
                                }
                                isSchemaError.set(true);
                                return null;
                            }
                        }
                        result.close();
                    }
                    return object;
                });
            }
            catch (Exception e) {
                if (isSchemaError.get()) continue;
                throw e;
            }
        }
    }

    private void collectError(BlockingQueue<RowResult> queue, boolean reportError, Exception e, String fileName) {
        if (!reportError) {
            throw new RuntimeException(e);
        }
        String error = e.getMessage();
        RowResult result = new RowResult(-1L, Map.of("error", error), fileName);
        QueueUtil.put(queue, (Object)result, (long)10L);
    }

    private Scanner createScannerFor(Reader reader) {
        Scanner scanner = new Scanner(reader);
        scanner.useDelimiter("; *\r?\n");
        return scanner;
    }

    private void runSchemaStatementsInTx(Scanner scanner, BlockingQueue<RowResult> queue, Map<String, Object> params, boolean addStatistics, long timeout, boolean reportError, String fileName) {
        while (scanner.hasNext()) {
            boolean schemaOperation;
            String stmt = this.removeShellControlCommands(scanner.next());
            if (CypherExtended.isCommentOrEmpty(stmt)) continue;
            try {
                schemaOperation = this.isSchemaOperation(stmt);
            }
            catch (Exception e) {
                this.collectError(queue, reportError, e, fileName);
                return;
            }
            if (!schemaOperation) continue;
            Util.inTx((GraphDatabaseService)this.db, (Pools)this.pools, txInThread -> {
                Object object;
                block8: {
                    Result result = txInThread.execute(stmt, params);
                    try {
                        object = this.consumeResult(result, queue, addStatistics, this.tx, fileName);
                        if (result == null) break block8;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (result != null) {
                                try {
                                    result.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            this.collectError(queue, reportError, e, fileName);
                            return null;
                        }
                    }
                    result.close();
                }
                return object;
            });
        }
    }

    private static boolean isCommentOrEmpty(String stmt) {
        String trimStatement = stmt.trim();
        return trimStatement.isEmpty() || trimStatement.startsWith("//");
    }

    private Object consumeResult(Result result, BlockingQueue<RowResult> queue, boolean addStatistics, Transaction transaction, String fileName) {
        try {
            long time = System.currentTimeMillis();
            int row = 0;
            AtomicBoolean closed = new AtomicBoolean(false);
            while (CypherExtended.isOpenAndHasNext(result, closed)) {
                this.terminationGuard.check();
                Map res = (Map)EntityUtil.anyRebind((Transaction)transaction, (Object)result.next());
                queue.put(new RowResult(row++, res, fileName));
            }
            if (addStatistics) {
                Map<String, Object> mapResult = this.toMap(result.getQueryStatistics(), System.currentTimeMillis() - time, row);
                queue.put(new RowResult(-1L, mapResult, fileName));
            }
            if (closed.get()) {
                queue.put(RowResult.TOMBSTONE);
                return null;
            }
            return row;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean isOpenAndHasNext(Result result, AtomicBoolean closed) {
        try {
            return result.hasNext();
        }
        catch (Exception e) {
            closed.set(true);
            return false;
        }
    }

    private String removeShellControlCommands(String stmt) {
        Matcher matcher = shellControl.matcher(stmt.trim());
        if (matcher.find()) {
            return this.removeShellControlCommands(matcher.replaceAll(""));
        }
        return stmt;
    }

    private boolean isSchemaOperation(String statement) {
        return (Boolean)this.db.executeTransactionally("EXPLAIN " + statement, Collections.emptyMap(), res -> QueryExecutionType.QueryType.SCHEMA_WRITE.equals((Object)res.getQueryExecutionType().queryType()));
    }

    private boolean isPeriodicOperation(String stmt) {
        return stmt.matches("(?is).*using\\s+periodic.*") || stmt.matches("(?is).*in\\s+transactions.*");
    }

    private Map<String, Object> toMap(QueryStatistics stats, long time, long rows) {
        return MapUtil.map((Object[])new Object[]{"rows", rows, "time", time, "nodesCreated", stats.getNodesCreated(), "nodesDeleted", stats.getNodesDeleted(), "labelsAdded", stats.getLabelsAdded(), "labelsRemoved", stats.getLabelsRemoved(), "relationshipsCreated", stats.getRelationshipsCreated(), "relationshipsDeleted", stats.getRelationshipsDeleted(), "propertiesSet", stats.getPropertiesSet(), "constraintsAdded", stats.getConstraintsAdded(), "constraintsRemoved", stats.getConstraintsRemoved(), "indexesAdded", stats.getIndexesAdded(), "indexesRemoved", stats.getIndexesRemoved()});
    }

    private Reader readerForFile(@Name(value="file") String fileName) {
        try {
            return FileUtils.readerFor((Object)fileName, (String)CompressionAlgo.NONE.name(), (URLAccessChecker)this.urlAccessChecker);
        }
        catch (Exception e) {
            throw new RuntimeException("Error accessing file " + fileName, e);
        }
    }

    public static String withParamMapping(String fragment, Collection<String> keys) {
        if (keys.isEmpty()) {
            return fragment;
        }
        String declaration = " WITH " + String.join((CharSequence)", ", keys.stream().map(s -> String.format(" $`%s` as `%s` ", s, s)).collect(Collectors.toList()));
        return declaration + fragment;
    }

    public static String compiled(String fragment) {
        return fragment.substring(0, 6).equalsIgnoreCase("cypher") ? fragment : COMPILED_PREFIX + fragment;
    }

    @Procedure
    @Description(value="apoc.cypher.parallel(fragment, `paramMap`, `keyList`) yield value - executes fragments in parallel through a list defined in `paramMap` with a key `keyList`")
    public Stream<CypherStatementMapResult> parallel(@Name(value="fragment") String fragment, @Name(value="params") Map<String, Object> params, @Name(value="parallelizeOn") String key) {
        if (params == null) {
            return CypherUtils.runCypherQuery((Transaction)this.tx, (String)fragment, params, (ProcedureCallContext)this.procedureCallContext);
        }
        if (key == null || !params.containsKey(key)) {
            throw new RuntimeException("Can't parallelize on key " + key + " available keys " + String.valueOf(params.keySet()));
        }
        Object value = params.get(key);
        if (!(value instanceof Collection)) {
            throw new RuntimeException("Can't parallelize a non collection " + key + " : " + String.valueOf(value));
        }
        String statement = CypherExtended.withParamMapping(fragment, params.keySet());
        Collection coll = (Collection)value;
        return coll.parallelStream().flatMap(v -> {
            this.terminationGuard.check();
            HashMap<String, Object> parallelParams = new HashMap<String, Object>(params);
            parallelParams.replace(key, v);
            return this.tx.execute(statement, parallelParams).stream().map(CypherStatementMapResult::new);
        });
    }

    @Deprecated
    @Procedure(deprecatedBy="Cypher subqueries like: `CYPHER runtime=parallel CALL {...} ... ` or `CALL {...} IN CONCURRENT TRANSACTIONS ... `")
    @Description(value="apoc.cypher.mapParallel(fragment, params, list-to-parallelize) yield value - executes fragment in parallel batches with the list segments being assigned to _")
    public Stream<MapResult> mapParallel(@Name(value="fragment") String fragment, @Name(value="params") Map<String, Object> params, @Name(value="list") List<Object> data2) {
        String statement = CypherExtended.withParamsAndIterator(fragment, params.keySet(), "_");
        this.tx.execute("EXPLAIN " + statement).close();
        return Util.partitionSubList(data2, (int)PARTITIONS, null).flatMap(partition -> Iterators.asList((Iterator)this.tx.execute(statement, this.parallelParams(params, "_", (List<Object>)partition))).stream()).map(MapResult::new);
    }

    @Deprecated
    @Procedure(deprecatedBy="Cypher subqueries like: `CYPHER runtime=parallel CALL {...} ... ` or `CALL {...} IN CONCURRENT TRANSACTIONS ... `")
    @Description(value="apoc.cypher.mapParallel2(fragment, params, list-to-parallelize) yield value - executes fragment in parallel batches with the list segments being assigned to _")
    public Stream<MapResult> mapParallel2(@Name(value="fragment") String fragment, @Name(value="params") Map<String, Object> params, @Name(value="list") List<Object> data2, @Name(value="partitions") long partitions, @Name(value="timeout", defaultValue="10") long timeout) {
        String statement = CypherExtended.withParamsAndIterator(fragment, params.keySet(), "_");
        this.tx.execute("EXPLAIN " + statement).close();
        int queueCapacity = 100000;
        ArrayBlockingQueue queue = new ArrayBlockingQueue(queueCapacity);
        ArrayBlockingQueue transactions = new ArrayBlockingQueue(queueCapacity);
        ArrayBlockingQueue results = new ArrayBlockingQueue(queueCapacity);
        Stream parallelPartitions = Util.partitionSubList(data2, (int)((int)(partitions <= 0L ? (long)PARTITIONS : partitions)), null);
        Util.inFuture((Pools)this.pools, () -> {
            long total = parallelPartitions.map(partition -> {
                Transaction transaction = this.db.beginTx();
                transactions.add(transaction);
                Result result = transaction.execute(statement, this.parallelParams(params, "_", (List<Object>)partition));
                results.add(result);
                try {
                    return this.consumeResult(result, queue, false, transaction, null);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }).count();
            queue.put(RowResult.TOMBSTONE);
            return total;
        });
        return (Stream)StreamSupport.stream(new QueueBasedSpliterator(queue, (Object)RowResult.TOMBSTONE, this.terminationGuard, (int)timeout), true).map(rowResult -> new MapResult(rowResult.result)).onClose(() -> {
            transactions.forEach(i -> Util.close((AutoCloseable)i));
            results.forEach(i -> Util.close((AutoCloseable)i));
        });
    }

    public Map<String, Object> parallelParams(@Name(value="params") Map<String, Object> params, String key, List<Object> partition) {
        if (params.isEmpty()) {
            return Collections.singletonMap(key, partition);
        }
        HashMap<String, Object> parallelParams = new HashMap<String, Object>(params);
        parallelParams.put(key, partition);
        return parallelParams;
    }

    @Procedure
    @Description(value="apoc.cypher.parallel2(fragment, `paramMap`, `keyList`) yield value - executes fragments in parallel batches through a list defined in `paramMap` with a key `keyList`")
    public Stream<CypherStatementMapResult> parallel2(@Name(value="fragment") String fragment, @Name(value="params") Map<String, Object> params, @Name(value="parallelizeOn") String key) {
        if (params == null) {
            return CypherUtils.runCypherQuery((Transaction)this.tx, (String)fragment, params, (ProcedureCallContext)this.procedureCallContext);
        }
        if (StringUtils.isEmpty((CharSequence)key) || !params.containsKey(key)) {
            throw new RuntimeException("Can't parallelize on key " + key + " available keys " + String.valueOf(params.keySet()) + ". Note that parallelizeOn parameter must be not empty");
        }
        Object value = params.get(key);
        if (!(value instanceof Collection)) {
            throw new RuntimeException("Can't parallelize a non collection " + key + " : " + String.valueOf(value));
        }
        String statement = CypherExtended.withParamsAndIterator(fragment, params.keySet(), key);
        this.tx.execute("EXPLAIN " + statement).close();
        Collection coll = (Collection)value;
        int total = coll.size();
        int partitions = PARTITIONS;
        int batchSize = Math.max(total / partitions, 1);
        if (batchSize > 10000) {
            batchSize = 10000;
            partitions = total / batchSize + 1;
        }
        ArrayList<Future<List<Map<String, Object>>>> futures = new ArrayList<Future<List<Map<String, Object>>>>(partitions);
        ArrayList<Object> partition = new ArrayList<Object>(batchSize);
        for (Object o : coll) {
            partition.add(o);
            if (partition.size() != batchSize) continue;
            futures.add(this.submit(this.db, statement, params, key, partition, this.terminationGuard));
            partition = new ArrayList(batchSize);
        }
        if (!partition.isEmpty()) {
            futures.add(this.submit(this.db, statement, params, key, partition, this.terminationGuard));
        }
        return futures.stream().flatMap(f -> {
            try {
                return ((List)EntityUtil.anyRebind((Transaction)this.tx, (Object)((List)f.get()))).stream().map(CypherStatementMapResult::new);
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException("Error executing in parallel " + statement, e);
            }
        });
    }

    public static String withParamsAndIterator(String fragment, Collection<String> params, String iterator) {
        String with = Util.withMapping(params.stream().filter(c -> !c.equals(iterator)), c -> Util.param((String)c) + " AS " + Util.quote((String)c));
        return with + " UNWIND " + Util.param((String)iterator) + " AS " + Util.quote((String)iterator) + " " + fragment;
    }

    private Future<List<Map<String, Object>>> submit(GraphDatabaseService db, String statement, Map<String, Object> params, String key, List<Object> partition, TerminationGuard terminationGuard) {
        return this.pools.getDefaultExecutorService().submit(() -> {
            terminationGuard.check();
            return (List)db.executeTransactionally(statement, this.parallelParams(params, key, partition), result -> Iterators.asList((Iterator)result));
        });
    }

    public static class RowResult {
        public static final RowResult TOMBSTONE = new RowResult(-1L, null, null);
        public long row;
        public Map<String, Object> result;
        public String fileName;

        public RowResult(long row, Map<String, Object> result, String fileName) {
            this.row = row;
            this.result = result;
            this.fileName = fileName;
        }
    }
}

