/*
 * Decompiled with CFR 0.152.
 */
package apoc.diff;

import apoc.Extended;
import apoc.util.Util;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Transaction;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.UserFunction;

@Extended
public class DiffExtended {
    @Context
    public Transaction tx;

    @UserFunction(value="apoc.diff.relationships")
    @Description(value="Returns a Map detailing the property differences between the two given relationships")
    public Map<String, Object> relationships(@Name(value="leftRel") Relationship leftRel, @Name(value="rightRel") Relationship rightRel) {
        leftRel = Util.rebind((Transaction)this.tx, (Relationship)leftRel);
        rightRel = Util.rebind((Transaction)this.tx, (Relationship)rightRel);
        Map allLeftProperties = leftRel.getAllProperties();
        Map allRightProperties = rightRel.getAllProperties();
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("leftOnly", this.getPropertiesOnlyLeft(allLeftProperties, allRightProperties));
        result.put("rightOnly", this.getPropertiesOnlyLeft(allRightProperties, allLeftProperties));
        result.put("inCommon", this.getPropertiesInCommon(allLeftProperties, allRightProperties));
        result.put("different", this.getPropertiesDiffering(allLeftProperties, allRightProperties));
        return result;
    }

    private Map<String, Object> getPropertiesOnlyLeft(Map<String, Object> left, Map<String, Object> right) {
        HashMap<String, Object> leftOnly = new HashMap<String, Object>(left);
        leftOnly.keySet().removeAll(right.keySet());
        return leftOnly;
    }

    private Map<String, Object> getPropertiesInCommon(Map<String, Object> left, Map<String, Object> right) {
        return left.entrySet().stream().filter(entry -> Objects.deepEquals(entry.getValue(), right.get(entry.getKey()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Map<String, Map<String, Object>> getPropertiesDiffering(Map<String, Object> left, Map<String, Object> right) {
        HashMap<String, Map<String, Object>> different = new HashMap<String, Map<String, Object>>();
        HashMap<String, Object> keyPairs = new HashMap<String, Object>(left);
        keyPairs.keySet().retainAll(right.keySet());
        for (Map.Entry entry : keyPairs.entrySet()) {
            if (Objects.deepEquals(left.get(entry.getKey()), right.get(entry.getKey()))) continue;
            HashMap<String, Object> pairs = new HashMap<String, Object>();
            pairs.put("left", left.get(entry.getKey()));
            pairs.put("right", right.get(entry.getKey()));
            different.put((String)entry.getKey(), pairs);
        }
        return different;
    }
}

