/*
 * Decompiled with CFR 0.152.
 */
package apoc.es;

import apoc.Extended;
import apoc.es.ElasticSearchConfig;
import apoc.load.LoadJsonUtils;
import apoc.result.LoadDataMapResult;
import apoc.util.Util;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.graphdb.security.URLAccessChecker;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@Extended
public class ElasticSearch {
    @Context
    public URLAccessChecker urlAccessChecker;

    protected String toPayload(Object payload) {
        if (payload == null) {
            return null;
        }
        if (payload instanceof Map) {
            return Util.toJson((Object)payload);
        }
        return payload.toString();
    }

    @Procedure
    @Description(value="apoc.es.stats(host-or-key,$config) - elastic search statistics")
    public Stream<LoadDataMapResult> stats(@Name(value="host") String hostOrKey, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        ElasticSearchConfig conf = new ElasticSearchConfig(config);
        String url = conf.getVersion().getElasticSearchUrl(hostOrKey);
        return this.loadJsonStream(url + "/_stats", conf, null);
    }

    @Procedure
    @Description(value="apoc.es.get(host-or-key,index-or-null,type-or-null,id-or-null,query-or-null,payload-or-null,$config) yield value - perform a GET operation on elastic search")
    public Stream<LoadDataMapResult> get(@Name(value="hostOrKey") String hostOrKey, @Name(value="index") String index, @Name(value="type") String type, @Name(value="id") String id, @Name(value="query") Object query, @Name(value="payload") Object payload, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        ElasticSearchConfig conf = new ElasticSearchConfig(config);
        String queryUrl = conf.getVersion().getQueryUrl(hostOrKey, index, type, id, query);
        return this.loadJsonStream(queryUrl, conf, this.toPayload(payload));
    }

    @Procedure
    @Description(value="apoc.es.query(host-or-key,index-or-null,type-or-null,query-or-null,payload-or-null,$config) yield value - perform a SEARCH operation on elastic search")
    public Stream<LoadDataMapResult> query(@Name(value="hostOrKey") String hostOrKey, @Name(value="index") String index, @Name(value="type") String type, @Name(value="query") Object query, @Name(value="payload") Object payload, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        ElasticSearchConfig conf = new ElasticSearchConfig(config);
        String searchQueryUrl = conf.getVersion().getSearchQueryUrl(hostOrKey, index, type, query);
        return this.loadJsonStream(searchQueryUrl, conf, this.toPayload(payload));
    }

    @Procedure
    @Description(value="apoc.es.getRaw(host-or-key,path,payload-or-null,$config) yield value - perform a raw GET operation on elastic search")
    public Stream<LoadDataMapResult> getRaw(@Name(value="hostOrKey") String hostOrKey, @Name(value="path") String suffix, @Name(value="payload") Object payload, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        ElasticSearchConfig conf = new ElasticSearchConfig(config);
        String url = conf.getVersion().getElasticSearchUrl(hostOrKey);
        return this.loadJsonStream(url + "/" + suffix, conf, this.toPayload(payload));
    }

    @Procedure
    @Description(value="apoc.es.postRaw(host-or-key,path,payload-or-null,$config) yield value - perform a raw POST operation on elastic search")
    public Stream<LoadDataMapResult> postRaw(@Name(value="hostOrKey") String hostOrKey, @Name(value="path") String suffix, @Name(value="payload") Object payload, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        ElasticSearchConfig conf = new ElasticSearchConfig(config, "POST");
        String url = conf.getVersion().getElasticSearchUrl(hostOrKey);
        return this.loadJsonStream(url + "/" + suffix, conf, this.toPayload(payload));
    }

    @Procedure
    @Description(value="apoc.es.post(host-or-key,index-or-null,type-or-null,query-or-null,payload-or-null,$config) yield value - perform a POST operation on elastic search")
    public Stream<LoadDataMapResult> post(@Name(value="hostOrKey") String hostOrKey, @Name(value="index") String index, @Name(value="type") String type, @Name(value="query") Object query, @Name(value="payload", defaultValue="{}") Object payload, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        if (payload == null) {
            payload = Collections.emptyMap();
        }
        ElasticSearchConfig conf = new ElasticSearchConfig(config, "POST");
        String queryUrl = conf.getVersion().getQueryUrl(hostOrKey, index, type, null, query);
        return this.loadJsonStream(queryUrl, conf, this.toPayload(payload));
    }

    @Procedure
    @Description(value="apoc.es.put(host-or-key,index-or-null,type-or-null,id-or-null,query-or-null,payload-or-null,$config) yield value - perform a PUT operation on elastic search")
    public Stream<LoadDataMapResult> put(@Name(value="hostOrKey") String hostOrKey, @Name(value="index") String index, @Name(value="type") String type, @Name(value="id") String id, @Name(value="query") Object query, @Name(value="payload", defaultValue="{}") Map<String, Object> payload, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        if (payload == null) {
            payload = Collections.emptyMap();
        }
        ElasticSearchConfig conf = new ElasticSearchConfig(config, "PUT");
        String queryUrl = conf.getVersion().getQueryUrl(hostOrKey, index, type, id, query);
        return this.loadJsonStream(queryUrl, conf, this.toPayload(payload));
    }

    @Procedure
    @Description(value="apoc.es.delete(host-or-key,index-or-null,type-or-null,id-or-null,query-or-null,$config) yield value - perform a DELETE operation on elastic search")
    public Stream<LoadDataMapResult> delete(@Name(value="hostOrKey") String hostOrKey, @Name(value="index") String index, @Name(value="type") String type, @Name(value="id") String id, @Name(value="query", defaultValue="null") Object query, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        String payload = "";
        ElasticSearchConfig conf = new ElasticSearchConfig(config, "DELETE");
        String queryUrl = conf.getVersion().getQueryUrl(hostOrKey, index, type, id, query);
        return this.loadJsonStream(queryUrl, conf, payload);
    }

    private Stream<LoadDataMapResult> loadJsonStream(@Name(value="url") Object url, ElasticSearchConfig conf, @Name(value="payload") String payload) {
        return LoadJsonUtils.loadJsonStream((Object)url, conf.getHeaders(), (String)payload, (String)"", (boolean)true, null, null, null, (URLAccessChecker)this.urlAccessChecker);
    }
}

