/*
 * Decompiled with CFR 0.152.
 */
package apoc.export.parquet;

import apoc.Pools;
import apoc.export.parquet.ExportParquetStrategy;
import apoc.export.parquet.ParquetBufferedWriter;
import apoc.export.parquet.ParquetConfig;
import apoc.export.parquet.ParquetExportType;
import apoc.export.util.ProgressReporter;
import apoc.result.ExportProgressInfo;
import apoc.result.ProgressInfo;
import apoc.util.FileUtils;
import apoc.util.QueueBasedSpliterator;
import apoc.util.QueueUtil;
import apoc.util.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.example.ExampleParquetWriter;
import org.apache.parquet.io.OutputFile;
import org.apache.parquet.schema.MessageType;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.logging.Log;
import org.neo4j.procedure.TerminationGuard;

public abstract class ExportParquetFileStrategy<TYPE, IN>
implements ExportParquetStrategy<IN, Stream<ExportProgressInfo>> {
    private String fileName;
    private final GraphDatabaseService db;
    private final Pools pools;
    private final TerminationGuard terminationGuard;
    private final Log logger;
    private final ParquetExportType exportType;
    ParquetWriter writer;

    public ExportParquetFileStrategy(String fileName, GraphDatabaseService db, Pools pools, TerminationGuard terminationGuard, Log logger, ParquetExportType exportType) {
        this.fileName = fileName;
        this.db = db;
        this.pools = pools;
        this.terminationGuard = terminationGuard;
        this.logger = logger;
        this.exportType = exportType;
    }

    @Override
    public Stream<ExportProgressInfo> export(IN data2, ParquetConfig config) {
        ExportProgressInfo progressInfo = new ExportProgressInfo(this.fileName, this.getSource(data2), "parquet");
        progressInfo.setBatches((long)config.getBatchSize());
        ProgressReporter reporter = new ProgressReporter(null, null, (ProgressInfo)progressInfo);
        ArrayBlockingQueue queue = new ArrayBlockingQueue(10);
        Util.inTxFuture((ExecutorService)this.pools.getDefaultExecutorService(), (GraphDatabaseService)this.db, tx -> {
            int batchCount = 0;
            ArrayList<TYPE> rows = new ArrayList<TYPE>(config.getBatchSize());
            ParquetBufferedWriter parquetBufferedWriter = new ParquetBufferedWriter(FileUtils.getOutputStream((String)this.fileName));
            ExampleParquetWriter.Builder builder = ExampleParquetWriter.builder((OutputFile)parquetBufferedWriter);
            try {
                Iterator<TYPE> it = this.toIterator(reporter, data2);
                while (!Util.transactionIsTerminated((TerminationGuard)this.terminationGuard) && it.hasNext()) {
                    rows.add(it.next());
                    if (batchCount > 0 && batchCount % config.getBatchSize() == 0) {
                        this.writeBatch(builder, rows, data2, config);
                    }
                    ++batchCount;
                }
                if (!rows.isEmpty()) {
                    this.writeBatch(builder, rows, data2, config);
                }
                QueueUtil.put((BlockingQueue)queue, (Object)progressInfo, (long)10L);
                Boolean bl = true;
                return bl;
            }
            catch (Exception e) {
                this.logger.error("Exception while extracting Parquet data:", (Throwable)e);
            }
            finally {
                this.closeWriter();
                reporter.done();
                QueueUtil.put((BlockingQueue)queue, (Object)ExportProgressInfo.EMPTY, (long)10L);
            }
            return true;
        });
        QueueBasedSpliterator spliterator = new QueueBasedSpliterator(queue, (Object)ExportProgressInfo.EMPTY, this.terminationGuard, Integer.MAX_VALUE);
        return StreamSupport.stream(spliterator, false);
    }

    private void closeWriter() {
        if (this.writer == null) {
            return;
        }
        try {
            this.writer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void writeBatch(ExampleParquetWriter.Builder builder, List<TYPE> rows, IN data2, ParquetConfig config) {
        List<Map<String, Object>> conf = this.exportType.createConfig(rows, data2, config);
        MessageType schema = this.exportType.schemaFor(this.db, conf);
        if (this.writer == null) {
            this.writer = this.getBuild(schema, builder);
        }
        this.writeRows(rows, (ParquetWriter<Group>)this.writer, this.exportType, schema);
    }

    public abstract String getSource(IN var1);

    public abstract Iterator<TYPE> toIterator(ProgressReporter var1, IN var2);
}

