/*
 * Decompiled with CFR 0.152.
 */
package apoc.export.xls;

import apoc.ApocConfig;
import apoc.export.util.ProgressReporter;
import apoc.export.xls.XlsExportConfig;
import apoc.result.ExportProgressInfo;
import apoc.util.ExtendedListUtils;
import java.io.IOException;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.neo4j.cypher.export.SubGraph;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Result;

public class ExportXlsHandler {
    public static final String XLS_MISSING_DEPS_ERROR = "Cannot find the needed jar into the plugins folder in order to use . \nPlease see the documentation: https://neo4j.com/labs/apoc/5/overview/apoc.export/apoc.export.xls.all/#_install_dependencies";

    /*
     * Exception decompiling
     */
    public static Stream<ExportProgressInfo> getProgressInfoStream(String fileName, String source, Object data, Map<String, Object> configMap, ApocConfig apocConfig, GraphDatabaseService db) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void dumpResult(Result result, XlsExportConfig config, SXSSFWorkbook wb, Map<Class, CellStyle> styles) {
        SXSSFSheet sheet = wb.createSheet();
        sheet.trackAllColumnsForAutoSizing();
        int columnNum = 0;
        int rowNum = 0;
        SXSSFRow headerRow = sheet.createRow(rowNum++);
        for (String header : result.columns()) {
            Cell cell = headerRow.createCell(columnNum);
            sheet.autoSizeColumn(columnNum);
            cell.setCellValue(header);
            ++columnNum;
        }
        while (result.hasNext()) {
            Map map = result.next();
            SXSSFRow row = sheet.createRow(rowNum++);
            columnNum = 0;
            for (String header : result.columns()) {
                columnNum = ExportXlsHandler.amendCell((Row)row, columnNum, map.get(header), config, styles);
            }
        }
    }

    private static void dumpSubGraph(SubGraph subgraph, XlsExportConfig config, ProgressReporter reporter, SXSSFWorkbook wb, Map<Class, CellStyle> styles) {
        HashMap<String, Triple<SXSSFSheet, List<String>, List<String>>> sheetAndPropsForName = new HashMap<String, Triple<SXSSFSheet, List<String>, List<String>>>();
        for (Node node : subgraph.getNodes()) {
            List<Object> labels = config.isJoinLabels() ? Collections.singletonList(StreamSupport.stream(node.getLabels().spliterator(), false).map(Label::name).collect(Collectors.joining(","))) : StreamSupport.stream(node.getLabels().spliterator(), false).map(Label::name).collect(Collectors.toList());
            for (String label : labels) {
                String labelName = (config.isPrefixSheetWithEntityType() ? "Node-" : "") + label;
                ExportXlsHandler.createRowForEntity((Workbook)wb, sheetAndPropsForName, (Entity)node, labelName, reporter, config, styles);
            }
        }
        for (Relationship relationship : subgraph.getRelationships()) {
            String relationshipType = (config.isPrefixSheetWithEntityType() ? "Rel-" : "") + relationship.getType().name();
            ExportXlsHandler.createRowForEntity((Workbook)wb, sheetAndPropsForName, (Entity)relationship, relationshipType, reporter, config, styles);
        }
        for (Triple triple : sheetAndPropsForName.values()) {
            Sheet sheet = (Sheet)triple.getLeft();
            List magicKeys = (List)triple.getMiddle();
            List keys = (List)triple.getRight();
            Row row = sheet.getRow(0);
            int cellNum = 0;
            for (String key : ExtendedListUtils.union(magicKeys, keys)) {
                sheet.autoSizeColumn(cellNum);
                Cell cell = row.createCell(cellNum++);
                cell.setCellValue(key);
            }
        }
    }

    private static Map<Class, CellStyle> buildCellStyles(XlsExportConfig config, SXSSFWorkbook wb) {
        CreationHelper createHelper = wb.getCreationHelper();
        CellStyle dateTimeCellStyle = wb.createCellStyle();
        dateTimeCellStyle.setDataFormat(createHelper.createDataFormat().getFormat(config.getDateTimeStyle()));
        CellStyle dateCellStyle = wb.createCellStyle();
        dateCellStyle.setDataFormat(createHelper.createDataFormat().getFormat(config.getDateStyle()));
        HashMap<Class, CellStyle> styles = new HashMap<Class, CellStyle>();
        styles.put(ZonedDateTime.class, dateTimeCellStyle);
        styles.put(LocalDate.class, dateCellStyle);
        return styles;
    }

    private static void createRowForEntity(Workbook wb, Map<String, Triple<SXSSFSheet, List<String>, List<String>>> sheetAndPropsForName, Entity entity, String sheetName, ProgressReporter reporter, XlsExportConfig config, Map<Class, CellStyle> styles) {
        Triple triple = sheetAndPropsForName.computeIfAbsent(sheetName, s -> {
            SXSSFSheet sheet = (SXSSFSheet)wb.createSheet(sheetName);
            sheet.trackAllColumnsForAutoSizing();
            sheet.createRow(0);
            return Triple.of((Object)sheet, entity instanceof Node ? Arrays.asList(config.getHeaderNodeId()) : Arrays.asList(config.getHeaderRelationshipId(), config.getHeaderStartNodeId(), config.getHeaderEndNodeId()), new ArrayList());
        });
        Sheet sheet = (Sheet)triple.getLeft();
        List propertyKeys = (List)triple.getRight();
        int lastRowNum = sheet.getLastRowNum();
        Row row = sheet.createRow(lastRowNum + 1);
        int cellNum = 0;
        TreeMap props = new TreeMap(entity.getAllProperties());
        if (entity instanceof Node) {
            Node node = (Node)entity;
            idCell = row.createCell(cellNum++);
            idCell.setCellValue(Long.valueOf(node.getId()).doubleValue());
            reporter.update(1L, 0L, (long)props.size());
        } else if (entity instanceof Relationship) {
            Relationship relationship = (Relationship)entity;
            idCell = row.createCell(cellNum++);
            idCell.setCellValue(Long.valueOf(relationship.getId()).doubleValue());
            Cell fromCell = row.createCell(cellNum++);
            fromCell.setCellValue(Long.valueOf(relationship.getStartNodeId()).doubleValue());
            Cell toCell = row.createCell(cellNum++);
            toCell.setCellValue(Long.valueOf(relationship.getEndNodeId()).doubleValue());
            reporter.update(0L, 1L, (long)props.size());
        }
        for (String key : propertyKeys) {
            cellNum = ExportXlsHandler.amendCell(row, cellNum, props.remove(key), config, styles);
        }
        for (String key : props.keySet()) {
            propertyKeys.add(key);
            cellNum = ExportXlsHandler.amendCell(row, cellNum, props.get(key), config, styles);
        }
    }

    private static int amendCell(Row row, int cellNum, Object value, XlsExportConfig config, Map<Class, CellStyle> styles) {
        Cell cell = row.createCell(cellNum++);
        if (value == null) {
            cell.setCellType(CellType.BLANK);
        } else {
            CellStyle cellStyle = styles.get(value.getClass());
            if (cellStyle != null) {
                cell.setCellStyle(cellStyle);
            }
            if (value instanceof String) {
                cell.setCellValue((String)value);
            } else if (value instanceof Number) {
                cell.setCellValue(((Number)value).doubleValue());
            } else if (value instanceof Boolean) {
                cell.setCellValue(((Boolean)value).booleanValue());
            } else if (value instanceof String[]) {
                String[] values = (String[])value;
                cell.setCellValue(Arrays.stream(values).collect(Collectors.joining(config.getArrayDelimiter())));
            } else if (value instanceof long[]) {
                long[] values = (long[])value;
                cell.setCellValue(Arrays.stream(values).mapToObj(Long::toString).collect(Collectors.joining(config.getArrayDelimiter())));
            } else if (value instanceof double[]) {
                double[] values = (double[])value;
                cell.setCellValue(Arrays.stream(values).mapToObj(Double::toString).collect(Collectors.joining(config.getArrayDelimiter())));
            } else if (value instanceof List) {
                List values = (List)value;
                String collect = values.stream().map(x -> x.toString()).collect(Collectors.joining(config.getArrayDelimiter()));
                cell.setCellValue(collect);
            } else if (value instanceof LocalDate) {
                LocalDate localDate = (LocalDate)value;
                cell.setCellValue(Date.from(localDate.atStartOfDay(ZoneId.systemDefault()).toInstant()));
            } else if (value instanceof ZonedDateTime) {
                ZonedDateTime zondedDateTime = (ZonedDateTime)value;
                cell.setCellValue(Date.from(zondedDateTime.toInstant()));
            } else {
                cell.setCellValue(value.toString());
            }
        }
        return cellNum;
    }
}

