/*
 * Decompiled with CFR 0.152.
 */
package apoc.generate.relationship;

import apoc.generate.config.BarabasiAlbertConfig;
import apoc.generate.config.NumberOfNodesBasedConfig;
import apoc.generate.relationship.BaseRelationshipGenerator;
import apoc.generate.relationship.CompleteGraphRelationshipGenerator;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import org.apache.commons.lang3.tuple.Pair;

public class BarabasiAlbertRelationshipGenerator
extends BaseRelationshipGenerator<BarabasiAlbertConfig> {
    private final Random random = new Random();

    public BarabasiAlbertRelationshipGenerator(BarabasiAlbertConfig configuration) {
        super(configuration);
    }

    @Override
    protected List<Pair<Integer, Integer>> doGenerateEdges() {
        int edgesPerNewNode = ((BarabasiAlbertConfig)this.getConfiguration()).getEdgesPerNewNode();
        long numberOfNodes = ((BarabasiAlbertConfig)this.getConfiguration()).getNumberOfNodes();
        List<Pair<Integer, Integer>> edges = new CompleteGraphRelationshipGenerator(new NumberOfNodesBasedConfig(edgesPerNewNode + 1)).doGenerateEdges();
        HashSet<Integer> omit = new HashSet<Integer>(edgesPerNewNode);
        int source = edgesPerNewNode + 1;
        while ((long)source < numberOfNodes) {
            omit.clear();
            for (int edge = 0; edge < edgesPerNewNode; ++edge) {
                Pair<Integer, Integer> randomEdge;
                int target;
                do {
                    randomEdge = edges.get(this.random.nextInt(edges.size()));
                } while (omit.contains(target = (this.random.nextBoolean() ? (Integer)randomEdge.getLeft() : (Integer)randomEdge.getRight()).intValue()));
                omit.add(target);
                edges.add((Pair<Integer, Integer>)Pair.of((Object)target, (Object)source));
            }
            ++source;
        }
        return edges;
    }
}

