/*
 * Decompiled with CFR 0.152.
 */
package apoc.generate.relationship;

import apoc.generate.config.ErdosRenyiConfig;
import apoc.generate.relationship.BaseRelationshipGenerator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;

public class ErdosRenyiRelationshipGenerator
extends BaseRelationshipGenerator<ErdosRenyiConfig> {
    private final Random random = new Random();

    public ErdosRenyiRelationshipGenerator(ErdosRenyiConfig configuration) {
        super(configuration);
    }

    @Override
    protected List<Pair<Integer, Integer>> doGenerateEdges() {
        long potentialEdges;
        long threshold = ((ErdosRenyiConfig)this.getConfiguration()).getNumberOfEdges() * 4;
        if (threshold > (potentialEdges = Long.valueOf(((ErdosRenyiConfig)this.getConfiguration()).getNumberOfNodes()) * (Long.valueOf(((ErdosRenyiConfig)this.getConfiguration()).getNumberOfNodes()) - 1L))) {
            return this.doGenerateEdgesWithOmitList();
        }
        return this.doGenerateEdgesSimpler();
    }

    private List<Pair<Integer, Integer>> doGenerateEdgesSimpler() {
        int numberOfNodes = ((ErdosRenyiConfig)this.getConfiguration()).getNumberOfNodes();
        long numberOfEdges = ((ErdosRenyiConfig)this.getConfiguration()).getNumberOfEdges();
        HashSet<Pair> edges = new HashSet<Pair>();
        while ((long)edges.size() < numberOfEdges) {
            int origin = this.random.nextInt(numberOfNodes);
            int target = this.random.nextInt(numberOfNodes);
            if (target == origin) continue;
            edges.add(Pair.of((Object)origin, (Object)target));
        }
        return new LinkedList<Pair<Integer, Integer>>(edges);
    }

    private List<Pair<Integer, Integer>> doGenerateEdgesWithOmitList() {
        int numberOfNodes = ((ErdosRenyiConfig)this.getConfiguration()).getNumberOfNodes();
        int numberOfEdges = ((ErdosRenyiConfig)this.getConfiguration()).getNumberOfEdges();
        long maxEdges = Long.valueOf(numberOfNodes) * (Long.valueOf(numberOfNodes) - 1L) / 2L;
        LinkedList<Pair<Integer, Integer>> edges = new LinkedList<Pair<Integer, Integer>>();
        for (Long index : this.edgeIndices(numberOfEdges, maxEdges)) {
            edges.add(this.indexToEdgeBijection(index));
        }
        return edges;
    }

    private Pair<Integer, Integer> indexToEdgeBijection(long index) {
        long i = (long)Math.ceil((Math.sqrt(1L + 8L * (index + 1L)) - 1.0) / 2.0);
        long diff = index + 1L - i * (i - 1L) / 2L;
        return Pair.of((Object)((int)i), (Object)((int)diff - 1));
    }

    private Set<Long> edgeIndices(int numberOfEdges, long maxEdges) {
        HashSet<Long> result = new HashSet<Long>(numberOfEdges);
        while (result.size() < numberOfEdges) {
            result.add(this.nextLong(maxEdges));
        }
        return result;
    }

    private long nextLong(long length) {
        return (long)(this.random.nextDouble() * (double)length);
    }
}

