/*
 * Decompiled with CFR 0.152.
 */
package apoc.graph;

import apoc.Extended;
import apoc.result.GraphResult;
import apoc.result.VirtualNode;
import apoc.result.VirtualRelationship;
import apoc.util.collection.Iterables;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;
import org.neo4j.procedure.UserAggregationFunction;
import org.neo4j.procedure.UserAggregationResult;
import org.neo4j.procedure.UserAggregationUpdate;

@Extended
public class GraphsExtended {
    @Procedure(value="apoc.graph.filterProperties")
    @Description(value="CALL apoc.graph.filterProperties(anyEntityObject, nodePropertiesToRemove, relPropertiesToRemove) YIELD nodes, relationships - returns a set of virtual nodes and relationships without the properties defined in nodePropertiesToRemove and relPropertiesToRemove")
    public Stream<GraphResult> fromData(@Name(value="value") Object value, @Name(value="nodePropertiesToRemove", defaultValue="{}") Map<String, List<String>> nodePropertiesToRemove, @Name(value="relPropertiesToRemove", defaultValue="{}") Map<String, List<String>> relPropertiesToRemove) {
        VirtualGraphExtractor extractor = new VirtualGraphExtractor(nodePropertiesToRemove, relPropertiesToRemove);
        extractor.extract(value);
        GraphResult result = new GraphResult(extractor.nodes(), extractor.rels());
        return Stream.of(result);
    }

    @UserAggregationFunction(value="apoc.graph.filterProperties")
    @Description(value="apoc.graph.filterProperties(anyEntityObject, nodePropertiesToRemove, relPropertiesToRemove) - aggregation function which returns an object {node: [virtual nodes], relationships: [virtual relationships]} without the properties defined in nodePropertiesToRemove and relPropertiesToRemove")
    public GraphFunction filterProperties() {
        return new GraphFunction();
    }

    public static class VirtualGraphExtractor {
        private static final String ALL_FILTER = "_all";
        private final Map<String, Node> nodes = new HashMap<String, Node>();
        private final Map<String, Relationship> rels = new HashMap<String, Relationship>();
        private final Map<String, List<String>> nodePropertiesToRemove;
        private final Map<String, List<String>> relPropertiesToRemove;

        public VirtualGraphExtractor(Map<String, List<String>> nodePropertiesToRemove, Map<String, List<String>> relPropertiesToRemove) {
            this.nodePropertiesToRemove = nodePropertiesToRemove;
            this.relPropertiesToRemove = relPropertiesToRemove;
        }

        public void extract(Object value) {
            if (value == null) {
                return;
            }
            if (value instanceof Node) {
                Node node = (Node)value;
                this.addVirtualNode(node);
            } else if (value instanceof Relationship) {
                Relationship rel = (Relationship)value;
                this.addVirtualRel(rel);
            } else if (value instanceof Path) {
                Path path = (Path)value;
                path.nodes().forEach(this::addVirtualNode);
                path.relationships().forEach(this::addVirtualRel);
            } else if (value instanceof Iterable) {
                ((Iterable)value).forEach(this::extract);
            } else if (value instanceof Map) {
                Map map = (Map)value;
                map.values().forEach(this::extract);
            } else if (value instanceof Iterator) {
                ((Iterator)value).forEachRemaining(this::extract);
            } else if (value instanceof Object[]) {
                Object[] array;
                for (Object i : array = (Object[])value) {
                    this.extract(i);
                }
            }
        }

        private void addVirtualRel(Relationship rel) {
            this.rels.putIfAbsent(rel.getElementId(), this.createVirtualRel(rel));
        }

        private void addVirtualNode(Node node) {
            this.nodes.putIfAbsent(node.getElementId(), this.createVirtualNode(node));
        }

        private Node createVirtualNode(Node startNode) {
            List props = Iterables.asList((Iterable)startNode.getPropertyKeys());
            this.nodePropertiesToRemove.forEach((k, v) -> {
                if (k.equals(ALL_FILTER) || startNode.hasLabel(Label.label((String)k))) {
                    props.removeAll((Collection<?>)v);
                }
            });
            return new VirtualNode(startNode, props);
        }

        private Relationship createVirtualRel(Relationship rel) {
            Node startNode = rel.getStartNode();
            startNode = this.nodes.putIfAbsent(startNode.getElementId(), this.createVirtualNode(startNode));
            Node endNode = rel.getEndNode();
            endNode = this.nodes.putIfAbsent(endNode.getElementId(), this.createVirtualNode(endNode));
            Map props = rel.getAllProperties();
            this.relPropertiesToRemove.forEach((k, v) -> {
                block3: {
                    block2: {
                        if (k.equals(ALL_FILTER)) break block2;
                        if (!rel.isType(RelationshipType.withName((String)k))) break block3;
                    }
                    v.forEach(props.keySet()::remove);
                }
            });
            return new VirtualRelationship(startNode, endNode, rel.getType(), props);
        }

        public List<Node> nodes() {
            return List.copyOf(this.nodes.values());
        }

        public List<Relationship> rels() {
            return List.copyOf(this.rels.values());
        }
    }

    public static class GraphFunction {
        public static final String NODES = "nodes";
        public static final String RELATIONSHIPS = "relationships";
        private VirtualGraphExtractor virtualGraphExtractor;

        @UserAggregationUpdate
        public void filterProperties(@Name(value="value") Object value, @Name(value="nodePropertiesToRemove", defaultValue="{}") Map<String, List<String>> nodePropertiesToRemove, @Name(value="relPropertiesToRemove", defaultValue="{}") Map<String, List<String>> relPropertiesToRemove) {
            if (this.virtualGraphExtractor == null) {
                this.virtualGraphExtractor = new VirtualGraphExtractor(nodePropertiesToRemove, relPropertiesToRemove);
            }
            this.virtualGraphExtractor.extract(value);
        }

        @UserAggregationResult
        public Object result() {
            List<Node> nodes = this.virtualGraphExtractor.nodes();
            List<Relationship> relationships = this.virtualGraphExtractor.rels();
            return Map.of(NODES, nodes, RELATIONSHIPS, relationships);
        }
    }
}

