/*
 * Decompiled with CFR 0.152.
 */
package apoc.kafka.consumer;

import apoc.kafka.consumer.NotInWriteableInstanceException;
import apoc.kafka.consumer.utils.ConsumerUtils;
import apoc.kafka.extensions.GraphDatabaseServerExtensionsKt;
import apoc.kafka.service.StreamsSinkService;
import apoc.kafka.service.StreamsStrategyStorage;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Result;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.Log;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u0000\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lapoc/kafka/consumer/StreamsEventSinkQueryExecution;", "Lapoc/kafka/service/StreamsSinkService;", "db", "Lorg/neo4j/kernel/internal/GraphDatabaseAPI;", "log", "Lorg/neo4j/logging/Log;", "streamsStrategyStorage", "Lapoc/kafka/service/StreamsStrategyStorage;", "(Lorg/neo4j/kernel/internal/GraphDatabaseAPI;Lorg/neo4j/logging/Log;Lapoc/kafka/service/StreamsStrategyStorage;)V", "write", "", "query", "", "params", "", "", "apoc"})
public final class StreamsEventSinkQueryExecution
extends StreamsSinkService {
    @NotNull
    private final GraphDatabaseAPI db;
    @NotNull
    private final Log log;

    public StreamsEventSinkQueryExecution(@NotNull GraphDatabaseAPI db, @NotNull Log log, @NotNull StreamsStrategyStorage streamsStrategyStorage) {
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        Intrinsics.checkNotNullParameter((Object)streamsStrategyStorage, (String)"streamsStrategyStorage");
        super(streamsStrategyStorage);
        this.db = db;
        this.log = log;
    }

    @Override
    public void write(@NotNull String query, @NotNull Collection<? extends Object> params) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter(params, (String)"params");
        if (params.isEmpty()) {
            return;
        }
        if (ConsumerUtils.INSTANCE.isWriteableInstance(this.db)) {
            GraphDatabaseServerExtensionsKt.execute((GraphDatabaseService)this.db, query, MapsKt.mapOf((Pair)TuplesKt.to((Object)"events", params)), (Function1)new Function1<Result, Unit>(this){
                final /* synthetic */ StreamsEventSinkQueryExecution this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull Result it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    if (StreamsEventSinkQueryExecution.access$getLog$p(this.this$0).isDebugEnabled()) {
                        StreamsEventSinkQueryExecution.access$getLog$p(this.this$0).debug("Query statistics:\n" + it.getQueryStatistics());
                    }
                }
            });
        } else {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Not writeable instance");
            }
            new NotInWriteableInstanceException("Not writeable instance");
        }
    }

    public static final /* synthetic */ Log access$getLog$p(StreamsEventSinkQueryExecution $this) {
        return $this.log;
    }
}

