/*
 * Decompiled with CFR 0.152.
 */
package apoc.kafka.consumer;

import apoc.kafka.consumer.StreamsEventSinkFactory;
import apoc.kafka.consumer.kafka.KafkaEventSink;
import apoc.kafka.consumer.procedures.StreamsSinkProcedures;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.Log;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\r\u001a\u00020\u000eJ\u001a\u0010\u000f\u001a\u00020\u000e2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lapoc/kafka/consumer/StreamsSinkConfigurationListener;", "", "db", "Lorg/neo4j/kernel/internal/GraphDatabaseAPI;", "log", "Lorg/neo4j/logging/Log;", "(Lorg/neo4j/kernel/internal/GraphDatabaseAPI;Lorg/neo4j/logging/Log;)V", "eventSink", "Lapoc/kafka/consumer/kafka/KafkaEventSink;", "getEventSink", "()Lapoc/kafka/consumer/kafka/KafkaEventSink;", "setEventSink", "(Lapoc/kafka/consumer/kafka/KafkaEventSink;)V", "shutdown", "", "start", "configMap", "", "", "apoc"})
public final class StreamsSinkConfigurationListener {
    @NotNull
    private final GraphDatabaseAPI db;
    @NotNull
    private final Log log;
    @Nullable
    private KafkaEventSink eventSink;

    public StreamsSinkConfigurationListener(@NotNull GraphDatabaseAPI db, @NotNull Log log) {
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        this.db = db;
        this.log = log;
    }

    @Nullable
    public final KafkaEventSink getEventSink() {
        return this.eventSink;
    }

    public final void setEventSink(@Nullable KafkaEventSink kafkaEventSink) {
        this.eventSink = kafkaEventSink;
    }

    public final void shutdown() {
        StreamsSinkProcedures.Companion.unregisterStreamsEventSink(this.db);
    }

    public final void start(@NotNull Map<String, String> configMap) {
        Intrinsics.checkNotNullParameter(configMap, (String)"configMap");
        KafkaEventSink kafkaEventSink = this.eventSink = StreamsEventSinkFactory.INSTANCE.getStreamsEventSink(configMap, this.log, this.db);
        Intrinsics.checkNotNull((Object)kafkaEventSink);
        StreamsSinkProcedures.Companion.registerStreamsEventSink(this.db, kafkaEventSink);
    }
}

