/*
 * Decompiled with CFR 0.152.
 */
package apoc.kafka.consumer.kafka;

import apoc.kafka.consumer.kafka.KafkaEventConsumer;
import apoc.kafka.consumer.kafka.KafkaSinkConfiguration;
import apoc.kafka.consumer.kafka.KafkaTopicConfig;
import apoc.kafka.extensions.CommonExtensionsKt;
import apoc.kafka.service.StreamsSinkEntity;
import apoc.kafka.service.errors.ErrorData;
import apoc.kafka.service.errors.ErrorService;
import apoc.kafka.service.errors.KafkaErrorService;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.logging.Log;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\nJL\u0010\u0015\u001a\u00020\u00162\u001e\u0010\u0017\u001a\u001a\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u0019\u0012\u0004\u0012\u00020\u00160\u00182\u0006\u0010\u001b\u001a\u00020\b2\u001c\u0010\u001c\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0006\b\u0001\u0012\u00020\u001f\u0012\u0006\b\u0001\u0012\u00020\u001f0\u001e0\u001dJ(\u0010 \u001a\u00020\u00162\u001e\u0010\u0017\u001a\u001a\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u0019\u0012\u0004\u0012\u00020\u00160\u0018H\u0016J<\u0010 \u001a\u00020\u00162\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u001f0\"2\u001e\u0010\u0017\u001a\u001a\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u0019\u0012\u0004\u0012\u00020\u00160\u0018H\u0016J:\u0010#\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020%0\"2\u0006\u0010&\u001a\u00020'2\u001e\u0010\u0017\u001a\u001a\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u0019\u0012\u0004\u0012\u00020\u00160\u0018J(\u0010(\u001a\u00020\u00162\u001e\u0010\u0017\u001a\u001a\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u0019\u0012\u0004\u0012\u00020\u00160\u0018H\u0002J\u001c\u0010)\u001a\u00020\u00162\u0012\u0010*\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020+0\"H\u0002J\b\u0010,\u001a\u00020\u0016H\u0016J\b\u0010-\u001a\u00020\u0016H\u0016J\b\u0010.\u001a\u00020\u0016H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u000b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006/"}, d2={"Lapoc/kafka/consumer/kafka/KafkaAutoCommitEventConsumer;", "Lapoc/kafka/consumer/kafka/KafkaEventConsumer;", "config", "Lapoc/kafka/consumer/kafka/KafkaSinkConfiguration;", "log", "Lorg/neo4j/logging/Log;", "topics", "", "", "dbName", "(Lapoc/kafka/consumer/kafka/KafkaSinkConfiguration;Lorg/neo4j/logging/Log;Ljava/util/Set;Ljava/lang/String;)V", "consumer", "Lorg/apache/kafka/clients/consumer/KafkaConsumer;", "getConsumer", "()Lorg/apache/kafka/clients/consumer/KafkaConsumer;", "errorService", "Lapoc/kafka/service/errors/ErrorService;", "isSeekSet", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getTopics", "()Ljava/util/Set;", "executeAction", "", "action", "Lkotlin/Function2;", "", "Lapoc/kafka/service/StreamsSinkEntity;", "topic", "topicRecords", "", "Lorg/apache/kafka/clients/consumer/ConsumerRecord;", "", "read", "topicConfig", "", "readFromPartition", "Lorg/apache/kafka/common/TopicPartition;", "Lorg/apache/kafka/clients/consumer/OffsetAndMetadata;", "kafkaTopicConfig", "Lapoc/kafka/consumer/kafka/KafkaTopicConfig;", "readSimple", "setSeek", "topicPartitionsMap", "", "start", "stop", "wakeup", "apoc"})
@SourceDebugExtension(value={"SMAP\nKafkaAutoCommitEventConsumer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KafkaAutoCommitEventConsumer.kt\napoc/kafka/consumer/kafka/KafkaAutoCommitEventConsumer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,139:1\n1855#2,2:140\n1549#2:142\n1620#2,3:143\n1549#2:146\n1620#2,3:147\n1238#2,4:152\n1238#2,4:165\n453#3:150\n403#3:151\n494#3,7:156\n453#3:163\n403#3:164\n215#4,2:169\n*S KotlinDebug\n*F\n+ 1 KafkaAutoCommitEventConsumer.kt\napoc/kafka/consumer/kafka/KafkaAutoCommitEventConsumer\n*L\n77#1:140,2\n85#1:142\n85#1:143,3\n87#1:146\n87#1:147,3\n98#1:152,4\n100#1:165,4\n98#1:150\n98#1:151\n99#1:156,7\n100#1:163\n100#1:164\n125#1:169,2\n*E\n"})
public class KafkaAutoCommitEventConsumer
extends KafkaEventConsumer {
    @NotNull
    private final KafkaSinkConfiguration config;
    @NotNull
    private final Log log;
    @NotNull
    private final Set<String> topics;
    @NotNull
    private final String dbName;
    @NotNull
    private final ErrorService errorService;
    @NotNull
    private final AtomicBoolean isSeekSet;
    @NotNull
    private final KafkaConsumer<?, ?> consumer;

    public KafkaAutoCommitEventConsumer(@NotNull KafkaSinkConfiguration config, @NotNull Log log, @NotNull Set<String> topics, @NotNull String dbName) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        Intrinsics.checkNotNullParameter(topics, (String)"topics");
        Intrinsics.checkNotNullParameter((Object)dbName, (String)"dbName");
        super(config, log, topics);
        this.config = config;
        this.log = log;
        this.topics = topics;
        this.dbName = dbName;
        this.errorService = new KafkaErrorService(this.config.asProperties(), ErrorService.ErrorConfig.Companion.from(MapsKt.emptyMap()), (Function2<? super String, ? super Exception, Unit>)((Function2)new Function2<String, Exception, Unit>(this){
            final /* synthetic */ KafkaAutoCommitEventConsumer this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull String s, @Nullable Exception e) {
                Intrinsics.checkNotNullParameter((Object)s, (String)"s");
                Log log = KafkaAutoCommitEventConsumer.access$getLog$p(this.this$0);
                Intrinsics.checkNotNull((Object)e, (String)"null cannot be cast to non-null type kotlin.Throwable");
                log.error(s, (Throwable)e);
            }
        }));
        this.isSeekSet = new AtomicBoolean();
        if (!Intrinsics.areEqual((Object)this.config.getKeyDeserializer(), (Object)ByteArrayDeserializer.class.getName()) || !Intrinsics.areEqual((Object)this.config.getValueDeserializer(), (Object)ByteArrayDeserializer.class.getName())) {
            throw new RuntimeException("Invalid config");
        }
        this.consumer = new KafkaConsumer(this.config.asProperties());
    }

    @NotNull
    public final Set<String> getTopics() {
        return this.topics;
    }

    @NotNull
    public final KafkaConsumer<?, ?> getConsumer() {
        return this.consumer;
    }

    @Override
    public void start() {
        if (this.topics.isEmpty()) {
            this.log.info("No topics specified Kafka Consumer will not started");
            return;
        }
        this.consumer.subscribe((Collection)this.topics);
    }

    @Override
    public void stop() {
        this.consumer.close();
        this.errorService.close();
    }

    private final void readSimple(Function2<? super String, ? super List<StreamsSinkEntity>, Unit> action) {
        ConsumerRecords records = this.consumer.poll(Duration.ZERO);
        if (records.isEmpty()) {
            return;
        }
        Iterable $this$forEach$iv = this.topics;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String topic = (String)element$iv;
            boolean bl = false;
            Iterable topicRecords = records.records(topic);
            Intrinsics.checkNotNull((Object)topicRecords);
            this.executeAction(action, topic, topicRecords);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void executeAction(@NotNull Function2<? super String, ? super List<StreamsSinkEntity>, Unit> action, @NotNull String topic, @NotNull Iterable<? extends ConsumerRecord<? extends Object, ? extends Object>> topicRecords) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter(topicRecords, (String)"topicRecords");
        try {
            Collection<StreamsSinkEntity> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable<? extends ConsumerRecord<? extends Object, ? extends Object>> iterable = topicRecords;
            String string = topic;
            Function2<? super String, ? super List<StreamsSinkEntity>, Unit> function2 = action;
            boolean $i$f$map = false;
            void var6_12 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ConsumerRecord consumerRecord = (ConsumerRecord)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(CommonExtensionsKt.toStreamsSinkEntity(it));
            }
            collection = (List)destination$iv$iv;
            function2.invoke((Object)string, (Object)collection);
        }
        catch (Exception e) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable<? extends ConsumerRecord<? extends Object, ? extends Object>> $i$f$map = topicRecords;
            ErrorService errorService2 = this.errorService;
            boolean $i$f$map2 = false;
            void destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ConsumerRecord bl = (ConsumerRecord)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(ErrorData.Companion.from((ConsumerRecord<? extends Object, ? extends Object>)it, e, this.getClass(), this.dbName));
            }
            errorService2.report((List)destination$iv$iv2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<TopicPartition, OffsetAndMetadata> readFromPartition(@NotNull KafkaTopicConfig kafkaTopicConfig, @NotNull Function2<? super String, ? super List<StreamsSinkEntity>, Unit> action) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)kafkaTopicConfig, (String)"kafkaTopicConfig");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        this.setSeek(kafkaTopicConfig.getTopicPartitionsMap());
        ConsumerRecords records = this.consumer.poll(Duration.ZERO);
        if (records.isEmpty()) {
            object = MapsKt.emptyMap();
        } else {
            Map $this$filterValues$iv;
            List list;
            Object object2;
            Object k;
            Map.Entry it$iv$iv;
            Map.Entry entry;
            Object object3;
            void $this$mapValuesTo$iv$iv;
            Map $this$mapValues$iv;
            Map<TopicPartition, Long> map = kafkaTopicConfig.getTopicPartitionsMap();
            boolean $i$f$mapValues = false;
            void var6_6 = $this$mapValues$iv;
            Object destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean bl = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                object3 = destination$iv$iv;
                boolean bl2 = false;
                entry = (Map.Entry)element$iv$iv$iv;
                k = it$iv$iv.getKey();
                object2 = object3;
                boolean bl22 = false;
                list = records.records((TopicPartition)it.getKey());
                object2.put(k, list);
            }
            $this$mapValues$iv = destination$iv$iv;
            boolean $i$f$filterValues = false;
            Map result$iv = new LinkedHashMap();
            for (Map.Entry entry3 : $this$filterValues$iv.entrySet()) {
                List it = (List)entry3.getValue();
                boolean bl3 = false;
                Intrinsics.checkNotNull((Object)it);
                boolean bl4 = !((Collection)it).isEmpty();
                if (!bl4) continue;
                ((HashMap)result$iv).put(entry3.getKey(), entry3.getValue());
            }
            $this$filterValues$iv = result$iv;
            $i$f$mapValues = false;
            result$iv = $this$mapValues$iv;
            destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean bl5 = false;
            $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                it$iv$iv = (Map.Entry)element$iv$iv$iv;
                object3 = destination$iv$iv;
                boolean bl6 = false;
                entry = (Map.Entry)element$iv$iv$iv;
                k = it$iv$iv.getKey();
                object2 = object3;
                boolean bl52 = false;
                TopicPartition topic = (TopicPartition)entry.getKey();
                List topicRecords = (List)entry.getValue();
                String string = topic.topic();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"topic(...)");
                Intrinsics.checkNotNull((Object)topicRecords);
                this.executeAction(action, string, topicRecords);
                Object object4 = CollectionsKt.last((List)topicRecords);
                Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"last(...)");
                list = CommonExtensionsKt.offsetAndMetadata$default((ConsumerRecord)object4, null, 1, null);
                object2.put(k, list);
            }
            object = destination$iv$iv;
        }
        return object;
    }

    @Override
    public void read(@NotNull Function2<? super String, ? super List<StreamsSinkEntity>, Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        this.readSimple(action);
    }

    @Override
    public void read(@NotNull Map<String, ? extends Object> topicConfig, @NotNull Function2<? super String, ? super List<StreamsSinkEntity>, Unit> action) {
        Intrinsics.checkNotNullParameter(topicConfig, (String)"topicConfig");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        KafkaTopicConfig kafkaTopicConfig = KafkaTopicConfig.Companion.fromMap(topicConfig);
        if (kafkaTopicConfig.getTopicPartitionsMap().isEmpty()) {
            this.readSimple(action);
        } else {
            this.readFromPartition(kafkaTopicConfig, action);
        }
    }

    private final void setSeek(Map<TopicPartition, Long> topicPartitionsMap) {
        if (!this.isSeekSet.compareAndSet(false, true)) {
            return;
        }
        this.consumer.poll(0L);
        Map<TopicPartition, Long> $this$forEach$iv = topicPartitionsMap;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<TopicPartition, Long>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<TopicPartition, Long> element$iv;
            Map.Entry<TopicPartition, Long> it = element$iv = iterator.next();
            boolean bl = false;
            long l = ((Number)it.getValue()).longValue();
            if (l == -1L) {
                this.consumer.seekToBeginning((Collection)CollectionsKt.listOf((Object)it.getKey()));
                continue;
            }
            if (l == -2L) {
                this.consumer.seekToEnd((Collection)CollectionsKt.listOf((Object)it.getKey()));
                continue;
            }
            this.consumer.seek(it.getKey(), ((Number)it.getValue()).longValue());
        }
    }

    @Override
    public void wakeup() {
        this.consumer.wakeup();
    }

    public static final /* synthetic */ Log access$getLog$p(KafkaAutoCommitEventConsumer $this) {
        return $this.log;
    }
}

