/*
 * Decompiled with CFR 0.152.
 */
package apoc.kafka.consumer.kafka;

import apoc.kafka.consumer.kafka.KafkaSinkConfigurationKt;
import apoc.kafka.extensions.CommonExtensionsKt;
import apoc.kafka.utils.JSONUtils;
import apoc.kafka.utils.KafkaUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 )2\u00020\u0001:\u0001)Ba\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0003\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\t\u0012\u0014\b\u0002\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\f\u00a2\u0006\u0002\u0010\rJ\u0006\u0010\u0019\u001a\u00020\u001aJ\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010 \u001a\u00020\tH\u00c6\u0003J\t\u0010!\u001a\u00020\tH\u00c6\u0003J\u0015\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\fH\u00c6\u0003Je\u0010#\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\t2\u0014\b\u0002\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\fH\u00c6\u0001J\u0013\u0010$\u001a\u00020\t2\b\u0010%\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010&\u001a\u00020'H\u00d6\u0001J\t\u0010(\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000fR\u001d\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0011R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0011\u00a8\u0006*"}, d2={"Lapoc/kafka/consumer/kafka/KafkaSinkConfiguration;", "", "bootstrapServers", "", "keyDeserializer", "valueDeserializer", "groupId", "autoOffsetReset", "enableAutoCommit", "", "asyncCommit", "extraProperties", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ZZLjava/util/Map;)V", "getAsyncCommit", "()Z", "getAutoOffsetReset", "()Ljava/lang/String;", "getBootstrapServers", "getEnableAutoCommit", "getExtraProperties", "()Ljava/util/Map;", "getGroupId", "getKeyDeserializer", "getValueDeserializer", "asProperties", "Ljava/util/Properties;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "equals", "other", "hashCode", "", "toString", "Companion", "apoc"})
@SourceDebugExtension(value={"SMAP\nKafkaSinkConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KafkaSinkConfiguration.kt\napoc/kafka/consumer/kafka/KafkaSinkConfiguration\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,76:1\n478#2,7:77\n468#2:84\n414#2:85\n1238#3,4:86\n*S KotlinDebug\n*F\n+ 1 KafkaSinkConfiguration.kt\napoc/kafka/consumer/kafka/KafkaSinkConfiguration\n*L\n70#1:77,7\n71#1:84\n71#1:85\n71#1:86,4\n*E\n"})
public final class KafkaSinkConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String bootstrapServers;
    @NotNull
    private final String keyDeserializer;
    @NotNull
    private final String valueDeserializer;
    @NotNull
    private final String groupId;
    @NotNull
    private final String autoOffsetReset;
    private final boolean enableAutoCommit;
    private final boolean asyncCommit;
    @NotNull
    private final Map<String, String> extraProperties;

    public KafkaSinkConfiguration(@NotNull String bootstrapServers, @NotNull String keyDeserializer, @NotNull String valueDeserializer, @NotNull String groupId, @NotNull String autoOffsetReset, boolean enableAutoCommit, boolean asyncCommit, @NotNull Map<String, String> extraProperties) {
        Intrinsics.checkNotNullParameter((Object)bootstrapServers, (String)"bootstrapServers");
        Intrinsics.checkNotNullParameter((Object)keyDeserializer, (String)"keyDeserializer");
        Intrinsics.checkNotNullParameter((Object)valueDeserializer, (String)"valueDeserializer");
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)autoOffsetReset, (String)"autoOffsetReset");
        Intrinsics.checkNotNullParameter(extraProperties, (String)"extraProperties");
        this.bootstrapServers = bootstrapServers;
        this.keyDeserializer = keyDeserializer;
        this.valueDeserializer = valueDeserializer;
        this.groupId = groupId;
        this.autoOffsetReset = autoOffsetReset;
        this.enableAutoCommit = enableAutoCommit;
        this.asyncCommit = asyncCommit;
        this.extraProperties = extraProperties;
    }

    public /* synthetic */ KafkaSinkConfiguration(String string, String string2, String string3, String string4, String string5, boolean bl, boolean bl2, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "localhost:9092";
        }
        if ((n & 2) != 0) {
            string2 = "org.apache.kafka.common.serialization.ByteArrayDeserializer";
        }
        if ((n & 4) != 0) {
            string3 = "org.apache.kafka.common.serialization.ByteArrayDeserializer";
        }
        if ((n & 8) != 0) {
            string4 = "neo4j";
        }
        if ((n & 0x10) != 0) {
            string5 = "earliest";
        }
        if ((n & 0x20) != 0) {
            bl = true;
        }
        if ((n & 0x40) != 0) {
            bl2 = false;
        }
        if ((n & 0x80) != 0) {
            map = MapsKt.emptyMap();
        }
        this(string, string2, string3, string4, string5, bl, bl2, map);
    }

    @NotNull
    public final String getBootstrapServers() {
        return this.bootstrapServers;
    }

    @NotNull
    public final String getKeyDeserializer() {
        return this.keyDeserializer;
    }

    @NotNull
    public final String getValueDeserializer() {
        return this.valueDeserializer;
    }

    @NotNull
    public final String getGroupId() {
        return this.groupId;
    }

    @NotNull
    public final String getAutoOffsetReset() {
        return this.autoOffsetReset;
    }

    public final boolean getEnableAutoCommit() {
        return this.enableAutoCommit;
    }

    public final boolean getAsyncCommit() {
        return this.asyncCommit;
    }

    @NotNull
    public final Map<String, String> getExtraProperties() {
        return this.extraProperties;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Properties asProperties() {
        void $this$mapKeysTo$iv$iv;
        Properties props = new Properties();
        Map<String, Object> $this$filterKeys$iv = JSONUtils.INSTANCE.asMap(this);
        boolean $i$f$filterKeys = false;
        Map<String, Object> result$iv = new LinkedHashMap();
        for (Map.Entry<String, Object> entry$iv : $this$filterKeys$iv.entrySet()) {
            String it = entry$iv.getKey();
            boolean bl = false;
            if (!(!Intrinsics.areEqual((Object)it, (Object)"extraProperties") && !Intrinsics.areEqual((Object)it, (Object)"sinkConfiguration"))) continue;
            ((HashMap)result$iv).put(entry$iv.getKey(), entry$iv.getValue());
        }
        Map $this$mapKeys$iv = result$iv;
        boolean $i$f$mapKeys = false;
        result$iv = $this$mapKeys$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            void it;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            String string = CommonExtensionsKt.toPointCase((String)it.getKey());
            Map map2 = map;
            boolean bl2 = false;
            entry = it$iv$iv.getValue();
            map2.put(string, entry);
        }
        Map map = destination$iv$iv;
        props.putAll((Map<?, ?>)map);
        props.putAll(this.extraProperties);
        return props;
    }

    @NotNull
    public final String component1() {
        return this.bootstrapServers;
    }

    @NotNull
    public final String component2() {
        return this.keyDeserializer;
    }

    @NotNull
    public final String component3() {
        return this.valueDeserializer;
    }

    @NotNull
    public final String component4() {
        return this.groupId;
    }

    @NotNull
    public final String component5() {
        return this.autoOffsetReset;
    }

    public final boolean component6() {
        return this.enableAutoCommit;
    }

    public final boolean component7() {
        return this.asyncCommit;
    }

    @NotNull
    public final Map<String, String> component8() {
        return this.extraProperties;
    }

    @NotNull
    public final KafkaSinkConfiguration copy(@NotNull String bootstrapServers, @NotNull String keyDeserializer, @NotNull String valueDeserializer, @NotNull String groupId, @NotNull String autoOffsetReset, boolean enableAutoCommit, boolean asyncCommit, @NotNull Map<String, String> extraProperties) {
        Intrinsics.checkNotNullParameter((Object)bootstrapServers, (String)"bootstrapServers");
        Intrinsics.checkNotNullParameter((Object)keyDeserializer, (String)"keyDeserializer");
        Intrinsics.checkNotNullParameter((Object)valueDeserializer, (String)"valueDeserializer");
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)autoOffsetReset, (String)"autoOffsetReset");
        Intrinsics.checkNotNullParameter(extraProperties, (String)"extraProperties");
        return new KafkaSinkConfiguration(bootstrapServers, keyDeserializer, valueDeserializer, groupId, autoOffsetReset, enableAutoCommit, asyncCommit, extraProperties);
    }

    public static /* synthetic */ KafkaSinkConfiguration copy$default(KafkaSinkConfiguration kafkaSinkConfiguration, String string, String string2, String string3, String string4, String string5, boolean bl, boolean bl2, Map map, int n, Object object) {
        if ((n & 1) != 0) {
            string = kafkaSinkConfiguration.bootstrapServers;
        }
        if ((n & 2) != 0) {
            string2 = kafkaSinkConfiguration.keyDeserializer;
        }
        if ((n & 4) != 0) {
            string3 = kafkaSinkConfiguration.valueDeserializer;
        }
        if ((n & 8) != 0) {
            string4 = kafkaSinkConfiguration.groupId;
        }
        if ((n & 0x10) != 0) {
            string5 = kafkaSinkConfiguration.autoOffsetReset;
        }
        if ((n & 0x20) != 0) {
            bl = kafkaSinkConfiguration.enableAutoCommit;
        }
        if ((n & 0x40) != 0) {
            bl2 = kafkaSinkConfiguration.asyncCommit;
        }
        if ((n & 0x80) != 0) {
            map = kafkaSinkConfiguration.extraProperties;
        }
        return kafkaSinkConfiguration.copy(string, string2, string3, string4, string5, bl, bl2, map);
    }

    @NotNull
    public String toString() {
        return "KafkaSinkConfiguration(bootstrapServers=" + this.bootstrapServers + ", keyDeserializer=" + this.keyDeserializer + ", valueDeserializer=" + this.valueDeserializer + ", groupId=" + this.groupId + ", autoOffsetReset=" + this.autoOffsetReset + ", enableAutoCommit=" + this.enableAutoCommit + ", asyncCommit=" + this.asyncCommit + ", extraProperties=" + this.extraProperties + ")";
    }

    public int hashCode() {
        int result = this.bootstrapServers.hashCode();
        result = result * 31 + this.keyDeserializer.hashCode();
        result = result * 31 + this.valueDeserializer.hashCode();
        result = result * 31 + this.groupId.hashCode();
        result = result * 31 + this.autoOffsetReset.hashCode();
        result = result * 31 + Boolean.hashCode(this.enableAutoCommit);
        result = result * 31 + Boolean.hashCode(this.asyncCommit);
        result = result * 31 + ((Object)this.extraProperties).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof KafkaSinkConfiguration)) {
            return false;
        }
        KafkaSinkConfiguration kafkaSinkConfiguration = (KafkaSinkConfiguration)other;
        if (!Intrinsics.areEqual((Object)this.bootstrapServers, (Object)kafkaSinkConfiguration.bootstrapServers)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.keyDeserializer, (Object)kafkaSinkConfiguration.keyDeserializer)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.valueDeserializer, (Object)kafkaSinkConfiguration.valueDeserializer)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.groupId, (Object)kafkaSinkConfiguration.groupId)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.autoOffsetReset, (Object)kafkaSinkConfiguration.autoOffsetReset)) {
            return false;
        }
        if (this.enableAutoCommit != kafkaSinkConfiguration.enableAutoCommit) {
            return false;
        }
        if (this.asyncCommit != kafkaSinkConfiguration.asyncCommit) {
            return false;
        }
        return Intrinsics.areEqual(this.extraProperties, kafkaSinkConfiguration.extraProperties);
    }

    public KafkaSinkConfiguration() {
        this(null, null, null, null, null, false, false, null, 255, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nJ*\u0010\u000b\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0004H\u0002\u00a8\u0006\u000f"}, d2={"Lapoc/kafka/consumer/kafka/KafkaSinkConfiguration$Companion;", "", "()V", "create", "Lapoc/kafka/consumer/kafka/KafkaSinkConfiguration;", "cfg", "", "", "dbName", "isDefaultDb", "", "from", "validate", "", "config", "apoc"})
    @SourceDebugExtension(value={"SMAP\nKafkaSinkConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KafkaSinkConfiguration.kt\napoc/kafka/consumer/kafka/KafkaSinkConfiguration$Companion\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,76:1\n478#2,7:77\n468#2:84\n414#2:85\n478#2,7:94\n1238#3,4:86\n1549#3:90\n1620#3,3:91\n*S KotlinDebug\n*F\n+ 1 KafkaSinkConfiguration.kt\napoc/kafka/consumer/kafka/KafkaSinkConfiguration$Companion\n*L\n37#1:77,7\n38#1:84\n38#1:85\n42#1:94,7\n38#1:86,4\n41#1:90\n41#1:91,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KafkaSinkConfiguration from(@NotNull Map<String, String> cfg, @NotNull String dbName, boolean isDefaultDb) {
            Intrinsics.checkNotNullParameter(cfg, (String)"cfg");
            Intrinsics.checkNotNullParameter((Object)dbName, (String)"dbName");
            KafkaSinkConfiguration kafkaCfg = this.create(cfg, dbName, isDefaultDb);
            this.validate(kafkaCfg);
            return kafkaCfg;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final KafkaSinkConfiguration create(@NotNull Map<String, String> cfg, @NotNull String dbName, boolean isDefaultDb) {
            void $this$mapTo$iv$iv;
            Object it;
            Object object;
            void $this$mapKeysTo$iv$iv;
            void $this$mapKeys$iv;
            Map $this$filterKeys$iv;
            Intrinsics.checkNotNullParameter(cfg, (String)"cfg");
            Intrinsics.checkNotNullParameter((Object)dbName, (String)"dbName");
            Map<String, String> map = cfg;
            boolean $i$f$filterKeys = false;
            LinkedHashMap result$iv = new LinkedHashMap();
            for (Map.Entry entry$iv : $this$filterKeys$iv.entrySet()) {
                String it2 = (String)entry$iv.getKey();
                boolean bl = false;
                if (!(StringsKt.startsWith$default((String)it2, (String)"apoc.kafka.", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)it2, (String)"apoc.kafka.sink", (boolean)false, (int)2, null))) continue;
                result$iv.put(entry$iv.getKey(), entry$iv.getValue());
            }
            $this$filterKeys$iv = result$iv;
            boolean $i$f$mapKeys = false;
            result$iv = $this$mapKeys$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
            boolean $i$f$mapKeysTo22 = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                String string;
                void it$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)((String)it.getKey()).substring(11), (String)"substring(...)");
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Map map2 = object;
                boolean bl2 = false;
                it = it$iv$iv.getValue();
                map2.put(string, it);
            }
            Map config = destination$iv$iv;
            KafkaSinkConfiguration kafkaSinkConfiguration = new KafkaSinkConfiguration(null, null, null, null, null, false, false, null, 255, null);
            Iterable $this$map$iv = JSONUtils.INSTANCE.asMap(kafkaSinkConfiguration).keySet();
            boolean $i$f$map = false;
            Iterable $i$f$mapKeysTo22 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (String)item$iv$iv;
                object = destination$iv$iv2;
                boolean bl = false;
                object.add(CommonExtensionsKt.toPointCase(it));
            }
            List keys = (List)destination$iv$iv2;
            Map $this$filterKeys$iv2 = config;
            boolean $i$f$filterKeys2 = false;
            LinkedHashMap result$iv2 = new LinkedHashMap();
            for (Map.Entry entry$iv : $this$filterKeys$iv2.entrySet()) {
                String it3 = (String)entry$iv.getKey();
                boolean bl = false;
                if (!(!keys.contains(it3))) continue;
                result$iv2.put(entry$iv.getKey(), entry$iv.getValue());
            }
            Map extraProperties = result$iv2;
            String string = config.getOrDefault("key.deserializer", kafkaSinkConfiguration.getKeyDeserializer());
            String string2 = config.getOrDefault("value.deserializer", kafkaSinkConfiguration.getValueDeserializer());
            String string3 = config.getOrDefault("bootstrap.servers", kafkaSinkConfiguration.getBootstrapServers());
            String string4 = config.getOrDefault("auto.offset.reset", kafkaSinkConfiguration.getAutoOffsetReset());
            String string5 = config.getOrDefault("group.id", kafkaSinkConfiguration.getGroupId()) + (String)(isDefaultDb ? "" : "-" + dbName);
            boolean bl = Boolean.parseBoolean(((Object)config.getOrDefault("enable.auto.commit", kafkaSinkConfiguration.getEnableAutoCommit())).toString());
            boolean bl3 = Boolean.parseBoolean(((Object)config.getOrDefault("async.commit", kafkaSinkConfiguration.getAsyncCommit())).toString());
            return kafkaSinkConfiguration.copy(string3, string, string2, string5, string4, bl, bl3, extraProperties);
        }

        private final void validate(KafkaSinkConfiguration config) {
            KafkaUtil.INSTANCE.validateConnection(config.getBootstrapServers(), "bootstrap.servers", false);
            String schemaRegistryUrlKey = "schema.registry.url";
            if (config.getExtraProperties().containsKey(schemaRegistryUrlKey)) {
                String schemaRegistryUrl = config.getExtraProperties().getOrDefault(schemaRegistryUrlKey, "");
                KafkaUtil.INSTANCE.validateConnection(schemaRegistryUrl, schemaRegistryUrlKey, false);
            }
            KafkaSinkConfigurationKt.access$validateDeserializers(config);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

