/*
 * Decompiled with CFR 0.152.
 */
package apoc.kafka.producer;

import apoc.kafka.events.EntityType;
import apoc.kafka.events.NodeChange;
import apoc.kafka.events.NodePayload;
import apoc.kafka.events.OperationType;
import apoc.kafka.events.Payload;
import apoc.kafka.events.RelationshipNodeChange;
import apoc.kafka.events.RelationshipPayload;
import apoc.kafka.events.Schema;
import apoc.kafka.events.StreamsConstraintType;
import apoc.kafka.events.StreamsTransactionEvent;
import apoc.kafka.extensions.CommonExtensionsKt;
import apoc.kafka.utils.KafkaUtil;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.ConstraintType;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000T\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u001c\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00050\u000b2\u0006\u0010\u0006\u001a\u00020\fH\u0002\u001a\u0012\u0010\r\u001a\u00020\u0005*\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0014\u0010\u000f\u001a\u0004\u0018\u00010\u000e*\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u0003\u001a\n\u0010\u0010\u001a\u00020\u0001*\u00020\u0011\u001a\n\u0010\u0012\u001a\u00020\u0001*\u00020\u0011\u001a\n\u0010\u0013\u001a\u00020\u0014*\u00020\u0011\u001a\f\u0010\u0015\u001a\u00020\u0005*\u00020\u0016H\u0002\u001a\u0016\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00050\u000b*\u00020\u0018\u001a\u0018\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u000b*\u00020\u0019\u001a\u0018\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u000b*\u00020\u001a\u00a8\u0006\u001b"}, d2={"isStrategyCompact", "", "strategy", "", "nodePayloadAsMessageKey", "", "payload", "Lapoc/kafka/events/NodePayload;", "schema", "Lapoc/kafka/events/Schema;", "relationshipAsMessageKey", "", "Lapoc/kafka/events/RelationshipPayload;", "asSourceRecordKey", "Lapoc/kafka/events/StreamsTransactionEvent;", "asSourceRecordValue", "isNodeConstraint", "Lorg/neo4j/graphdb/schema/ConstraintDefinition;", "isRelationshipConstraint", "streamsConstraintType", "Lapoc/kafka/events/StreamsConstraintType;", "toKey", "Lapoc/kafka/events/RelationshipNodeChange;", "toMap", "Lorg/apache/kafka/clients/producer/RecordMetadata;", "Lorg/neo4j/graphdb/Node;", "Lorg/neo4j/graphdb/Relationship;", "apoc"})
@SourceDebugExtension(value={"SMAP\nExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Extensions.kt\napoc/kafka/producer/ExtensionsKt\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,82:1\n478#2,7:83\n*S KotlinDebug\n*F\n+ 1 Extensions.kt\napoc/kafka/producer/ExtensionsKt\n*L\n70#1:83,7\n*E\n"})
public final class ExtensionsKt {
    @NotNull
    public static final Map<String, Object> toMap(@NotNull Node $this$toMap) {
        Intrinsics.checkNotNullParameter((Object)$this$toMap, (String)"<this>");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"id", (Object)String.valueOf($this$toMap.getId())), TuplesKt.to((Object)"properties", (Object)$this$toMap.getAllProperties()), TuplesKt.to((Object)"labels", CommonExtensionsKt.labelNames($this$toMap)), TuplesKt.to((Object)"type", (Object)((Object)EntityType.node))};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    @NotNull
    public static final Map<String, Object> toMap(@NotNull Relationship $this$toMap) {
        Intrinsics.checkNotNullParameter((Object)$this$toMap, (String)"<this>");
        Pair[] pairArray = new Pair[6];
        pairArray[0] = TuplesKt.to((Object)"id", (Object)String.valueOf($this$toMap.getId()));
        pairArray[1] = TuplesKt.to((Object)"properties", (Object)$this$toMap.getAllProperties());
        pairArray[2] = TuplesKt.to((Object)"label", (Object)$this$toMap.getType().name());
        Node node = $this$toMap.getStartNode();
        Intrinsics.checkNotNullExpressionValue((Object)node, (String)"getStartNode(...)");
        pairArray[3] = TuplesKt.to((Object)"start", ExtensionsKt.toMap(node));
        Node node2 = $this$toMap.getEndNode();
        Intrinsics.checkNotNullExpressionValue((Object)node2, (String)"getEndNode(...)");
        pairArray[4] = TuplesKt.to((Object)"end", ExtensionsKt.toMap(node2));
        pairArray[5] = TuplesKt.to((Object)"type", (Object)((Object)EntityType.relationship));
        return MapsKt.mapOf((Pair[])pairArray);
    }

    @NotNull
    public static final Map<String, Object> toMap(@NotNull RecordMetadata $this$toMap) {
        Intrinsics.checkNotNullParameter((Object)$this$toMap, (String)"<this>");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"offset", (Object)$this$toMap.offset()), TuplesKt.to((Object)"timestamp", (Object)$this$toMap.timestamp()), TuplesKt.to((Object)"keySize", (Object)$this$toMap.serializedKeySize()), TuplesKt.to((Object)"valueSize", (Object)$this$toMap.serializedValueSize()), TuplesKt.to((Object)"partition", (Object)$this$toMap.partition())};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    @NotNull
    public static final StreamsConstraintType streamsConstraintType(@NotNull ConstraintDefinition $this$streamsConstraintType) {
        Intrinsics.checkNotNullParameter((Object)$this$streamsConstraintType, (String)"<this>");
        ConstraintType constraintType = $this$streamsConstraintType.getConstraintType();
        return switch (constraintType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[constraintType.ordinal()]) {
            case 1, 2 -> StreamsConstraintType.UNIQUE;
            default -> ExtensionsKt.isNodeConstraint($this$streamsConstraintType) ? StreamsConstraintType.NODE_PROPERTY_EXISTS : StreamsConstraintType.RELATIONSHIP_PROPERTY_EXISTS;
        };
    }

    public static final boolean isNodeConstraint(@NotNull ConstraintDefinition $this$isNodeConstraint) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isNodeConstraint, (String)"<this>");
        try {
            $this$isNodeConstraint.getLabel();
            bl = true;
        }
        catch (IllegalStateException e) {
            bl = false;
        }
        return bl;
    }

    public static final boolean isRelationshipConstraint(@NotNull ConstraintDefinition $this$isRelationshipConstraint) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isRelationshipConstraint, (String)"<this>");
        try {
            $this$isRelationshipConstraint.getRelationshipType();
            bl = true;
        }
        catch (IllegalStateException e) {
            bl = false;
        }
        return bl;
    }

    @Nullable
    public static final StreamsTransactionEvent asSourceRecordValue(@NotNull StreamsTransactionEvent $this$asSourceRecordValue, @NotNull String strategy) {
        Intrinsics.checkNotNullParameter((Object)$this$asSourceRecordValue, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)strategy, (String)"strategy");
        return ExtensionsKt.isStrategyCompact(strategy) && $this$asSourceRecordValue.getMeta().getOperation() == OperationType.deleted ? null : $this$asSourceRecordValue;
    }

    @NotNull
    public static final Object asSourceRecordKey(@NotNull StreamsTransactionEvent $this$asSourceRecordKey, @NotNull String strategy) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$asSourceRecordKey, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)strategy, (String)"strategy");
        if (ExtensionsKt.isStrategyCompact(strategy) && $this$asSourceRecordKey.getPayload() instanceof NodePayload) {
            Payload payload = $this$asSourceRecordKey.getPayload();
            Intrinsics.checkNotNull((Object)payload, (String)"null cannot be cast to non-null type apoc.kafka.events.NodePayload");
            object = ExtensionsKt.nodePayloadAsMessageKey((NodePayload)payload, $this$asSourceRecordKey.getSchema());
        } else if (ExtensionsKt.isStrategyCompact(strategy) && $this$asSourceRecordKey.getPayload() instanceof RelationshipPayload) {
            Payload payload = $this$asSourceRecordKey.getPayload();
            Intrinsics.checkNotNull((Object)payload, (String)"null cannot be cast to non-null type apoc.kafka.events.RelationshipPayload");
            object = ExtensionsKt.relationshipAsMessageKey((RelationshipPayload)payload);
        } else {
            object = $this$asSourceRecordKey.getMeta().getTxId() + (long)$this$asSourceRecordKey.getMeta().getTxEventId() + "-" + $this$asSourceRecordKey.getMeta().getTxEventId();
        }
        return object;
    }

    private static final Object nodePayloadAsMessageKey(NodePayload payload, Schema schema) {
        Object object;
        Map map;
        List labels;
        NodeChange nodeChange;
        List list;
        boolean bl = false;
        NodeChange nodeChange2 = payload.getAfter();
        if (nodeChange2 == null) {
            NodeChange nodeChange3 = payload.getBefore();
            nodeChange2 = nodeChange3;
            Intrinsics.checkNotNull((Object)nodeChange3);
        }
        if ((list = (nodeChange = nodeChange2).getLabels()) == null) {
            list = labels = CollectionsKt.emptyList();
        }
        if ((map = nodeChange.getProperties()) == null) {
            map = MapsKt.emptyMap();
        }
        Map props = map;
        Set keys = KafkaUtil.getNodeKeys$default(KafkaUtil.INSTANCE, labels, props.keySet(), schema.getConstraints(), null, 8, null);
        Map $this$filterKeys$iv = props;
        boolean $i$f$filterKeys = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterKeys$iv.entrySet()) {
            String it = (String)entry$iv.getKey();
            boolean bl2 = false;
            if (!keys.contains(it)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        Map ids = result$iv;
        if (ids.isEmpty()) {
            object = payload.getId();
        } else {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"ids", (Object)ids), TuplesKt.to((Object)"labels", (Object)labels)};
            object = MapsKt.mapOf((Pair[])pairArray);
        }
        return object;
    }

    private static final Object toKey(RelationshipNodeChange $this$toKey) {
        Object object;
        if ($this$toKey.getIds().isEmpty()) {
            object = $this$toKey.getId();
        } else {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"ids", $this$toKey.getIds()), TuplesKt.to((Object)"labels", $this$toKey.getLabels())};
            object = MapsKt.mapOf((Pair[])pairArray);
        }
        return object;
    }

    private static final Map<String, Object> relationshipAsMessageKey(RelationshipPayload payload) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"start", (Object)ExtensionsKt.toKey(payload.getStart())), TuplesKt.to((Object)"end", (Object)ExtensionsKt.toKey(payload.getEnd())), TuplesKt.to((Object)"label", (Object)payload.getLabel())};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    private static final boolean isStrategyCompact(String strategy) {
        return Intrinsics.areEqual((Object)strategy, (Object)"compact");
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ConstraintType.values().length];
            try {
                nArray[ConstraintType.UNIQUENESS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConstraintType.NODE_KEY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

