/*
 * Decompiled with CFR 0.152.
 */
package apoc.kafka.producer;

import apoc.kafka.events.Meta;
import apoc.kafka.events.Payload;
import apoc.kafka.events.RelKeyStrategy;
import apoc.kafka.events.RelationshipChange;
import apoc.kafka.events.RelationshipPayload;
import apoc.kafka.events.Schema;
import apoc.kafka.events.StreamsTransactionEvent;
import apoc.kafka.producer.ExtensionsKt;
import apoc.kafka.producer.RoutingConfiguration;
import apoc.kafka.producer.RoutingConfigurationKt;
import apoc.kafka.producer.RoutingProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.kafka.common.internals.Topic;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.Relationship;
import org.neo4j.logging.Log;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0015\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 (2\u00020\u0001:\u0001(BM\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\n\u0012\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\n\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\bH\u00c6\u0003J\u000f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00030\nH\u00c6\u0003J\u000f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00030\nH\u00c6\u0003JQ\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\b2\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\n2\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\nH\u00c6\u0001J\u0013\u0010\u001e\u001a\u00020\b2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u00d6\u0003J\u001e\u0010!\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010 0\"2\u0006\u0010#\u001a\u00020$H\u0016J\t\u0010%\u001a\u00020&H\u00d6\u0001J\t\u0010'\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0013\u00a8\u0006)"}, d2={"Lapoc/kafka/producer/RelationshipRoutingConfiguration;", "Lapoc/kafka/producer/RoutingConfiguration;", "name", "", "relKeyStrategy", "Lapoc/kafka/events/RelKeyStrategy;", "topic", "all", "", "include", "", "exclude", "(Ljava/lang/String;Lapoc/kafka/events/RelKeyStrategy;Ljava/lang/String;ZLjava/util/List;Ljava/util/List;)V", "getAll", "()Z", "getExclude", "()Ljava/util/List;", "getInclude", "getName", "()Ljava/lang/String;", "getRelKeyStrategy", "()Lapoc/kafka/events/RelKeyStrategy;", "getTopic", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "other", "", "filter", "", "relationship", "Lorg/neo4j/graphdb/Entity;", "hashCode", "", "toString", "Companion", "apoc"})
public final class RelationshipRoutingConfiguration
extends RoutingConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private final RelKeyStrategy relKeyStrategy;
    @NotNull
    private final String topic;
    private final boolean all;
    @NotNull
    private final List<String> include;
    @NotNull
    private final List<String> exclude;

    public RelationshipRoutingConfiguration(@NotNull String name, @NotNull RelKeyStrategy relKeyStrategy, @NotNull String topic, boolean all, @NotNull List<String> include, @NotNull List<String> exclude) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)((Object)relKeyStrategy), (String)"relKeyStrategy");
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter(include, (String)"include");
        Intrinsics.checkNotNullParameter(exclude, (String)"exclude");
        this.name = name;
        this.relKeyStrategy = relKeyStrategy;
        this.topic = topic;
        this.all = all;
        this.include = include;
        this.exclude = exclude;
    }

    public /* synthetic */ RelationshipRoutingConfiguration(String string, RelKeyStrategy relKeyStrategy, String string2, boolean bl, List list, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "";
        }
        if ((n & 2) != 0) {
            relKeyStrategy = RelKeyStrategy.DEFAULT;
        }
        if ((n & 4) != 0) {
            string2 = "neo4j";
        }
        if ((n & 8) != 0) {
            bl = true;
        }
        if ((n & 0x10) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 0x20) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        this(string, relKeyStrategy, string2, bl, list, list2);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final RelKeyStrategy getRelKeyStrategy() {
        return this.relKeyStrategy;
    }

    @Override
    @NotNull
    public String getTopic() {
        return this.topic;
    }

    @Override
    public boolean getAll() {
        return this.all;
    }

    @Override
    @NotNull
    public List<String> getInclude() {
        return this.include;
    }

    @Override
    @NotNull
    public List<String> getExclude() {
        return this.exclude;
    }

    @Override
    @NotNull
    public Map<String, Object> filter(@NotNull Entity relationship) {
        Intrinsics.checkNotNullParameter((Object)relationship, (String)"relationship");
        if (!(relationship instanceof Relationship)) {
            throw new IllegalArgumentException("argument must be and instance of " + Relationship.class.getName());
        }
        Map properties = RoutingConfigurationKt.access$filterProperties(((Relationship)relationship).getAllProperties(), this);
        Map map = MapsKt.toMutableMap(ExtensionsKt.toMap((Relationship)relationship));
        map.put("properties", properties);
        return map;
    }

    @NotNull
    public final String component1() {
        return this.name;
    }

    @NotNull
    public final RelKeyStrategy component2() {
        return this.relKeyStrategy;
    }

    @NotNull
    public final String component3() {
        return this.topic;
    }

    public final boolean component4() {
        return this.all;
    }

    @NotNull
    public final List<String> component5() {
        return this.include;
    }

    @NotNull
    public final List<String> component6() {
        return this.exclude;
    }

    @NotNull
    public final RelationshipRoutingConfiguration copy(@NotNull String name, @NotNull RelKeyStrategy relKeyStrategy, @NotNull String topic, boolean all, @NotNull List<String> include, @NotNull List<String> exclude) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)((Object)relKeyStrategy), (String)"relKeyStrategy");
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter(include, (String)"include");
        Intrinsics.checkNotNullParameter(exclude, (String)"exclude");
        return new RelationshipRoutingConfiguration(name, relKeyStrategy, topic, all, include, exclude);
    }

    public static /* synthetic */ RelationshipRoutingConfiguration copy$default(RelationshipRoutingConfiguration relationshipRoutingConfiguration, String string, RelKeyStrategy relKeyStrategy, String string2, boolean bl, List list, List list2, int n, Object object) {
        if ((n & 1) != 0) {
            string = relationshipRoutingConfiguration.name;
        }
        if ((n & 2) != 0) {
            relKeyStrategy = relationshipRoutingConfiguration.relKeyStrategy;
        }
        if ((n & 4) != 0) {
            string2 = relationshipRoutingConfiguration.topic;
        }
        if ((n & 8) != 0) {
            bl = relationshipRoutingConfiguration.all;
        }
        if ((n & 0x10) != 0) {
            list = relationshipRoutingConfiguration.include;
        }
        if ((n & 0x20) != 0) {
            list2 = relationshipRoutingConfiguration.exclude;
        }
        return relationshipRoutingConfiguration.copy(string, relKeyStrategy, string2, bl, list, list2);
    }

    @NotNull
    public String toString() {
        return "RelationshipRoutingConfiguration(name=" + this.name + ", relKeyStrategy=" + this.relKeyStrategy + ", topic=" + this.topic + ", all=" + this.all + ", include=" + this.include + ", exclude=" + this.exclude + ")";
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = result * 31 + this.relKeyStrategy.hashCode();
        result = result * 31 + this.topic.hashCode();
        result = result * 31 + Boolean.hashCode(this.all);
        result = result * 31 + ((Object)this.include).hashCode();
        result = result * 31 + ((Object)this.exclude).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RelationshipRoutingConfiguration)) {
            return false;
        }
        RelationshipRoutingConfiguration relationshipRoutingConfiguration = (RelationshipRoutingConfiguration)other;
        if (!Intrinsics.areEqual((Object)this.name, (Object)relationshipRoutingConfiguration.name)) {
            return false;
        }
        if (this.relKeyStrategy != relationshipRoutingConfiguration.relKeyStrategy) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.topic, (Object)relationshipRoutingConfiguration.topic)) {
            return false;
        }
        if (this.all != relationshipRoutingConfiguration.all) {
            return false;
        }
        if (!Intrinsics.areEqual(this.include, relationshipRoutingConfiguration.include)) {
            return false;
        }
        return Intrinsics.areEqual(this.exclude, relationshipRoutingConfiguration.exclude);
    }

    public RelationshipRoutingConfiguration() {
        this(null, null, null, false, null, null, 63, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\t\u001a\u00020\u00072\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000bJ(\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a8\u0006\u0011"}, d2={"Lapoc/kafka/producer/RelationshipRoutingConfiguration$Companion;", "", "()V", "parse", "", "Lapoc/kafka/producer/RelationshipRoutingConfiguration;", "topic", "", "pattern", "keyStrategyString", "log", "Lorg/neo4j/logging/Log;", "prepareEvent", "", "Lapoc/kafka/events/StreamsTransactionEvent;", "streamsTransactionEvent", "routingConf", "apoc"})
    @SourceDebugExtension(value={"SMAP\nRoutingConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RoutingConfiguration.kt\napoc/kafka/producer/RelationshipRoutingConfiguration$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,252:1\n1549#2:253\n1620#2,3:254\n766#2:257\n857#2,2:258\n1549#2:260\n1620#2,3:261\n1208#2,2:264\n1238#2,4:266\n*S KotlinDebug\n*F\n+ 1 RoutingConfiguration.kt\napoc/kafka/producer/RelationshipRoutingConfiguration$Companion\n*L\n182#1:253\n182#1:254,3\n209#1:257\n209#1:258,2\n212#1:260\n212#1:261,3\n239#1:264,2\n239#1:266,4\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<RelationshipRoutingConfiguration> parse(@NotNull String topic, @NotNull String pattern, @NotNull String keyStrategyString, @Nullable Log log) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
            Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
            Intrinsics.checkNotNullParameter((Object)keyStrategyString, (String)"keyStrategyString");
            Topic.validate((String)topic);
            if (Intrinsics.areEqual((Object)pattern, (Object)"*")) {
                return CollectionsKt.listOf((Object)new RelationshipRoutingConfiguration(null, null, topic, false, null, null, 59, null));
            }
            String[] stringArray = new String[]{";"};
            Iterable $this$map$iv = StringsKt.split$default((CharSequence)pattern, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Object object;
                int n;
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                MatchResult matcher = RoutingConfigurationKt.access$getPATTERN_REG$p().matchEntire((CharSequence)it);
                if (matcher == null) {
                    throw new IllegalArgumentException("The pattern " + pattern + " for topic " + topic + " is invalid");
                }
                CharSequence charSequence = (CharSequence)matcher.getGroupValues().get(1);
                Regex regex = RoutingConfigurationKt.access$getPATTERN_COLON_REG$p();
                List labels = regex.split(charSequence, n = 0);
                if (labels.size() > 1) {
                    throw new IllegalArgumentException("The pattern " + pattern + " for topic " + topic + " is invalid");
                }
                RoutingProperties properties = RoutingProperties.Companion.from(matcher);
                try {
                    String string2 = keyStrategyString.toUpperCase();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
                    object = RelKeyStrategy.valueOf(string2);
                }
                catch (IllegalArgumentException e) {
                    Log log2 = log;
                    if (log2 != null) {
                        String string3 = RelKeyStrategy.DEFAULT.toString().toLowerCase();
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                        log2.warn("Invalid key strategy setting, switching to default value " + string3);
                    }
                    object = RelKeyStrategy.DEFAULT;
                }
                RelKeyStrategy relKeyStrategy = object;
                object = StringsKt.replace$default((String)((Object)StringsKt.trim((CharSequence)((String)CollectionsKt.first((List)labels)))).toString(), (String)"`", (String)"", (boolean)false, (int)4, null);
                boolean bl2 = properties.getAll();
                List<String> list = properties.getInclude();
                List<String> list2 = properties.getExclude();
                collection.add(new RelationshipRoutingConfiguration((String)object, relKeyStrategy, topic, bl2, list, list2));
            }
            return (List)destination$iv$iv;
        }

        public static /* synthetic */ List parse$default(Companion companion, String string, String string2, String string3, Log log, int n, Object object) {
            if ((n & 4) != 0) {
                string3 = RelKeyStrategy.DEFAULT.toString();
            }
            if ((n & 8) != 0) {
                log = null;
            }
            return companion.parse(string, string2, string3, log);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Map<String, StreamsTransactionEvent> prepareEvent(@NotNull StreamsTransactionEvent streamsTransactionEvent, @NotNull List<RelationshipRoutingConfiguration> routingConf) {
            void $this$associateByTo$iv$iv;
            Object object;
            void $this$mapTo$iv$iv;
            RelationshipRoutingConfiguration it;
            Iterable $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)streamsTransactionEvent, (String)"streamsTransactionEvent");
            Intrinsics.checkNotNullParameter(routingConf, (String)"routingConf");
            Iterable $this$filter$iv = routingConf;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (RelationshipRoutingConfiguration)element$iv$iv;
                boolean bl = false;
                CharSequence charSequence = it.getName();
                if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence) || RoutingConfigurationKt.access$isRelationshipType(it.getName(), streamsTransactionEvent))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                RelationshipChange relationshipChange;
                RelationshipChange newRecordBefore;
                it = (RelationshipRoutingConfiguration)item$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                Payload payload = streamsTransactionEvent.getPayload();
                Intrinsics.checkNotNull((Object)payload, (String)"null cannot be cast to non-null type apoc.kafka.events.RelationshipPayload");
                RelationshipPayload relationshipPayload = (RelationshipPayload)payload;
                if (relationshipPayload.getBefore() != null) {
                    RelationshipChange recordBefore;
                    Intrinsics.checkNotNull((Object)relationshipPayload.getBefore(), (String)"null cannot be cast to non-null type apoc.kafka.events.RelationshipChange");
                    RelationshipChange relationshipChange2 = ((RelationshipPayload)streamsTransactionEvent.getPayload()).getBefore();
                    v2 = recordBefore.copy(RoutingConfigurationKt.access$filterProperties(relationshipChange2 != null ? relationshipChange2.getProperties() : null, it));
                } else {
                    v2 = newRecordBefore = null;
                }
                if (relationshipPayload.getAfter() != null) {
                    RelationshipChange recordAfter;
                    Intrinsics.checkNotNull((Object)relationshipPayload.getAfter(), (String)"null cannot be cast to non-null type apoc.kafka.events.RelationshipChange");
                    RelationshipChange relationshipChange3 = ((RelationshipPayload)streamsTransactionEvent.getPayload()).getAfter();
                    relationshipChange = recordAfter.copy(RoutingConfigurationKt.access$filterProperties(relationshipChange3 != null ? relationshipChange3.getProperties() : null, it));
                } else {
                    relationshipChange = null;
                }
                RelationshipChange newRecordAfter = relationshipChange;
                RelationshipPayload newRelationshipPayload = RelationshipPayload.copy$default(relationshipPayload, relationshipPayload.getId(), null, null, newRecordBefore, newRecordAfter, relationshipPayload.getLabel(), null, 70, null);
                Schema schema = streamsTransactionEvent.getSchema();
                Meta meta = streamsTransactionEvent.getMeta();
                StreamsTransactionEvent newStreamsEvent = streamsTransactionEvent.copy(meta, newRelationshipPayload, schema);
                object.add(TuplesKt.to((Object)it.getTopic(), (Object)newStreamsEvent));
            }
            Iterable $this$associateBy$iv = (List)destination$iv$iv;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            destination$iv$iv = $this$associateBy$iv;
            Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                Pair bl = (Pair)element$iv$iv;
                object = destination$iv$iv2;
                boolean bl2 = false;
                Pair it2 = (Pair)element$iv$iv;
                String string = (String)it2.getFirst();
                boolean bl3 = false;
                StreamsTransactionEvent streamsTransactionEvent2 = (StreamsTransactionEvent)it2.getSecond();
                object.put(string, streamsTransactionEvent2);
            }
            return destination$iv$iv2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

