/*
 * Decompiled with CFR 0.152.
 */
package apoc.kafka.producer;

import apoc.kafka.PublishProcedures;
import apoc.kafka.extensions.GraphDatabaseServerExtensionsKt;
import apoc.kafka.producer.StreamsEventRouterConfiguration;
import apoc.kafka.producer.kafka.KafkaConfiguration;
import apoc.kafka.producer.kafka.KafkaEventRouter;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.Log;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\r\u001a\u00020\u000eJ\u001a\u0010\u000f\u001a\u00020\u000e2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lapoc/kafka/producer/StreamsRouterConfigurationListener;", "", "db", "Lorg/neo4j/kernel/internal/GraphDatabaseAPI;", "log", "Lorg/neo4j/logging/Log;", "(Lorg/neo4j/kernel/internal/GraphDatabaseAPI;Lorg/neo4j/logging/Log;)V", "lastConfig", "Lapoc/kafka/producer/kafka/KafkaConfiguration;", "streamsEventRouter", "Lapoc/kafka/producer/kafka/KafkaEventRouter;", "streamsEventRouterConfiguration", "Lapoc/kafka/producer/StreamsEventRouterConfiguration;", "shutdown", "", "start", "configMap", "", "", "apoc"})
public final class StreamsRouterConfigurationListener {
    @NotNull
    private final GraphDatabaseAPI db;
    @NotNull
    private final Log log;
    @Nullable
    private KafkaEventRouter streamsEventRouter;
    @Nullable
    private StreamsEventRouterConfiguration streamsEventRouterConfiguration;
    @Nullable
    private KafkaConfiguration lastConfig;

    public StreamsRouterConfigurationListener(@NotNull GraphDatabaseAPI db, @NotNull Log log) {
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        this.db = db;
        this.log = log;
    }

    public final void shutdown() {
        StreamsEventRouterConfiguration streamsEventRouterConfiguration = this.streamsEventRouterConfiguration;
        boolean bl = streamsEventRouterConfiguration != null ? streamsEventRouterConfiguration.getEnabled() : false;
        if (bl) {
            KafkaEventRouter kafkaEventRouter = this.streamsEventRouter;
            if (kafkaEventRouter != null) {
                kafkaEventRouter.stop();
            }
            this.streamsEventRouter = null;
            PublishProcedures.Companion.unregister(this.db);
        }
    }

    public final void start(@NotNull Map<String, String> configMap) {
        block4: {
            block3: {
                Intrinsics.checkNotNullParameter(configMap, (String)"configMap");
                this.lastConfig = KafkaConfiguration.Companion.create(configMap);
                String string = this.db.databaseName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"databaseName(...)");
                this.streamsEventRouterConfiguration = StreamsEventRouterConfiguration.Companion.from(configMap, string, GraphDatabaseServerExtensionsKt.isDefaultDb((GraphDatabaseService)this.db), this.log);
                this.streamsEventRouter = new KafkaEventRouter(configMap, (GraphDatabaseService)this.db, this.log);
                StreamsEventRouterConfiguration streamsEventRouterConfiguration = this.streamsEventRouterConfiguration;
                if (streamsEventRouterConfiguration != null ? streamsEventRouterConfiguration.getEnabled() : false) break block3;
                StreamsEventRouterConfiguration streamsEventRouterConfiguration2 = this.streamsEventRouterConfiguration;
                boolean bl = streamsEventRouterConfiguration2 != null ? streamsEventRouterConfiguration2.getProceduresEnabled() : false;
                if (!bl) break block4;
            }
            KafkaEventRouter kafkaEventRouter = this.streamsEventRouter;
            Intrinsics.checkNotNull((Object)kafkaEventRouter);
            kafkaEventRouter.start();
        }
        KafkaEventRouter kafkaEventRouter = this.streamsEventRouter;
        Intrinsics.checkNotNull((Object)kafkaEventRouter);
        PublishProcedures.Companion.register(this.db, kafkaEventRouter);
        this.log.info("[Source] Streams Source module initialised");
    }
}

