/*
 * Decompiled with CFR 0.152.
 */
package apoc.kafka.service.errors;

import apoc.kafka.extensions.CommonExtensionsKt;
import apoc.kafka.utils.JSONUtils;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u001a\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0086\b\u0018\u0000 22\u00020\u0001:\u00012Be\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0001\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0001\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0005\u0012\f\u0010\u000b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u0003\u0012\u000e\u0010\u000e\u001a\n\u0018\u00010\u000fj\u0004\u0018\u0001`\u0010\u00a2\u0006\u0002\u0010\u0011Ba\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0012\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0012\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u0003\u0012\f\u0010\u000b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u0003\u0012\u000e\u0010\u000e\u001a\n\u0018\u00010\u000fj\u0004\u0018\u0001`\u0010\u00a2\u0006\u0002\u0010\u0013J\t\u0010\"\u001a\u00020\u0003H\u00c6\u0003J\t\u0010#\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010$\u001a\u0004\u0018\u00010\u0012H\u00c6\u0003J\u000b\u0010%\u001a\u0004\u0018\u00010\u0012H\u00c6\u0003J\t\u0010&\u001a\u00020\u0003H\u00c6\u0003J\t\u0010'\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010(\u001a\b\u0012\u0002\b\u0003\u0018\u00010\fH\u00c6\u0003J\u000b\u0010)\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0011\u0010*\u001a\n\u0018\u00010\u000fj\u0004\u0018\u0001`\u0010H\u00c6\u0003Jw\u0010+\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00122\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00122\b\b\u0002\u0010\b\u001a\u00020\u00032\b\b\u0002\u0010\n\u001a\u00020\u00032\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u00032\u0010\b\u0002\u0010\u000e\u001a\n\u0018\u00010\u000fj\u0004\u0018\u0001`\u0010H\u00c6\u0001J\u0013\u0010,\u001a\u00020-2\b\u0010.\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010/\u001a\u00020\tH\u00d6\u0001J\u0006\u00100\u001a\u00020\u0003J\t\u00101\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\r\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0019\u0010\u000e\u001a\n\u0018\u00010\u000fj\u0004\u0018\u0001`\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0017\u0010\u000b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0015R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0015R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001b\u00a8\u00063"}, d2={"Lapoc/kafka/service/errors/ErrorData;", "", "originalTopic", "", "timestamp", "", "key", "value", "partition", "", "offset", "executingClass", "Ljava/lang/Class;", "databaseName", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "(Ljava/lang/String;Ljava/lang/Long;Ljava/lang/Object;Ljava/lang/Object;IJLjava/lang/Class;Ljava/lang/String;Ljava/lang/Exception;)V", "", "(Ljava/lang/String;J[B[BLjava/lang/String;Ljava/lang/String;Ljava/lang/Class;Ljava/lang/String;Ljava/lang/Exception;)V", "getDatabaseName", "()Ljava/lang/String;", "getException", "()Ljava/lang/Exception;", "getExecutingClass", "()Ljava/lang/Class;", "getKey", "()[B", "getOffset", "getOriginalTopic", "getPartition", "getTimestamp", "()J", "getValue", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "", "other", "hashCode", "toLogString", "toString", "Companion", "apoc"})
public final class ErrorData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String originalTopic;
    private final long timestamp;
    @Nullable
    private final byte[] key;
    @Nullable
    private final byte[] value;
    @NotNull
    private final String partition;
    @NotNull
    private final String offset;
    @Nullable
    private final Class<?> executingClass;
    @Nullable
    private final String databaseName;
    @Nullable
    private final Exception exception;

    public ErrorData(@NotNull String originalTopic, long timestamp, @Nullable byte[] key, @Nullable byte[] value, @NotNull String partition, @NotNull String offset, @Nullable Class<?> executingClass, @Nullable String databaseName, @Nullable Exception exception) {
        Intrinsics.checkNotNullParameter((Object)originalTopic, (String)"originalTopic");
        Intrinsics.checkNotNullParameter((Object)partition, (String)"partition");
        Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
        this.originalTopic = originalTopic;
        this.timestamp = timestamp;
        this.key = key;
        this.value = value;
        this.partition = partition;
        this.offset = offset;
        this.executingClass = executingClass;
        this.databaseName = databaseName;
        this.exception = exception;
    }

    @NotNull
    public final String getOriginalTopic() {
        return this.originalTopic;
    }

    public final long getTimestamp() {
        return this.timestamp;
    }

    @Nullable
    public final byte[] getKey() {
        return this.key;
    }

    @Nullable
    public final byte[] getValue() {
        return this.value;
    }

    @NotNull
    public final String getPartition() {
        return this.partition;
    }

    @NotNull
    public final String getOffset() {
        return this.offset;
    }

    @Nullable
    public final Class<?> getExecutingClass() {
        return this.executingClass;
    }

    @Nullable
    public final String getDatabaseName() {
        return this.databaseName;
    }

    @Nullable
    public final Exception getException() {
        return this.exception;
    }

    public ErrorData(@NotNull String originalTopic, @Nullable Long timestamp, @Nullable Object key, @Nullable Object value, int partition, long offset, @Nullable Class<?> executingClass, @Nullable String databaseName, @Nullable Exception exception) {
        Intrinsics.checkNotNullParameter((Object)originalTopic, (String)"originalTopic");
        Long l = timestamp;
        this(originalTopic, l != null ? l : -1L, Companion.toByteArray(key), Companion.toByteArray(value), String.valueOf(partition), String.valueOf(offset), executingClass, databaseName, exception);
    }

    @NotNull
    public final String toLogString() {
        byte[] byArray;
        byte[] byArray2 = this.key;
        String string = byArray2 != null ? new String(byArray2, Charsets.UTF_8) : null;
        byArray2 = this.value;
        return StringsKt.trimIndent((String)("\nErrorData(originalTopic=" + this.originalTopic + ", timestamp=" + this.timestamp + ", partition=" + this.partition + ", offset=" + this.offset + ", exception=" + this.exception + ", key=" + string + ", value=" + (byArray2 != null && (byArray = ArraysKt.sliceArray((byte[])byArray2, (IntRange)new IntRange(0, Math.min(this.value.length, 200) - 1))) != null ? new String(byArray, Charsets.UTF_8) : null) + ", executingClass=" + this.executingClass + ")\n    "));
    }

    @NotNull
    public final String component1() {
        return this.originalTopic;
    }

    public final long component2() {
        return this.timestamp;
    }

    @Nullable
    public final byte[] component3() {
        return this.key;
    }

    @Nullable
    public final byte[] component4() {
        return this.value;
    }

    @NotNull
    public final String component5() {
        return this.partition;
    }

    @NotNull
    public final String component6() {
        return this.offset;
    }

    @Nullable
    public final Class<?> component7() {
        return this.executingClass;
    }

    @Nullable
    public final String component8() {
        return this.databaseName;
    }

    @Nullable
    public final Exception component9() {
        return this.exception;
    }

    @NotNull
    public final ErrorData copy(@NotNull String originalTopic, long timestamp, @Nullable byte[] key, @Nullable byte[] value, @NotNull String partition, @NotNull String offset, @Nullable Class<?> executingClass, @Nullable String databaseName, @Nullable Exception exception) {
        Intrinsics.checkNotNullParameter((Object)originalTopic, (String)"originalTopic");
        Intrinsics.checkNotNullParameter((Object)partition, (String)"partition");
        Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
        return new ErrorData(originalTopic, timestamp, key, value, partition, offset, executingClass, databaseName, exception);
    }

    public static /* synthetic */ ErrorData copy$default(ErrorData errorData, String string, long l, byte[] byArray, byte[] byArray2, String string2, String string3, Class clazz, String string4, Exception exception, int n, Object object) {
        if ((n & 1) != 0) {
            string = errorData.originalTopic;
        }
        if ((n & 2) != 0) {
            l = errorData.timestamp;
        }
        if ((n & 4) != 0) {
            byArray = errorData.key;
        }
        if ((n & 8) != 0) {
            byArray2 = errorData.value;
        }
        if ((n & 0x10) != 0) {
            string2 = errorData.partition;
        }
        if ((n & 0x20) != 0) {
            string3 = errorData.offset;
        }
        if ((n & 0x40) != 0) {
            clazz = errorData.executingClass;
        }
        if ((n & 0x80) != 0) {
            string4 = errorData.databaseName;
        }
        if ((n & 0x100) != 0) {
            exception = errorData.exception;
        }
        return errorData.copy(string, l, byArray, byArray2, string2, string3, clazz, string4, exception);
    }

    @NotNull
    public String toString() {
        return "ErrorData(originalTopic=" + this.originalTopic + ", timestamp=" + this.timestamp + ", key=" + Arrays.toString(this.key) + ", value=" + Arrays.toString(this.value) + ", partition=" + this.partition + ", offset=" + this.offset + ", executingClass=" + this.executingClass + ", databaseName=" + this.databaseName + ", exception=" + this.exception + ")";
    }

    public int hashCode() {
        int result = this.originalTopic.hashCode();
        result = result * 31 + Long.hashCode(this.timestamp);
        result = result * 31 + (this.key == null ? 0 : Arrays.hashCode(this.key));
        result = result * 31 + (this.value == null ? 0 : Arrays.hashCode(this.value));
        result = result * 31 + this.partition.hashCode();
        result = result * 31 + this.offset.hashCode();
        result = result * 31 + (this.executingClass == null ? 0 : this.executingClass.hashCode());
        result = result * 31 + (this.databaseName == null ? 0 : this.databaseName.hashCode());
        result = result * 31 + (this.exception == null ? 0 : this.exception.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ErrorData)) {
            return false;
        }
        ErrorData errorData = (ErrorData)other;
        if (!Intrinsics.areEqual((Object)this.originalTopic, (Object)errorData.originalTopic)) {
            return false;
        }
        if (this.timestamp != errorData.timestamp) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.key, (Object)errorData.key)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.value, (Object)errorData.value)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.partition, (Object)errorData.partition)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.offset, (Object)errorData.offset)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.executingClass, errorData.executingClass)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.databaseName, (Object)errorData.databaseName)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.exception, (Object)errorData.exception);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JF\u0010\u0003\u001a\u00020\u00042\u0016\u0010\u0005\u001a\u0012\u0012\u0006\b\u0001\u0012\u00020\u0001\u0012\u0006\b\u0001\u0012\u00020\u00010\u00062\u000e\u0010\u0007\u001a\n\u0018\u00010\bj\u0004\u0018\u0001`\t2\f\u0010\n\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001\u00a8\u0006\u0011"}, d2={"Lapoc/kafka/service/errors/ErrorData$Companion;", "", "()V", "from", "Lapoc/kafka/service/errors/ErrorData;", "consumerRecord", "Lorg/apache/kafka/clients/consumer/ConsumerRecord;", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "executingClass", "Ljava/lang/Class;", "databaseName", "", "toByteArray", "", "v", "apoc"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ErrorData from(@NotNull ConsumerRecord<? extends Object, ? extends Object> consumerRecord, @Nullable Exception exception, @Nullable Class<?> executingClass, @Nullable String databaseName) {
            Intrinsics.checkNotNullParameter(consumerRecord, (String)"consumerRecord");
            String string = String.valueOf(consumerRecord.offset());
            String string2 = consumerRecord.topic();
            String string3 = String.valueOf(consumerRecord.partition());
            long l = consumerRecord.timestamp();
            byte[] byArray = this.toByteArray(consumerRecord.key());
            byte[] byArray2 = this.toByteArray(consumerRecord.value());
            Intrinsics.checkNotNull((Object)string2);
            return new ErrorData(string2, l, byArray, byArray2, string3, string, executingClass, databaseName, exception);
        }

        @Nullable
        public final byte[] toByteArray(@Nullable Object v) {
            Object object;
            try {
                byte[] byArray;
                object = v;
                if (object == null) {
                    byArray = null;
                } else if (object instanceof byte[]) {
                    byArray = (byte[])v;
                } else if (object instanceof GenericRecord) {
                    Pair[] pairArray = new Pair[2];
                    Schema schema = ((GenericRecord)v).getSchema();
                    Intrinsics.checkNotNullExpressionValue((Object)schema, (String)"getSchema(...)");
                    pairArray[0] = TuplesKt.to((Object)"schema", CommonExtensionsKt.toMap(schema));
                    pairArray[1] = TuplesKt.to((Object)"record", CommonExtensionsKt.toMap((IndexedRecord)v));
                    byArray = JSONUtils.INSTANCE.writeValueAsBytes(MapsKt.mapOf((Pair[])pairArray));
                } else {
                    byte[] byArray2 = v.toString().getBytes(Charsets.UTF_8);
                    byArray = byArray2;
                    Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
                }
                object = byArray;
            }
            catch (Exception e) {
                object = null;
            }
            return object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

