/*
 * Decompiled with CFR 0.152.
 */
package apoc.kafka.service.sink.strategy;

import apoc.kafka.service.sink.strategy.NodePatternConfiguration;
import apoc.kafka.service.sink.strategy.PatternConfiguration;
import apoc.kafka.service.sink.strategy.PatternConfigurationKt;
import apoc.kafka.service.sink.strategy.PatternConfigurationType;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \"2\u00020\u0001:\u0001\"B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\n\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\bH\u00c6\u0003J\u000f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00060\nH\u00c6\u0003JA\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\nH\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u00d6\u0003J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001J\t\u0010!\u001a\u00020\u0006H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006#"}, d2={"Lapoc/kafka/service/sink/strategy/RelationshipPatternConfiguration;", "Lapoc/kafka/service/sink/strategy/PatternConfiguration;", "start", "Lapoc/kafka/service/sink/strategy/NodePatternConfiguration;", "end", "relType", "", "type", "Lapoc/kafka/service/sink/strategy/PatternConfigurationType;", "properties", "", "(Lapoc/kafka/service/sink/strategy/NodePatternConfiguration;Lapoc/kafka/service/sink/strategy/NodePatternConfiguration;Ljava/lang/String;Lapoc/kafka/service/sink/strategy/PatternConfigurationType;Ljava/util/List;)V", "getEnd", "()Lapoc/kafka/service/sink/strategy/NodePatternConfiguration;", "getProperties", "()Ljava/util/List;", "getRelType", "()Ljava/lang/String;", "getStart", "getType", "()Lapoc/kafka/service/sink/strategy/PatternConfigurationType;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "", "hashCode", "", "toString", "Companion", "apoc"})
public final class RelationshipPatternConfiguration
implements PatternConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final NodePatternConfiguration start;
    @NotNull
    private final NodePatternConfiguration end;
    @NotNull
    private final String relType;
    @NotNull
    private final PatternConfigurationType type;
    @NotNull
    private final List<String> properties;
    @NotNull
    private static final Regex cypherRelationshipPatternConfigured = new Regex("^\\(:(.*?)\\)(<)?-\\[(?::)([\\w\\_]+)(\\{\\s*(-?[\\w\\*\\.]+\\s*(?:,\\s*-?[\\w\\*\\.]+\\s*)*)\\})?\\]-(>)?\\(:(.*?)\\)$");
    @NotNull
    private static final Regex simpleRelationshipPatternConfigured = new Regex("^(.*?) ([\\w\\_]+)(\\{\\s*(-?[\\w\\*\\.]+\\s*(?:,\\s*-?[\\w\\*\\.]+\\s*)*)\\})? (.*?)$");

    public RelationshipPatternConfiguration(@NotNull NodePatternConfiguration start2, @NotNull NodePatternConfiguration end, @NotNull String relType, @NotNull PatternConfigurationType type, @NotNull List<String> properties) {
        Intrinsics.checkNotNullParameter((Object)start2, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        Intrinsics.checkNotNullParameter((Object)relType, (String)"relType");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter(properties, (String)"properties");
        this.start = start2;
        this.end = end;
        this.relType = relType;
        this.type = type;
        this.properties = properties;
    }

    @NotNull
    public final NodePatternConfiguration getStart() {
        return this.start;
    }

    @NotNull
    public final NodePatternConfiguration getEnd() {
        return this.end;
    }

    @NotNull
    public final String getRelType() {
        return this.relType;
    }

    @NotNull
    public final PatternConfigurationType getType() {
        return this.type;
    }

    @NotNull
    public final List<String> getProperties() {
        return this.properties;
    }

    @NotNull
    public final NodePatternConfiguration component1() {
        return this.start;
    }

    @NotNull
    public final NodePatternConfiguration component2() {
        return this.end;
    }

    @NotNull
    public final String component3() {
        return this.relType;
    }

    @NotNull
    public final PatternConfigurationType component4() {
        return this.type;
    }

    @NotNull
    public final List<String> component5() {
        return this.properties;
    }

    @NotNull
    public final RelationshipPatternConfiguration copy(@NotNull NodePatternConfiguration start2, @NotNull NodePatternConfiguration end, @NotNull String relType, @NotNull PatternConfigurationType type, @NotNull List<String> properties) {
        Intrinsics.checkNotNullParameter((Object)start2, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        Intrinsics.checkNotNullParameter((Object)relType, (String)"relType");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter(properties, (String)"properties");
        return new RelationshipPatternConfiguration(start2, end, relType, type, properties);
    }

    public static /* synthetic */ RelationshipPatternConfiguration copy$default(RelationshipPatternConfiguration relationshipPatternConfiguration, NodePatternConfiguration nodePatternConfiguration, NodePatternConfiguration nodePatternConfiguration2, String string, PatternConfigurationType patternConfigurationType, List list, int n, Object object) {
        if ((n & 1) != 0) {
            nodePatternConfiguration = relationshipPatternConfiguration.start;
        }
        if ((n & 2) != 0) {
            nodePatternConfiguration2 = relationshipPatternConfiguration.end;
        }
        if ((n & 4) != 0) {
            string = relationshipPatternConfiguration.relType;
        }
        if ((n & 8) != 0) {
            patternConfigurationType = relationshipPatternConfiguration.type;
        }
        if ((n & 0x10) != 0) {
            list = relationshipPatternConfiguration.properties;
        }
        return relationshipPatternConfiguration.copy(nodePatternConfiguration, nodePatternConfiguration2, string, patternConfigurationType, list);
    }

    @NotNull
    public String toString() {
        return "RelationshipPatternConfiguration(start=" + this.start + ", end=" + this.end + ", relType=" + this.relType + ", type=" + this.type + ", properties=" + this.properties + ")";
    }

    public int hashCode() {
        int result = this.start.hashCode();
        result = result * 31 + this.end.hashCode();
        result = result * 31 + this.relType.hashCode();
        result = result * 31 + this.type.hashCode();
        result = result * 31 + ((Object)this.properties).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RelationshipPatternConfiguration)) {
            return false;
        }
        RelationshipPatternConfiguration relationshipPatternConfiguration = (RelationshipPatternConfiguration)other;
        if (!Intrinsics.areEqual((Object)this.start, (Object)relationshipPatternConfiguration.start)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.end, (Object)relationshipPatternConfiguration.end)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.relType, (Object)relationshipPatternConfiguration.relType)) {
            return false;
        }
        if (this.type != relationshipPatternConfiguration.type) {
            return false;
        }
        return Intrinsics.areEqual(this.properties, relationshipPatternConfiguration.properties);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0012B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lapoc/kafka/service/sink/strategy/RelationshipPatternConfiguration$Companion;", "", "()V", "cypherRelationshipPatternConfigured", "Lkotlin/text/Regex;", "simpleRelationshipPatternConfigured", "getNodeConf", "Lapoc/kafka/service/sink/strategy/NodePatternConfiguration;", "pattern", "", "isDirectedToLeft", "", "matcher", "Lkotlin/text/MatchResult;", "isDirectedToRight", "isUndirected", "parse", "Lapoc/kafka/service/sink/strategy/RelationshipPatternConfiguration;", "RelationshipPatternMetaData", "apoc"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final NodePatternConfiguration getNodeConf(@NotNull String pattern) {
            Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
            NodePatternConfiguration start2 = NodePatternConfiguration.Companion.parse(pattern);
            return start2.getType() == PatternConfigurationType.ALL ? new NodePatternConfiguration(start2.getKeys(), PatternConfigurationType.INCLUDE, start2.getLabels(), start2.getProperties()) : start2;
        }

        @NotNull
        public final RelationshipPatternConfiguration parse(@NotNull String pattern) {
            NodePatternConfiguration e2;
            NodePatternConfiguration nodePatternConfiguration;
            boolean isRightToLeft;
            Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
            boolean isCypherPattern = StringsKt.startsWith$default((String)pattern, (String)"(", (boolean)false, (int)2, null);
            Regex regex = isCypherPattern ? cypherRelationshipPatternConfigured : simpleRelationshipPatternConfigured;
            MatchResult matcher = regex.matchEntire((CharSequence)pattern);
            if (matcher == null) {
                throw new IllegalArgumentException("The Relationship pattern " + pattern + " is invalid");
            }
            boolean isLeftToRight = !isCypherPattern || this.isUndirected(matcher) || this.isDirectedToRight(matcher);
            boolean bl = isRightToLeft = isCypherPattern ? this.isDirectedToLeft(matcher) : false;
            if (!isLeftToRight && !isRightToLeft) {
                throw new IllegalArgumentException("The Relationship pattern " + pattern + " has an invalid direction");
            }
            RelationshipPatternMetaData metadata = RelationshipPatternMetaData.Companion.create(isCypherPattern, isLeftToRight, matcher.getGroupValues());
            try {
                nodePatternConfiguration = this.getNodeConf(metadata.getStartPattern());
            }
            catch (Exception e2) {
                throw new IllegalArgumentException("The Relationship pattern " + pattern + " is invalid");
            }
            NodePatternConfiguration start2 = nodePatternConfiguration;
            try {
                e2 = this.getNodeConf(metadata.getEndPattern());
            }
            catch (Exception e3) {
                throw new IllegalArgumentException("The Relationship pattern " + pattern + " is invalid");
            }
            NodePatternConfiguration end = e2;
            PatternConfigurationType type = PatternConfigurationKt.access$getPatternConfiguredType(metadata.getProperties());
            PatternConfigurationKt.access$isHomogeneousPattern(type, metadata.getProperties(), pattern, "Relationship");
            List cleanedProperties = PatternConfigurationKt.access$cleanProperties(type, metadata.getProperties());
            String string = metadata.getRelType();
            return new RelationshipPatternConfiguration(start2, end, string, type, cleanedProperties);
        }

        private final boolean isDirectedToLeft(MatchResult matcher) {
            return Intrinsics.areEqual(matcher.getGroupValues().get(2), (Object)"<") && Intrinsics.areEqual(matcher.getGroupValues().get(6), (Object)"");
        }

        private final boolean isDirectedToRight(MatchResult matcher) {
            return Intrinsics.areEqual(matcher.getGroupValues().get(2), (Object)"") && Intrinsics.areEqual(matcher.getGroupValues().get(6), (Object)">");
        }

        private final boolean isUndirected(MatchResult matcher) {
            return Intrinsics.areEqual(matcher.getGroupValues().get(2), (Object)"") && Intrinsics.areEqual(matcher.getGroupValues().get(6), (Object)"");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007H\u00c6\u0003J7\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\n\u00a8\u0006\u001b"}, d2={"Lapoc/kafka/service/sink/strategy/RelationshipPatternConfiguration$Companion$RelationshipPatternMetaData;", "", "startPattern", "", "endPattern", "relType", "properties", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;)V", "getEndPattern", "()Ljava/lang/String;", "getProperties", "()Ljava/util/List;", "getRelType", "getStartPattern", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "apoc"})
        public static final class RelationshipPatternMetaData {
            @NotNull
            public static final Companion Companion = new Companion(null);
            @NotNull
            private final String startPattern;
            @NotNull
            private final String endPattern;
            @NotNull
            private final String relType;
            @NotNull
            private final List<String> properties;

            public RelationshipPatternMetaData(@NotNull String startPattern, @NotNull String endPattern, @NotNull String relType, @NotNull List<String> properties) {
                Intrinsics.checkNotNullParameter((Object)startPattern, (String)"startPattern");
                Intrinsics.checkNotNullParameter((Object)endPattern, (String)"endPattern");
                Intrinsics.checkNotNullParameter((Object)relType, (String)"relType");
                Intrinsics.checkNotNullParameter(properties, (String)"properties");
                this.startPattern = startPattern;
                this.endPattern = endPattern;
                this.relType = relType;
                this.properties = properties;
            }

            @NotNull
            public final String getStartPattern() {
                return this.startPattern;
            }

            @NotNull
            public final String getEndPattern() {
                return this.endPattern;
            }

            @NotNull
            public final String getRelType() {
                return this.relType;
            }

            @NotNull
            public final List<String> getProperties() {
                return this.properties;
            }

            @NotNull
            public final String component1() {
                return this.startPattern;
            }

            @NotNull
            public final String component2() {
                return this.endPattern;
            }

            @NotNull
            public final String component3() {
                return this.relType;
            }

            @NotNull
            public final List<String> component4() {
                return this.properties;
            }

            @NotNull
            public final RelationshipPatternMetaData copy(@NotNull String startPattern, @NotNull String endPattern, @NotNull String relType, @NotNull List<String> properties) {
                Intrinsics.checkNotNullParameter((Object)startPattern, (String)"startPattern");
                Intrinsics.checkNotNullParameter((Object)endPattern, (String)"endPattern");
                Intrinsics.checkNotNullParameter((Object)relType, (String)"relType");
                Intrinsics.checkNotNullParameter(properties, (String)"properties");
                return new RelationshipPatternMetaData(startPattern, endPattern, relType, properties);
            }

            public static /* synthetic */ RelationshipPatternMetaData copy$default(RelationshipPatternMetaData relationshipPatternMetaData, String string, String string2, String string3, List list, int n, Object object) {
                if ((n & 1) != 0) {
                    string = relationshipPatternMetaData.startPattern;
                }
                if ((n & 2) != 0) {
                    string2 = relationshipPatternMetaData.endPattern;
                }
                if ((n & 4) != 0) {
                    string3 = relationshipPatternMetaData.relType;
                }
                if ((n & 8) != 0) {
                    list = relationshipPatternMetaData.properties;
                }
                return relationshipPatternMetaData.copy(string, string2, string3, list);
            }

            @NotNull
            public String toString() {
                return "RelationshipPatternMetaData(startPattern=" + this.startPattern + ", endPattern=" + this.endPattern + ", relType=" + this.relType + ", properties=" + this.properties + ")";
            }

            public int hashCode() {
                int result = this.startPattern.hashCode();
                result = result * 31 + this.endPattern.hashCode();
                result = result * 31 + this.relType.hashCode();
                result = result * 31 + ((Object)this.properties).hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof RelationshipPatternMetaData)) {
                    return false;
                }
                RelationshipPatternMetaData relationshipPatternMetaData = (RelationshipPatternMetaData)other;
                if (!Intrinsics.areEqual((Object)this.startPattern, (Object)relationshipPatternMetaData.startPattern)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.endPattern, (Object)relationshipPatternMetaData.endPattern)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.relType, (Object)relationshipPatternMetaData.relType)) {
                    return false;
                }
                return Intrinsics.areEqual(this.properties, relationshipPatternMetaData.properties);
            }

            @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\f\u001a\u00020\nH\u0002\u00a8\u0006\r"}, d2={"Lapoc/kafka/service/sink/strategy/RelationshipPatternConfiguration$Companion$RelationshipPatternMetaData$Companion;", "", "()V", "create", "Lapoc/kafka/service/sink/strategy/RelationshipPatternConfiguration$Companion$RelationshipPatternMetaData;", "isCypherPattern", "", "isLeftToRight", "groupValues", "", "", "toProperties", "propGroup", "apoc"})
            public static final class Companion {
                private Companion() {
                }

                private final List<String> toProperties(String propGroup) {
                    List list;
                    String[] stringArray = (String[])propGroup;
                    if (stringArray == null || StringsKt.isBlank((CharSequence)stringArray)) {
                        list = CollectionsKt.emptyList();
                    } else {
                        stringArray = new String[]{","};
                        list = StringsKt.split$default((CharSequence)propGroup, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                    }
                    return list;
                }

                @NotNull
                public final RelationshipPatternMetaData create(boolean isCypherPattern, boolean isLeftToRight, @NotNull List<String> groupValues) {
                    List<String> list;
                    String string;
                    String string2;
                    String string3;
                    Intrinsics.checkNotNullParameter(groupValues, (String)"groupValues");
                    String start2 = null;
                    String end = null;
                    String relType = null;
                    List<String> props = null;
                    if (isCypherPattern) {
                        if (isLeftToRight) {
                            start2 = groupValues.get(1);
                            end = groupValues.get(7);
                        } else {
                            start2 = groupValues.get(7);
                            end = groupValues.get(1);
                        }
                        relType = groupValues.get(3);
                        props = this.toProperties(groupValues.get(5));
                    } else {
                        if (isLeftToRight) {
                            start2 = groupValues.get(1);
                            end = groupValues.get(5);
                        } else {
                            start2 = groupValues.get(5);
                            end = groupValues.get(1);
                        }
                        relType = groupValues.get(2);
                        props = this.toProperties(groupValues.get(4));
                    }
                    if ((string3 = start2) == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"start");
                        string3 = null;
                    }
                    if ((string2 = end) == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"end");
                        string2 = null;
                    }
                    if ((string = relType) == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"relType");
                        string = null;
                    }
                    if ((list = props) == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"props");
                        list = null;
                    }
                    return new RelationshipPatternMetaData(string3, string2, string, list);
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }
    }
}

