/*
 * Decompiled with CFR 0.152.
 */
package apoc.kafka.utils;

import apoc.ApocConfig;
import apoc.kafka.events.Constraint;
import apoc.kafka.events.RelKeyStrategy;
import apoc.kafka.events.StreamsConstraintType;
import apoc.kafka.events.StreamsTransactionEvent;
import apoc.kafka.extensions.CommonExtensionsKt;
import apoc.kafka.extensions.GraphDatabaseServerExtensionsKt;
import apoc.kafka.service.StreamsSinkEntity;
import apoc.kafka.utils.JSONUtils;
import apoc.kafka.utils.KafkaUtil;
import apoc.util.Util;
import java.io.Closeable;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.Socket;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.GlobalScope;
import org.apache.kafka.clients.CommonClientConfigs;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.AdminClientConfig;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.clients.producer.ProducerConfig;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.config.SaslConfigs;
import org.apache.kafka.common.config.SslConfigs;
import org.apache.kafka.common.config.TopicConfig;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.dbms.systemgraph.TopologyGraphDbmsModel;
import org.neo4j.exceptions.UnsatisfiedDependencyException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.QueryExecutionException;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.Log;
import org.neo4j.logging.internal.LogService;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00c2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010\u001d\u001a\u00020\u001c2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001a0\u001fJ\u0006\u0010 \u001a\u00020!J\u001e\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00040#2\u0006\u0010$\u001a\u00020\u00042\b\b\u0002\u0010%\u001a\u00020\u0004J\u0010\u0010&\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020(H\u0002J\u000e\u0010)\u001a\u00020\u00042\u0006\u0010'\u001a\u00020(J\u001c\u0010*\u001a\u00020\u001a2\u0006\u0010+\u001a\u00020\u00042\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00040#J+\u0010-\u001a\u0004\u0018\u0001H.\"\u0004\b\u0000\u0010.2\u0006\u0010'\u001a\u00020(2\u000e\u0010\u001e\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H.0\u001f\u00a2\u0006\u0002\u0010/J=\u00100\u001a\u0002H.\"\u0004\b\u0000\u0010.2\f\u00101\u001a\b\u0012\u0004\u0012\u0002H.0\u001f2\u001a\u00102\u001a\u0016\u0012\f\u0012\n\u0018\u000104j\u0004\u0018\u0001`5\u0012\u0004\u0012\u0002H.03H\u0002\u00a2\u0006\u0002\u00106J\u0016\u00107\u001a\u0010\u0012\f\u0012\n 9*\u0004\u0018\u00010\u00040\u000408H\u0002J\u001a\u0010:\u001a\b\u0012\u0004\u0012\u00020\u0004082\n\u0010;\u001a\u0006\u0012\u0002\b\u00030\u0012H\u0002J\u0014\u0010<\u001a\u0010\u0012\f\u0012\n 9*\u0004\u0018\u00010\u00040\u000408J\"\u0010=\u001a\b\u0012\u0004\u0012\u00020\u00040#2\u0006\u0010>\u001a\u00020?2\f\u0010@\u001a\b\u0012\u0004\u0012\u00020\u00040#J\"\u0010=\u001a\b\u0012\u0004\u0012\u00020\u00040#2\u0006\u0010A\u001a\u00020B2\f\u0010@\u001a\b\u0012\u0004\u0012\u00020\u00040#J\u0014\u0010C\u001a\u00020\u00042\f\u0010D\u001a\b\u0012\u0004\u0012\u00020\u00040#J\u0014\u0010E\u001a\u00020\u00042\f\u0010F\u001a\b\u0012\u0004\u0012\u00020\u00040GJ\u0016\u0010H\u001a\n 9*\u0004\u0018\u00010\u00040\u00042\u0006\u0010'\u001a\u00020IJ@\u0010J\u001a\b\u0012\u0004\u0012\u00020\u0004082\f\u0010F\u001a\b\u0012\u0004\u0012\u00020\u00040#2\f\u0010K\u001a\b\u0012\u0004\u0012\u00020\u0004082\f\u0010L\u001a\b\u0012\u0004\u0012\u00020M0#2\b\b\u0002\u0010N\u001a\u00020OJ\u001e\u0010P\u001a\u00020\u00042\b\b\u0002\u0010Q\u001a\u00020\u00042\f\u0010R\u001a\b\u0012\u0004\u0012\u00020\u000408J\u001c\u0010S\u001a\u00020\u00042\u0006\u0010Q\u001a\u00020\u00042\f\u0010R\u001a\b\u0012\u0004\u0012\u00020\u000408J\u0014\u0010T\u001a\u0010\u0012\f\u0012\n 9*\u0004\u0018\u00010\u00040\u000408JE\u0010U\u001a\u0004\u0018\u0001H.\"\u0004\b\u0000\u0010.2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H.0\u001f2\"\u0010V\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0001\u0012\u00020X0\u00120W\"\n\u0012\u0006\b\u0001\u0012\u00020X0\u0012\u00a2\u0006\u0002\u0010YJ\u000e\u0010Z\u001a\u00020\u001a2\u0006\u0010>\u001a\u00020?J\u000e\u0010Z\u001a\u00020\u001a2\u0006\u0010A\u001a\u00020BJ\u000e\u0010[\u001a\u00020\u001a2\u0006\u0010\\\u001a\u00020]J\u000e\u0010[\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020(J\u000e\u0010^\u001a\u00020\u001a2\u0006\u0010\\\u001a\u00020]J\u0016\u0010_\u001a\u00020\u001a2\u0006\u0010`\u001a\u00020\u00042\u0006\u0010a\u001a\u00020bJ\u000e\u0010c\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020(JH\u0010d\u001a\u0002H.\"\u0004\b\u0000\u0010.2\u0014\u0010e\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020X0\u00120W2\u0006\u0010f\u001a\u00020b2\u0006\u0010g\u001a\u00020\u001c2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H.0\u001fH\u0086@\u00a2\u0006\u0002\u0010hJ\u001a\u0010i\u001a\u00020\u00042\b\b\u0002\u0010Q\u001a\u00020\u00042\u0006\u0010j\u001a\u00020\u0004H\u0002J$\u0010k\u001a\u0004\u0018\u00010l2\u0006\u0010m\u001a\u00020n2\u0012\u0010o\u001a\u000e\u0012\u0004\u0012\u00020l\u0012\u0004\u0012\u00020\u001a03J \u0010p\u001a\u00020!2\u0006\u0010`\u001a\u00020\u00042\u0006\u0010q\u001a\u00020\u00042\b\b\u0002\u0010r\u001a\u00020\u001aJ.\u0010s\u001a\u00020!2\u0006\u0010\\\u001a\u00020]2\u0006\u0010t\u001a\u00020u2\b\b\u0002\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020!0\u001fR\u001c\u0010\u0003\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007R\u001c\u0010\b\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\t\u0010\u0002\u001a\u0004\b\n\u0010\u0007R\u001c\u0010\u000b\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\f\u0010\u0002\u001a\u0004\b\r\u0010\u0007R\u001c\u0010\u000e\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000f\u0010\u0002\u001a\u0004\b\u0010\u0010\u0007R\u001c\u0010\u0011\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00128\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0013\u0010\u0002R\u0018\u0010\u0014\u001a\u0004\u0018\u00010\u00158\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0016\u0010\u0002R\u000e\u0010\u0017\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006v"}, d2={"Lapoc/kafka/utils/KafkaUtil;", "", "()V", "LEADER", "", "getLEADER$annotations", "getLEADER", "()Ljava/lang/String;", "SYSTEM_DATABASE_NAME", "getSYSTEM_DATABASE_NAME$annotations", "getSYSTEM_DATABASE_NAME", "UNWIND", "getUNWIND$annotations", "getUNWIND", "WITH_EVENT_FROM", "getWITH_EVENT_FROM$annotations", "getWITH_EVENT_FROM", "coreMetadata", "Ljava/lang/Class;", "getCoreMetadata$annotations", "isLeaderMethodHandle", "Ljava/lang/invoke/MethodHandle;", "isLeaderMethodHandle$annotations", "keySeparator", "labelSeparator", "blockUntilFalseOrTimeout", "", "timeout", "", "delay", "action", "Lkotlin/Function0;", "checkEnabled", "", "checkServersUnreachable", "", "urls", "separator", "clusterHasLeader", "db", "Lorg/neo4j/kernel/internal/GraphDatabaseAPI;", "clusterMemberRole", "containsProp", "key", "properties", "executeInWriteableInstance", "T", "(Lorg/neo4j/kernel/internal/GraphDatabaseAPI;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "executeOrFallback", "execute", "fallback", "Lkotlin/Function1;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "getBaseConfigs", "", "kotlin.jvm.PlatformType", "getConfigProperties", "clazz", "getConsumerProperties", "getInvalidTopics", "kafkaProps", "Ljava/util/Properties;", "allTopics", "client", "Lorg/apache/kafka/clients/admin/AdminClient;", "getInvalidTopicsError", "invalidTopics", "getLabelsAsString", "labels", "", "getName", "Lorg/neo4j/graphdb/GraphDatabaseService;", "getNodeKeys", "propertyKeys", "constraints", "Lapoc/kafka/events/Constraint;", "keyStrategy", "Lapoc/kafka/events/RelKeyStrategy;", "getNodeKeysAsString", "prefix", "keys", "getNodeMergeKeys", "getProducerProperties", "ignoreExceptions", "toIgnore", "", "", "(Lkotlin/jvm/functions/Function0;[Ljava/lang/Class;)Ljava/lang/Object;", "isAutoCreateTopicsEnabled", "isCluster", "dbms", "Lorg/neo4j/dbms/api/DatabaseManagementService;", "isClusterCorrectlyFormed", "isServerReachable", "url", "port", "", "isWriteableInstance", "retryForException", "exceptions", "retries", "delayTime", "([Ljava/lang/Class;IJLkotlin/jvm/functions/Function0;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "toQuotedProperty", "property", "toStreamsTransactionEvent", "Lapoc/kafka/events/StreamsTransactionEvent;", "streamsSinkEntity", "Lapoc/kafka/service/StreamsSinkEntity;", "evaluation", "validateConnection", "kafkaPropertyKey", "checkReachable", "waitForTheLeaders", "log", "Lorg/neo4j/logging/Log;", "apoc"})
@SourceDebugExtension(value={"SMAP\nKafkaUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KafkaUtil.kt\napoc/kafka/utils/KafkaUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,341:1\n288#2,2:342\n1549#2:345\n1620#2,3:346\n1549#2:349\n1620#2,3:350\n1549#2:353\n1620#2,3:354\n1747#2,3:357\n1549#2:362\n1620#2,3:363\n766#2:366\n857#2,2:367\n1549#2:369\n1620#2,3:370\n766#2:373\n857#2,2:374\n1360#2:376\n1446#2,5:377\n1549#2:385\n1620#2,3:386\n766#2:389\n857#2,2:390\n1360#2:392\n1446#2,5:393\n819#2:400\n847#2,2:401\n1549#2:403\n1620#2,3:404\n1726#2,3:407\n1#3:344\n12474#4,2:360\n3792#4:382\n4307#4,2:383\n12474#4,2:398\n*S KotlinDebug\n*F\n+ 1 KafkaUtil.kt\napoc/kafka/utils/KafkaUtil\n*L\n96#1:342,2\n107#1:345\n107#1:346,3\n112#1:349\n112#1:350,3\n121#1:353\n121#1:354,3\n128#1:357,3\n155#1:362\n155#1:363,3\n166#1:366\n166#1:367,2\n167#1:369\n167#1:370,3\n190#1:373\n190#1:374,2\n217#1:376\n217#1:377,5\n227#1:385\n227#1:386,3\n242#1:389\n242#1:390,2\n258#1:392\n258#1:393,5\n326#1:400\n326#1:401,2\n327#1:403\n327#1:404,3\n328#1:407,3\n137#1:360,2\n226#1:382\n226#1:383,2\n279#1:398,2\n*E\n"})
public final class KafkaUtil {
    @NotNull
    public static final KafkaUtil INSTANCE;
    @NotNull
    public static final String labelSeparator = ":";
    @NotNull
    public static final String keySeparator = ", ";
    @NotNull
    private static final String UNWIND;
    @NotNull
    private static final String WITH_EVENT_FROM;
    @NotNull
    private static final String LEADER;
    @NotNull
    private static final String SYSTEM_DATABASE_NAME;
    @Nullable
    private static final Class<?> coreMetadata;
    @Nullable
    private static final MethodHandle isLeaderMethodHandle;

    private KafkaUtil() {
    }

    @NotNull
    public static final String getUNWIND() {
        return UNWIND;
    }

    @JvmStatic
    public static /* synthetic */ void getUNWIND$annotations() {
    }

    @NotNull
    public static final String getWITH_EVENT_FROM() {
        return WITH_EVENT_FROM;
    }

    @JvmStatic
    public static /* synthetic */ void getWITH_EVENT_FROM$annotations() {
    }

    @NotNull
    public static final String getLEADER() {
        return LEADER;
    }

    @JvmStatic
    public static /* synthetic */ void getLEADER$annotations() {
    }

    @NotNull
    public static final String getSYSTEM_DATABASE_NAME() {
        return SYSTEM_DATABASE_NAME;
    }

    @JvmStatic
    public static /* synthetic */ void getSYSTEM_DATABASE_NAME$annotations() {
    }

    @JvmStatic
    private static /* synthetic */ void getCoreMetadata$annotations() {
    }

    @JvmStatic
    private static /* synthetic */ void isLeaderMethodHandle$annotations() {
    }

    @NotNull
    public final String clusterMemberRole(@NotNull GraphDatabaseAPI db) {
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        Function1 fallback2 = (Function1)new Function1<Exception, String>(db){
            final /* synthetic */ GraphDatabaseAPI $db;
            {
                this.$db = $db;
                super(1);
            }

            public final String invoke(@Nullable Exception e) {
                Unit unit;
                InternalLog userLog = ((LogService)this.$db.getDependencyResolver().resolveDependency(LogService.class)).getUserLog(KafkaUtil.class);
                Exception exception = e;
                if (exception != null) {
                    Exception it = exception;
                    boolean bl = false;
                    userLog.warn("Cannot call the APIs, trying with the cypher query", (Throwable)e);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                if (unit == null) {
                    userLog.warn("Cannot call the APIs, trying with the cypher query");
                }
                T t = GraphDatabaseServerExtensionsKt.execute((GraphDatabaseService)this.$db, "CALL dbms.cluster.role($database)", MapsKt.mapOf((Pair)TuplesKt.to((Object)"database", (Object)this.$db.databaseName())), clusterMemberRole.fallback.2.INSTANCE);
                Intrinsics.checkNotNullExpressionValue(t, (String)"execute(...)");
                return (String)t;
            }
        };
        Function0 execute2 = (Function0)new Function0<String>(db){
            final /* synthetic */ GraphDatabaseAPI $db;
            {
                this.$db = $db;
                super(0);
            }

            @NotNull
            public final String invoke() {
                String string;
                Class clazz = KafkaUtil.access$getCoreMetadata$p();
                if (clazz != null) {
                    String string2;
                    Class clazz2 = clazz;
                    GraphDatabaseAPI graphDatabaseAPI = this.$db;
                    Class it = clazz2;
                    boolean bl = false;
                    try {
                        Object object = graphDatabaseAPI.getDependencyResolver().resolveDependency(KafkaUtil.access$getCoreMetadata$p());
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"resolveDependency(...)");
                        Object raftMachine = object;
                        MethodHandle methodHandle = KafkaUtil.access$isLeaderMethodHandle$p();
                        Intrinsics.checkNotNull((Object)methodHandle);
                        boolean isLeader = methodHandle.invokeExact(raftMachine);
                        string2 = isLeader ? "LEADER" : "FOLLOWER";
                    }
                    catch (UnsatisfiedDependencyException e) {
                        string2 = "LEADER";
                    }
                    string = string2;
                } else {
                    string = "LEADER";
                }
                return string;
            }
        };
        return (String)this.executeOrFallback(execute2, fallback2);
    }

    public final boolean isCluster(@NotNull GraphDatabaseAPI db) {
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        return db.mode() != TopologyGraphDbmsModel.HostedOnMode.SINGLE && db.mode() != TopologyGraphDbmsModel.HostedOnMode.VIRTUAL;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isCluster(@NotNull DatabaseManagementService dbms) {
        Object v1;
        block1: {
            Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
            List list = dbms.listDatabases();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"listDatabases(...)");
            Iterable $this$firstOrNull$iv = list;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                if (!(!Intrinsics.areEqual((Object)it, (Object)SYSTEM_DATABASE_NAME))) continue;
                v1 = element$iv;
                break block1;
            }
            v1 = null;
        }
        String string = v1;
        if (string == null) return false;
        String it = string;
        boolean bl = false;
        GraphDatabaseService graphDatabaseService = dbms.database(it);
        Intrinsics.checkNotNull((Object)graphDatabaseService, (String)"null cannot be cast to non-null type org.neo4j.kernel.internal.GraphDatabaseAPI");
        GraphDatabaseAPI graphDatabaseAPI = (GraphDatabaseAPI)graphDatabaseService;
        if (graphDatabaseAPI == null) return false;
        GraphDatabaseAPI it2 = graphDatabaseAPI;
        boolean bl2 = false;
        boolean bl3 = INSTANCE.isCluster(it2);
        return bl3;
    }

    private final <T> T executeOrFallback(Function0<? extends T> execute2, Function1<? super Exception, ? extends T> fallback2) {
        Object object;
        try {
            object = execute2.invoke();
        }
        catch (Exception e) {
            object = fallback2.invoke((Object)e);
        }
        return (T)object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getLabelsAsString(@NotNull Collection<String> labels) {
        void var3_4;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(labels, (String)"labels");
        Iterable $this$map$iv = labels;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(CommonExtensionsKt.quote((String)it));
        }
        String it = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)labelSeparator, null, null, (int)0, null, null, (int)62, null);
        boolean bl = false;
        return !StringsKt.isBlank((CharSequence)it) ? labelSeparator + it : var3_4;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getNodeKeysAsString(@NotNull String prefix, @NotNull Set<String> keys) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        Iterable $this$map$iv = keys;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(INSTANCE.toQuotedProperty(prefix, (String)it));
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)keySeparator, null, null, (int)0, null, null, (int)62, null);
    }

    public static /* synthetic */ String getNodeKeysAsString$default(KafkaUtil kafkaUtil, String string, Set set, int n, Object object) {
        if ((n & 1) != 0) {
            string = "properties";
        }
        return kafkaUtil.getNodeKeysAsString(string, set);
    }

    private final String toQuotedProperty(String prefix, String property) {
        String quoted = CommonExtensionsKt.quote(property);
        return quoted + ": event." + prefix + "." + quoted;
    }

    static /* synthetic */ String toQuotedProperty$default(KafkaUtil kafkaUtil, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = "properties";
        }
        return kafkaUtil.toQuotedProperty(string, string2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getNodeMergeKeys(@NotNull String prefix, @NotNull Set<String> keys) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        Iterable $this$map$iv = keys;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String quoted = CommonExtensionsKt.quote((String)it);
            collection.add(quoted + ": event." + prefix + "." + quoted);
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)keySeparator, null, null, (int)0, null, null, (int)62, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean containsProp(@NotNull String key, @NotNull List<String> properties) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(properties, (String)"properties");
        if (StringsKt.contains$default((CharSequence)key, (CharSequence)".", (boolean)false, (int)2, null)) {
            String it;
            if (properties.contains(key)) return true;
            Iterable $this$any$iv = properties;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator = $this$any$iv.iterator();
            do {
                if (!iterator.hasNext()) return false;
                Object element$iv = iterator.next();
                it = (String)element$iv;
                boolean bl = false;
            } while (!StringsKt.startsWith$default((String)key, (String)(it + "."), (boolean)false, (int)2, null));
            return true;
        }
        boolean bl = properties.contains(key);
        return bl;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final <T> Object retryForException(@NotNull Class<? extends Throwable>[] var1_1, int var2_2, long var3_3, @NotNull Function0<? extends T> var5_4, @NotNull Continuation<? super T> var6_5) {
        block12: {
            block13: {
                if (!(var6_5 instanceof retryForException.1)) ** GOTO lbl-1000
                var18_6 = var6_5;
                if ((var18_6.label & -2147483648) != 0) {
                    var18_6.label -= -2147483648;
                } else lbl-1000:
                // 2 sources

                {
                    $continuation = new ContinuationImpl(this, var6_5){
                        Object L$0;
                        Object L$1;
                        Object L$2;
                        int I$0;
                        long J$0;
                        /* synthetic */ Object result;
                        final /* synthetic */ KafkaUtil this$0;
                        int label;
                        {
                            this.this$0 = this$0;
                            super($completion);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object $result) {
                            this.result = $result;
                            this.label |= Integer.MIN_VALUE;
                            return this.this$0.retryForException(null, 0, 0L, null, (Continuation)this);
                        }
                    };
                }
                $result = $continuation.result;
                var19_8 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch ($continuation.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        try {
                            var7_9 = action.invoke();
                            break block12;
                        }
                        catch (Exception e) {
                            $this$any$iv = exceptions;
                            $i$f$any = false;
                            for (void element$iv : $this$any$iv) {
                                it = (Class)element$iv;
                                $i$a$-any-KafkaUtil$retryForException$isInstance$1 = false;
                                if (!it.isInstance(e)) continue;
                                v0 = true;
                                ** GOTO lbl26
                            }
                            v0 = isInstance = false;
lbl26:
                            // 2 sources

                            if (!isInstance || retries <= 0) break;
                            $continuation.L$0 = this;
                            $continuation.L$1 = exceptions;
                            $continuation.L$2 = action;
                            $continuation.I$0 = retries;
                            $continuation.J$0 = delayTime;
                            $continuation.label = 1;
                            v1 = DelayKt.delay((long)delayTime, $continuation);
                            if (v1 == var19_8) {
                                return var19_8;
                            }
                            ** GOTO lbl45
                        }
                    }
                    case 1: {
                        delayTime = $continuation.J$0;
                        retries = $continuation.I$0;
                        action = (Function0)$continuation.L$2;
                        exceptions = (Class[])$continuation.L$1;
                        this = (KafkaUtil)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl45:
                        // 2 sources

                        $continuation.L$0 = null;
                        $continuation.L$1 = null;
                        $continuation.L$2 = null;
                        $continuation.label = 2;
                        v2 = this.retryForException(exceptions, retries - 1, delayTime, (Function0<? extends T>)action, (Continuation<? super T>)$continuation);
                        if (v2 == var19_8) {
                            return var19_8;
                        }
                        break block13;
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
                        break block13;
                    }
                }
                throw e;
            }
            var7_9 = v2;
        }
        return var7_9;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isServerReachable(@NotNull String url, int port) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        try {
            boolean bl2;
            Closeable closeable = new Socket(url, port);
            Throwable throwable = null;
            try {
                Socket it = (Socket)closeable;
                boolean bl3 = false;
                bl2 = true;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            bl = bl2;
        }
        catch (IOException e) {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> checkServersUnreachable(@NotNull String urls, @NotNull String separator) {
        URI uri;
        Iterable $this$filterTo$iv$iv;
        void it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)urls, (String)"urls");
        Intrinsics.checkNotNullParameter((Object)separator, (String)"separator");
        String[] stringArray = new String[]{separator};
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)urls, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            URI uRI;
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            URI uri2 = URI.create((String)it);
            CharSequence charSequence = uri2.getHost();
            boolean bl2 = charSequence == null || StringsKt.isBlank((CharSequence)charSequence);
            if (bl2) {
                String[] stringArray2 = new String[]{labelSeparator};
                List splitted = StringsKt.split$default((CharSequence)((CharSequence)it), (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
                uRI = new URI("fake-scheme", "", (String)CollectionsKt.first((List)splitted), Integer.parseInt((String)CollectionsKt.last((List)splitted)), "", "", "");
            } else {
                uRI = uri2;
            }
            collection.add(uRI);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            uri = (URI)element$iv$iv;
            boolean bl = false;
            String string = uri.getHost();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHost(...)");
            if (!(!INSTANCE.isServerReachable(string, uri.getPort()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Object object;
            uri = (URI)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)it.getScheme(), (Object)"fake-scheme")) {
                object = it.getHost() + labelSeparator + it.getPort();
            } else {
                String string = it.toString();
                object = string;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            }
            collection.add(object);
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List checkServersUnreachable$default(KafkaUtil kafkaUtil, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = ",";
        }
        return kafkaUtil.checkServersUnreachable(string, string2);
    }

    public final void validateConnection(@NotNull String url, @NotNull String kafkaPropertyKey, boolean checkReachable) {
        List unreachableServers;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)kafkaPropertyKey, (String)"kafkaPropertyKey");
        if (StringsKt.isBlank((CharSequence)url)) {
            throw new RuntimeException("The `kafka." + kafkaPropertyKey + "` property is empty");
        }
        if (checkReachable && !((Collection)(unreachableServers = KafkaUtil.checkServersUnreachable$default(this, url, null, 2, null))).isEmpty()) {
            throw new RuntimeException("The servers defined into the property `kafka." + kafkaPropertyKey + "` are not reachable: " + unreachableServers);
        }
    }

    public static /* synthetic */ void validateConnection$default(KafkaUtil kafkaUtil, String string, String string2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        kafkaUtil.validateConnection(string, string2, bl);
    }

    @NotNull
    public final String getInvalidTopicsError(@NotNull List<String> invalidTopics) {
        Intrinsics.checkNotNullParameter(invalidTopics, (String)"invalidTopics");
        return "The BROKER config `auto.create.topics.enable` is false, the following topics need to be created into the Kafka cluster otherwise the messages will be discarded: " + invalidTopics;
    }

    @NotNull
    public final List<String> getInvalidTopics(@NotNull Properties kafkaProps, @NotNull List<String> allTopics) {
        List<String> list;
        Intrinsics.checkNotNullParameter((Object)kafkaProps, (String)"kafkaProps");
        Intrinsics.checkNotNullParameter(allTopics, (String)"allTopics");
        try {
            AdminClient adminClient = AdminClient.create((Properties)kafkaProps);
            Intrinsics.checkNotNullExpressionValue((Object)adminClient, (String)"create(...)");
            list = this.getInvalidTopics(adminClient, allTopics);
        }
        catch (Exception e) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getInvalidTopics(@NotNull AdminClient client, @NotNull List<String> allTopics) {
        List list;
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter(allTopics, (String)"allTopics");
        try {
            void $this$filterTo$iv$iv;
            Set kafkaTopics = (Set)client.listTopics().names().get();
            Iterable $this$filter$iv = allTopics;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                if (!(!kafkaTopics.contains(it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List invalidTopics = (List)destination$iv$iv;
            list = !((Collection)invalidTopics).isEmpty() && this.isAutoCreateTopicsEnabled(client) ? CollectionsKt.emptyList() : invalidTopics;
        }
        catch (Exception e) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    public final void checkEnabled() {
        if (!ApocConfig.apocConfig().getBoolean("apoc.kafka.enabled")) {
            throw new RuntimeException("In order to use the Kafka procedures you must set apoc.kafka.enabled=true");
        }
    }

    public final boolean isAutoCreateTopicsEnabled(@NotNull Properties kafkaProps) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)kafkaProps, (String)"kafkaProps");
        try {
            AdminClient adminClient = AdminClient.create((Properties)kafkaProps);
            Intrinsics.checkNotNullExpressionValue((Object)adminClient, (String)"create(...)");
            bl = this.isAutoCreateTopicsEnabled(adminClient);
        }
        catch (Exception e) {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isAutoCreateTopicsEnabled(@NotNull AdminClient client) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        try {
            Object v2;
            Object object;
            block4: {
                void $this$flatMapTo$iv$iv;
                void $this$flatMap$iv;
                Object object2 = client.describeCluster().nodes().get();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
                int firstNodeId = ((Node)CollectionsKt.first((Iterable)((Iterable)object2))).id();
                List configResources = CollectionsKt.listOf((Object)new ConfigResource(ConfigResource.Type.BROKER, String.valueOf(firstNodeId)));
                Map configs = (Map)client.describeConfigs((Collection)configResources).all().get();
                object = configs.values();
                boolean $i$f$flatMap = false;
                Iterator iterator = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    Config it = (Config)element$iv$iv;
                    boolean bl2 = false;
                    Collection collection = it.entries();
                    Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"entries(...)");
                    Iterable list$iv$iv = collection;
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                Iterable iterable = (List)destination$iv$iv;
                for (Object t : iterable) {
                    ConfigEntry it = (ConfigEntry)t;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)it.name(), (Object)"auto.create.topics.enable")) continue;
                    v2 = t;
                    break block4;
                }
                v2 = null;
            }
            ConfigEntry configEntry = v2;
            bl = configEntry != null && (object = configEntry.value()) != null ? Boolean.parseBoolean((String)object) : false;
        }
        catch (Exception e) {
            bl = false;
        }
        return bl;
    }

    /*
     * Unable to fully structure code
     */
    private final Set<String> getConfigProperties(Class<?> clazz) {
        v0 = clazz.getDeclaredFields();
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getDeclaredFields(...)");
        $this$filter$iv = v0;
        $i$f$filter = false;
        var4_4 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (Field element$iv$iv : $this$filterTo$iv$iv) {
            it = element$iv$iv;
            $i$a$-filter-KafkaUtil$getConfigProperties$1 = false;
            if (!Modifier.isStatic(it.getModifiers())) ** GOTO lbl-1000
            v1 = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getName(...)");
            if (StringsKt.endsWith$default((String)v1, (String)"_CONFIG", (boolean)false, (int)2, null)) {
                v2 = true;
            } else lbl-1000:
            // 2 sources

            {
                v2 = false;
            }
            if (!v2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            element$iv$iv = (Field)item$iv$iv;
            var12_15 = destination$iv$iv;
            $i$a$-map-KafkaUtil$getConfigProperties$2 = false;
            var12_15.add(it.get(null).toString());
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    private final Set<String> getBaseConfigs() {
        Set<String> set = this.getConfigProperties(CommonClientConfigs.class);
        Set set2 = AdminClientConfig.configNames();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"configNames(...)");
        return SetsKt.plus((Set)SetsKt.plus((Set)SetsKt.plus((Set)SetsKt.plus(set, (Iterable)set2), (Iterable)this.getConfigProperties(SaslConfigs.class)), (Iterable)this.getConfigProperties(TopicConfig.class)), (Iterable)this.getConfigProperties(SslConfigs.class));
    }

    @NotNull
    public final Set<String> getProducerProperties() {
        Set set = ProducerConfig.configNames();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"configNames(...)");
        return SetsKt.minus((Set)set, (Iterable)this.getBaseConfigs());
    }

    @NotNull
    public final Set<String> getConsumerProperties() {
        Set set = ConsumerConfig.configNames();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"configNames(...)");
        return SetsKt.minus((Set)set, (Iterable)this.getBaseConfigs());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<String> getNodeKeys(@NotNull List<String> labels, @NotNull Set<String> propertyKeys, @NotNull List<Constraint> constraints2, @NotNull RelKeyStrategy keyStrategy) {
        Set set;
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter(labels, (String)"labels");
        Intrinsics.checkNotNullParameter(propertyKeys, (String)"propertyKeys");
        Intrinsics.checkNotNullParameter(constraints2, (String)"constraints");
        Intrinsics.checkNotNullParameter((Object)((Object)keyStrategy), (String)"keyStrategy");
        Iterable iterable = constraints2;
        boolean $i$f$filter = false;
        void var7_8 = $this$filter$iv;
        Function1[] destination$iv$iv = (Function1[])new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Constraint constraint = (Constraint)element$iv$iv;
            boolean bl = false;
            boolean bl2 = constraint.getType() == StreamsConstraintType.UNIQUE && propertyKeys.containsAll((Collection)constraint.getProperties()) && CollectionsKt.contains((Iterable)labels, (Object)constraint.getLabel());
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List it = (List)destination$iv$iv;
        boolean bl = false;
        switch (WhenMappings.$EnumSwitchMapping$0[keyStrategy.ordinal()]) {
            case 1: {
                destination$iv$iv = new Function1[]{getNodeKeys.2.1.INSTANCE, getNodeKeys.2.2.INSTANCE, getNodeKeys.2.3.INSTANCE};
                Constraint $i$f$filterTo2 = (Constraint)CollectionsKt.minWithOrNull((Iterable)it, (Comparator)ComparisonsKt.compareBy((Function1[])destination$iv$iv));
                set = $i$f$filterTo2 != null ? $i$f$filterTo2.getProperties() : null;
                if (set == null) {
                    set = SetsKt.emptySet();
                }
                break;
            }
            case 2: {
                void $this$flatMapTo$iv$iv;
                Iterable $this$flatMap$iv = it;
                boolean $i$f$flatMap = false;
                Iterable iterable2 = $this$flatMap$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    Constraint it2 = (Constraint)element$iv$iv;
                    boolean bl3 = false;
                    Iterable list$iv$iv = it2.getProperties();
                    CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
                }
                set = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return set;
    }

    public static /* synthetic */ Set getNodeKeys$default(KafkaUtil kafkaUtil, List list, Set set, List list2, RelKeyStrategy relKeyStrategy, int n, Object object) {
        if ((n & 8) != 0) {
            relKeyStrategy = RelKeyStrategy.DEFAULT;
        }
        return kafkaUtil.getNodeKeys(list, set, list2, relKeyStrategy);
    }

    @Nullable
    public final StreamsTransactionEvent toStreamsTransactionEvent(@NotNull StreamsSinkEntity streamsSinkEntity, @NotNull Function1<? super StreamsTransactionEvent, Boolean> evaluation) {
        StreamsTransactionEvent data2;
        Intrinsics.checkNotNullParameter((Object)streamsSinkEntity, (String)"streamsSinkEntity");
        Intrinsics.checkNotNullParameter(evaluation, (String)"evaluation");
        return streamsSinkEntity.getValue() != null ? (((Boolean)evaluation.invoke((Object)(data2 = JSONUtils.INSTANCE.asStreamsTransactionEvent(streamsSinkEntity.getValue())))).booleanValue() ? data2 : null) : null;
    }

    @Nullable
    public final <T> T ignoreExceptions(@NotNull Function0<? extends T> action, Class<? extends Throwable> ... toIgnore) {
        Object object;
        Intrinsics.checkNotNullParameter(action, (String)"action");
        Intrinsics.checkNotNullParameter(toIgnore, (String)"toIgnore");
        try {
            object = action.invoke();
        }
        catch (Throwable e) {
            boolean bl;
            block5: {
                if (toIgnore.length == 0) {
                    return null;
                }
                Class<? extends Throwable>[] $this$any$iv = toIgnore;
                boolean $i$f$any = false;
                int n = $this$any$iv.length;
                for (int i = 0; i < n; ++i) {
                    Class<? extends Throwable> element$iv;
                    Class<? extends Throwable> it = element$iv = $this$any$iv[i];
                    boolean bl2 = false;
                    if (!it.isInstance(e)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
            if (!bl) {
                throw e;
            }
            return null;
        }
        return (T)object;
    }

    public final boolean blockUntilFalseOrTimeout(long timeout, long delay, @NotNull Function0<Boolean> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        return (Boolean)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(action, timeout, delay, null){
            long J$0;
            int label;
            final /* synthetic */ Function0<Boolean> $action;
            final /* synthetic */ long $timeout;
            final /* synthetic */ long $delay;
            {
                this.$action = $action;
                this.$timeout = $timeout;
                this.$delay = $delay;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        start = System.currentTimeMillis();
                        success = (Boolean)this.$action.invoke();
lbl7:
                        // 2 sources

                        while (System.currentTimeMillis() - start < this.$timeout && !success) {
                            this.J$0 = start;
                            this.label = 1;
                            v0 = DelayKt.delay((long)this.$delay, (Continuation)((Continuation)this));
                            if (v0 == var5_2) {
                                return var5_2;
                            }
                            ** GOTO lbl19
                        }
                        break;
                    }
                    case 1: {
                        start = this.J$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl19:
                        // 2 sources

                        success = (Boolean)this.$action.invoke();
                        ** GOTO lbl7
                    }
                }
                return Boxing.boxBoolean((boolean)(success != false));
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Boolean> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    public static /* synthetic */ boolean blockUntilFalseOrTimeout$default(KafkaUtil kafkaUtil, long l, long l2, Function0 function0, int n, Object object) {
        if ((n & 2) != 0) {
            l2 = 1000L;
        }
        return kafkaUtil.blockUntilFalseOrTimeout(l, l2, (Function0<Boolean>)function0);
    }

    public final String getName(@NotNull GraphDatabaseService db) {
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        return db.databaseName();
    }

    public final boolean isWriteableInstance(@NotNull GraphDatabaseAPI db) {
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        return Util.isWriteableInstance((GraphDatabaseAPI)db);
    }

    private final boolean clusterHasLeader(GraphDatabaseAPI db) {
        boolean bl;
        try {
            Object t = GraphDatabaseServerExtensionsKt.execute((GraphDatabaseService)db, "CALL dbms.cluster.overview() YIELD databases\nRETURN databases[$database] AS role", MapsKt.mapOf((Pair)TuplesKt.to((Object)"database", (Object)db.databaseName())), clusterHasLeader.1.INSTANCE);
            Intrinsics.checkNotNull(t);
            bl = (Boolean)t;
        }
        catch (QueryExecutionException e) {
            if (StringsKt.equals((String)e.getStatusCode(), (String)"Neo.ClientError.Procedure.ProcedureNotFound", (boolean)true)) {
            }
            throw e;
        }
        return bl;
    }

    @Nullable
    public final <T> T executeInWriteableInstance(@NotNull GraphDatabaseAPI db, @NotNull Function0<? extends T> action) {
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        return (T)(this.isWriteableInstance(db) ? action.invoke() : null);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isClusterCorrectlyFormed(@NotNull DatabaseManagementService dbms) {
        boolean bl;
        block5: {
            void $this$mapTo$iv$iv;
            String it;
            Iterable $this$filterNotTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
            List list = dbms.listDatabases();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"listDatabases(...)");
            Iterable $this$filterNot$iv = list;
            boolean $i$f$filterNot = false;
            Iterable iterable = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                it = (String)element$iv$iv;
                boolean bl2 = false;
                if (Intrinsics.areEqual((Object)it, (Object)SYSTEM_DATABASE_NAME)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterNotTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                GraphDatabaseService graphDatabaseService = dbms.database(it);
                Intrinsics.checkNotNull((Object)graphDatabaseService, (String)"null cannot be cast to non-null type org.neo4j.kernel.internal.GraphDatabaseAPI");
                collection.add((GraphDatabaseAPI)graphDatabaseService);
            }
            Iterable $this$all$iv = (List)destination$iv$iv;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    GraphDatabaseAPI it2 = (GraphDatabaseAPI)element$iv;
                    boolean bl4 = false;
                    if (INSTANCE.clusterHasLeader(it2)) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
        }
        return bl;
    }

    public final void waitForTheLeaders(@NotNull DatabaseManagementService dbms, @NotNull Log log, long timeout, @NotNull Function0<Unit> action) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(dbms, timeout, log, action, null){
            long J$0;
            long J$1;
            int label;
            final /* synthetic */ DatabaseManagementService $dbms;
            final /* synthetic */ long $timeout;
            final /* synthetic */ Log $log;
            final /* synthetic */ Function0<Unit> $action;
            {
                this.$dbms = $dbms;
                this.$timeout = $timeout;
                this.$log = $log;
                this.$action = $action;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var6_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        start = System.currentTimeMillis();
                        delay = 2000L;
lbl7:
                        // 3 sources

                        while (!KafkaUtil.INSTANCE.isClusterCorrectlyFormed(this.$dbms) && System.currentTimeMillis() - start < this.$timeout) {
                            this.$log.info(KafkaUtil.getLEADER() + " not found, new check comes in " + delay + " milliseconds...");
                            this.J$0 = start;
                            this.J$1 = delay;
                            this.label = 1;
                            v0 = DelayKt.delay((long)delay, (Continuation)((Continuation)this));
                            if (v0 != var6_2) continue;
                            return var6_2;
                        }
                        break;
                    }
                    case 1: {
                        delay = this.J$1;
                        start = this.J$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
                        ** GOTO lbl7
                    }
                }
                this.$action.invoke();
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    public static /* synthetic */ void waitForTheLeaders$default(KafkaUtil kafkaUtil, DatabaseManagementService databaseManagementService, Log log, long l, Function0 function0, int n, Object object) {
        if ((n & 4) != 0) {
            l = 120000L;
        }
        kafkaUtil.waitForTheLeaders(databaseManagementService, log, l, (Function0<Unit>)function0);
    }

    public static final /* synthetic */ Class access$getCoreMetadata$p() {
        return coreMetadata;
    }

    public static final /* synthetic */ MethodHandle access$isLeaderMethodHandle$p() {
        return isLeaderMethodHandle;
    }

    static {
        MethodHandle methodHandle;
        Class<?> clazz;
        INSTANCE = new KafkaUtil();
        UNWIND = "UNWIND $events AS event";
        WITH_EVENT_FROM = "WITH event, from";
        LEADER = "LEADER";
        SYSTEM_DATABASE_NAME = "system";
        try {
            clazz = Class.forName("com.neo4j.causalclustering.core.consensus.CoreMetaData");
        }
        catch (ClassNotFoundException e) {
            clazz = null;
        }
        Class<?> clazz2 = coreMetadata = clazz;
        if (clazz2 != null) {
            Class<?> it = clazz2;
            boolean bl = false;
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            methodHandle = lookup.findVirtual(it, "isLeader", MethodType.methodType(Boolean.TYPE)).asType(MethodType.methodType(Boolean.TYPE, Object.class));
        } else {
            methodHandle = null;
        }
        isLeaderMethodHandle = methodHandle;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RelKeyStrategy.values().length];
            try {
                nArray[RelKeyStrategy.DEFAULT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RelKeyStrategy.ALL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

