/*
 * Decompiled with CFR 0.152.
 */
package apoc.load;

import apoc.Extended;
import apoc.Pools;
import apoc.export.util.CountingReader;
import apoc.export.util.ExportConfig;
import apoc.export.util.ProgressReporter;
import apoc.export.util.Reporter;
import apoc.load.util.XmlReadUtil;
import apoc.result.ExportProgressInfo;
import apoc.result.MapResult;
import apoc.result.ProgressInfo;
import apoc.util.FileUtils;
import apoc.util.Util;
import java.io.Reader;
import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.security.URLAccessChecker;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;
import org.neo4j.procedure.TerminationGuard;

@Extended
public class Gexf {
    @Context
    public GraphDatabaseService db;
    @Context
    public URLAccessChecker urlAccessChecker;
    @Context
    public TerminationGuard terminationGuard;
    @Context
    public Pools pools;

    @Procedure(value="apoc.load.gexf")
    @Description(value="apoc.load.gexf(urlOrBinary, path, $config) - load Gexf file from URL or binary source")
    public Stream<MapResult> gexf(@Name(value="urlOrBinary") Object urlOrBinary, @Name(value="config", defaultValue="{}") Map<String, Object> config) throws Exception {
        return XmlReadUtil.Load.xmlXpathToMapResult(urlOrBinary, this.urlAccessChecker, this.terminationGuard, config);
    }

    @Procedure(name="apoc.import.gexf", mode=Mode.WRITE)
    @Description(value="Imports a graph from the provided GraphML file.")
    public Stream<ExportProgressInfo> importGexf(@Name(value="urlOrBinaryFile") Object urlOrBinaryFile, @Name(value="config") Map<String, Object> config) {
        ExportProgressInfo result = (ExportProgressInfo)Util.inThread((Pools)this.pools, () -> {
            ExportConfig exportConfig = new ExportConfig(config);
            String file = null;
            String source = "binary";
            if (urlOrBinaryFile instanceof String) {
                file = (String)urlOrBinaryFile;
                source = "file";
            }
            ProgressReporter reporter = new ProgressReporter(null, null, (ProgressInfo)new ExportProgressInfo(file, source, "gexf"));
            XmlReadUtil.Import graphReader = new XmlReadUtil.Import(this.db).reporter((Reporter)reporter).batchSize(exportConfig.getBatchSize()).relType(exportConfig.defaultRelationshipType()).source(exportConfig.getSource()).target(exportConfig.getTarget()).nodeLabels(exportConfig.readLabels());
            if (exportConfig.storeNodeIds()) {
                graphReader.storeNodeIds();
            }
            try (CountingReader reader = FileUtils.readerFor((Object)urlOrBinaryFile, (String)exportConfig.getCompressionAlgo(), (URLAccessChecker)this.urlAccessChecker);){
                graphReader.parseXML((Reader)reader, this.terminationGuard);
            }
            return (ExportProgressInfo)reporter.getTotal();
        });
        return Stream.of(result);
    }
}

