/*
 * Decompiled with CFR 0.152.
 */
package apoc.load;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;

public class LoadDirectoryItem {
    public static final String LISTEN_EVENT_TYPE = "listenEventType";
    public static final String INTERVAL = "interval";
    public static final Set<String> DEFAULT_EVENT_TYPES = Set.of("CREATE", "DELETE", "MODIFY");
    private final String pattern;
    private final String cypher;
    private final String name;
    private final String urlDir;
    private final LoadDirectoryConfig config;
    private final AtomicReference<Status> status;
    private AtomicReference<String> error;

    public LoadDirectoryItem(String name) {
        this(name, null, null, null, null);
    }

    public LoadDirectoryItem(String name, String pattern, String cypher, String urlDir, LoadDirectoryConfig config) {
        this.name = name;
        this.cypher = cypher;
        this.pattern = pattern;
        this.urlDir = urlDir;
        this.config = config;
        this.status = new AtomicReference<Status>(Status.CREATED);
        this.error = new AtomicReference<String>("");
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getCypher() {
        return this.cypher;
    }

    public String getName() {
        return this.name;
    }

    public String getUrlDir() {
        return this.urlDir;
    }

    public LoadDirectoryConfig getConfig() {
        return this.config;
    }

    public synchronized void setError(String errorMessage) {
        this.error.set(errorMessage);
        this.status.set(Status.ERROR);
    }

    public void setStatusRunning() {
        this.status.set(Status.RUNNING);
    }

    public synchronized LoadDirectoryResult toResult() {
        return new LoadDirectoryResult(this.name, this.status.get().name(), this.pattern, this.cypher, this.urlDir, this.config, this.error.get());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LoadDirectoryItem that = (LoadDirectoryItem)o;
        return Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public static class LoadDirectoryConfig {
        private final List<String> listenEventType;
        private final Long interval;

        public LoadDirectoryConfig(Map<String, Object> config) {
            if (config == null) {
                config = Collections.emptyMap();
            }
            this.interval = (Long)config.getOrDefault(LoadDirectoryItem.INTERVAL, 1000L);
            this.listenEventType = config.getOrDefault(LoadDirectoryItem.LISTEN_EVENT_TYPE, new ArrayList<String>(DEFAULT_EVENT_TYPES));
        }

        public List<String> getListenEventType() {
            return this.listenEventType;
        }

        public Long getInterval() {
            return this.interval;
        }
    }

    static enum Status {
        RUNNING,
        CREATED,
        ERROR;

    }

    public static class LoadDirectoryResult {
        public final String name;
        public final String status;
        public final String pattern;
        public final String cypher;
        public final String urlDir;
        public final Map<String, Object> config;
        public final String error;

        public LoadDirectoryResult(String name, String status2, String pattern, String cypher, String urlDir, LoadDirectoryConfig configClass, String error) {
            this.name = name;
            this.status = status2;
            this.pattern = pattern;
            this.cypher = cypher;
            this.urlDir = urlDir;
            this.config = Map.of(LoadDirectoryItem.LISTEN_EVENT_TYPE, configClass.getListenEventType(), LoadDirectoryItem.INTERVAL, configClass.getInterval());
            this.error = error;
        }
    }
}

