/*
 * Decompiled with CFR 0.152.
 */
package apoc.load;

import apoc.Extended;
import apoc.load.HtmlResultInterface;
import apoc.load.LoadHtmlBrowser;
import apoc.load.LoadHtmlConfig;
import apoc.result.MapResult;
import apoc.util.FileUtils;
import apoc.util.MissingDependencyException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.security.URLAccessChecker;
import org.neo4j.graphdb.security.URLAccessValidationError;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@Extended
public class LoadHtml {
    public static final String KEY_ERROR = "errorList";
    public static final String INVALID_CONFIG_ERR = "Invalid config: ";
    public static final String UNSUPPORTED_CHARSET_ERR = "Unsupported charset: ";
    public static final String SELENIUM_MISSING_DEPS_ERROR = "Cannot find the Selenium client jar.\nPlease put the apoc-selenium-dependencies-5.x.x-all.jar into plugin folder.\nSee the documentation: https://neo4j.com/labs/apoc/5/overview/apoc.load/apoc.load.html/#selenium-dependencies";
    @Context
    public GraphDatabaseService db;
    @Context
    public Log log;
    @Context
    public URLAccessChecker urlAccessChecker;

    @Procedure
    @Description(value="apoc.load.htmlPlainText('urlOrHtml',{name: jquery, name2: jquery}, config) YIELD value - Load Html page and return the result as a Map")
    public Stream<MapResult> htmlPlainText(@Name(value="urlOrHtml") String urlOrHtml, @Name(value="query", defaultValue="{}") Map<String, String> query, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        return this.readHtmlPage(urlOrHtml, query, config, HtmlResultInterface.Type.PLAIN_TEXT);
    }

    @Procedure
    @Description(value="apoc.load.html('url',{name: jquery, name2: jquery}, config) YIELD value - Load Html page and return the result as a Map")
    public Stream<MapResult> html(@Name(value="url") String url, @Name(value="query", defaultValue="{}") Map<String, String> query, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        return this.readHtmlPage(url, query, config, HtmlResultInterface.Type.DEFAULT);
    }

    private Stream<MapResult> readHtmlPage(String url, Map<String, String> query, Map<String, Object> conf, HtmlResultInterface.Type type) {
        LoadHtmlConfig config = new LoadHtmlConfig(conf);
        try {
            Document document = config.isHtmlString() ? Jsoup.parseBodyFragment((String)url) : Jsoup.parse((InputStream)this.getHtmlInputStream(url, query, config), (String)config.getCharset(), (String)config.getBaseUri());
            HashMap output = new HashMap();
            ArrayList errorList = new ArrayList();
            query.keySet().forEach(key -> {
                Object value = type.get().getResult(document, (String)query.get(key), config, errorList, this.log);
                output.put((String)key, value);
            });
            if (!errorList.isEmpty()) {
                output.put(KEY_ERROR, errorList);
            }
            return Stream.of(new MapResult(output));
        }
        catch (UnsupportedCharsetException e) {
            throw new RuntimeException(UNSUPPORTED_CHARSET_ERR + config.getCharset());
        }
        catch (ClassCastException | IllegalArgumentException e) {
            throw new RuntimeException(INVALID_CONFIG_ERR + e.getMessage());
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("File not found from: " + url);
        }
        catch (Exception e) {
            throw new RuntimeException("Can't read the HTML from: " + url, e);
        }
    }

    private InputStream getHtmlInputStream(String url, Map<String, String> query, LoadHtmlConfig config) throws IOException, URISyntaxException, URLAccessValidationError {
        boolean isHeadless = config.isHeadless();
        boolean isAcceptInsecureCerts = config.isAcceptInsecureCerts();
        switch (config.getBrowser()) {
            case FIREFOX: {
                return this.withSeleniumBrowser(() -> LoadHtmlBrowser.getFirefoxInputStream(url, query, config, isHeadless, isAcceptInsecureCerts));
            }
            case CHROME: {
                return this.withSeleniumBrowser(() -> LoadHtmlBrowser.getChromeInputStream(url, query, config, isHeadless, isAcceptInsecureCerts));
            }
        }
        return FileUtils.inputStreamFor((Object)url, null, null, null, (URLAccessChecker)this.urlAccessChecker);
    }

    public static List<Map<String, Object>> getElements(Elements elements, LoadHtmlConfig conf, List<String> errorList, Log log) {
        ArrayList<Map<String, Object>> elementList = new ArrayList<Map<String, Object>>();
        for (Element element : elements) {
            LoadHtml.withError(element, errorList, conf.getFailSilently(), log, () -> {
                HashMap<String, Object> result = new HashMap<String, Object>();
                if (element.attributes().size() > 0) {
                    result.put("attributes", LoadHtml.getAttributes(element));
                }
                if (!element.data().isEmpty()) {
                    result.put("data", element.data());
                }
                if (!element.val().isEmpty()) {
                    result.put("value", element.val());
                }
                if (!element.tagName().isEmpty()) {
                    result.put("tagName", element.tagName());
                }
                if (conf.isChildren()) {
                    if (element.hasText()) {
                        result.put("text", element.ownText());
                    }
                    result.put("children", LoadHtml.getElements(element.children(), conf, errorList, log));
                } else if (element.hasText()) {
                    result.put("text", element.text());
                }
                elementList.add(result);
                return null;
            });
        }
        return elementList;
    }

    private static Map<String, String> getAttributes(Element element) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        for (Attribute attribute : element.attributes()) {
            if (!attribute.hasDeclaredValue() && !Attribute.isBooleanAttribute((String)attribute.getKey())) {
                throw new RuntimeException("Invalid tag " + String.valueOf(element));
            }
            if (attribute.getValue().isBlank()) continue;
            String key = attribute.getKey();
            boolean attributeHasLink = key.equals("href") || key.equals("src");
            String attr = null;
            if (attributeHasLink) {
                attr = element.absUrl(key);
                if (StringUtils.isBlank((CharSequence)attr)) {
                    attr = attribute.getValue();
                }
            } else {
                attr = attribute.getValue();
            }
            attributes.put(key, attr);
        }
        return attributes;
    }

    public static <T> T withError(Element element, List<String> errorList, LoadHtmlConfig.FailSilently failConfig, Log log, Supplier<T> fun) {
        try {
            return fun.get();
        }
        catch (Exception e) {
            String parseError = "Error during parsing element: " + String.valueOf(element);
            switch (failConfig) {
                case WITH_LOG: {
                    log.warn(parseError);
                    break;
                }
                case WITH_LIST: {
                    errorList.add(element.toString());
                    break;
                }
                default: {
                    throw new RuntimeException(parseError);
                }
            }
            return null;
        }
    }

    private InputStream withSeleniumBrowser(Supplier<InputStream> action) {
        try {
            return action.get();
        }
        catch (NoClassDefFoundError e) {
            throw new MissingDependencyException(SELENIUM_MISSING_DEPS_ERROR);
        }
    }
}

