/*
 * Decompiled with CFR 0.152.
 */
package apoc.load;

import apoc.Extended;
import apoc.load.LoadJsonUtils;
import apoc.result.LoadDataMapResult;
import apoc.util.CompressionAlgo;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.graphdb.security.URLAccessChecker;
import org.neo4j.kernel.api.QueryLanguage;
import org.neo4j.kernel.api.procedure.QueryLanguageScope;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;
import org.neo4j.procedure.TerminationGuard;

@Extended
public class LoadJsonExtended {
    @Context
    public TerminationGuard terminationGuard;
    @Context
    public URLAccessChecker urlAccessChecker;

    @Procedure(name="apoc.load.jsonParams")
    @QueryLanguageScope(scope={QueryLanguage.CYPHER_25})
    @Description(value="Loads parameters from a JSON URL (e.g. web-API) as a stream of values if the given JSON file is a `LIST<ANY>`.\nIf the given JSON file is a `MAP`, this procedure imports a single value instead.")
    public Stream<LoadDataMapResult> jsonParams(@Name(value="urlOrKeyOrBinary", description="The name of the file or binary data to import the data from.") Object urlOrKeyOrBinary, @Name(value="headers", description="Headers to be used when connecting to the given URL.") Map<String, Object> headers, @Name(value="payload", description="The payload to send when connecting to the given URL.") String payload, @Name(value="path", defaultValue="", description="A JSON path expression used to extract a certain part from the list.") String path, @Name(value="config", defaultValue="{}", description="{\n    failOnError = true :: BOOLEAN,\n    pathOptions :: LIST<STRING>,\n    compression = \"\"NONE\"\" :: [\"\"NONE\"\", \"\"BYTES\"\", \"\"GZIP\"\", \"\"BZIP2\"\", \"\"DEFLATE\"\", \"\"BLOCK_LZ4\"\", \"\"FRAMED_SNAPPY\u201d]\n}\n") Map<String, Object> config) {
        if (config == null) {
            config = Collections.emptyMap();
        }
        boolean failOnError = (Boolean)config.getOrDefault("failOnError", true);
        String compressionAlgo = (String)config.getOrDefault("compression", CompressionAlgo.NONE.name());
        List pathOptions = (List)config.get("pathOptions");
        return LoadJsonUtils.loadJsonStream((Object)urlOrKeyOrBinary, headers, (String)payload, (String)path, (boolean)failOnError, (String)compressionAlgo, (List)pathOptions, (TerminationGuard)this.terminationGuard, (URLAccessChecker)this.urlAccessChecker);
    }
}

